/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.Policy;

class Binding {
    private final Set<Pattern> rootPatterns = new HashSet<Pattern>();
    private final Set<Pattern> includePatterns = new HashSet<Pattern>();
    private final Set<Pattern> excludePatterns = new HashSet<Pattern>();
    private final String TAG_EXTENSION;
    private final Map<String, Boolean> knownIds = new HashMap<String, Boolean>();
    private final Map<String, Boolean> knownRootIds = new HashMap<String, Boolean>();

    protected Binding(String tagExtension) {
        this.TAG_EXTENSION = tagExtension;
    }

    boolean isVisibleExtension(String anExtensionId) {
        if (this.knownIds.containsKey(anExtensionId)) {
            return this.knownIds.get(anExtensionId);
        }
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(anExtensionId).matches()) continue;
            this.knownIds.put(anExtensionId, Boolean.FALSE);
            if (Policy.DEBUG_RESOLUTION) {
                System.out.println("Viewer Binding: EXCLUDED: " + this.TAG_EXTENSION + " to: " + anExtensionId);
            }
            return false;
        }
        for (Pattern pattern : this.includePatterns) {
            if (!pattern.matcher(anExtensionId).matches()) continue;
            this.knownIds.put(anExtensionId, Boolean.TRUE);
            if (Policy.DEBUG_RESOLUTION) {
                System.out.println("Viewer Binding: " + this.TAG_EXTENSION + " to: " + anExtensionId);
            }
            return true;
        }
        if (Policy.DEBUG_RESOLUTION) {
            System.out.println("Viewer Binding: NOT FOUND: " + this.TAG_EXTENSION + " to: " + anExtensionId);
        }
        this.knownIds.put(anExtensionId, Boolean.FALSE);
        return false;
    }

    boolean isRootExtension(String anExtensionId) {
        if (this.rootPatterns.size() == 0) {
            return false;
        }
        if (this.knownRootIds.containsKey(anExtensionId)) {
            return this.knownRootIds.get(anExtensionId);
        }
        Pattern pattern2 = null;
        for (Pattern pattern2 : this.rootPatterns) {
            if (!pattern2.matcher(anExtensionId).matches()) continue;
            this.knownRootIds.put(anExtensionId, Boolean.TRUE);
            return true;
        }
        this.knownRootIds.put(anExtensionId, Boolean.FALSE);
        return false;
    }

    boolean hasOverriddenRootExtensions() {
        return this.rootPatterns.size() > 0;
    }

    void consumeIncludes(IConfigurationElement element, boolean toRespectRoots) {
        Assert.isTrue((boolean)"includes".equals(element.getName()));
        IConfigurationElement[] contentExtensionPatterns = element.getChildren(this.TAG_EXTENSION);
        String isRootString = null;
        boolean isRoot = false;
        String patternString = null;
        Pattern compiledPattern = null;
        IConfigurationElement[] iConfigurationElementArray = contentExtensionPatterns;
        int n = contentExtensionPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contentExtensionPattern = iConfigurationElementArray[n2];
            if (toRespectRoots) {
                isRootString = contentExtensionPattern.getAttribute("isRoot");
                boolean bl = isRoot = isRootString != null ? Boolean.valueOf(isRootString.trim()) : false;
            }
            if ((patternString = contentExtensionPattern.getAttribute("pattern")) == null) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new Object[]{"pattern", element.getDeclaringExtension().getUniqueIdentifier(), element.getDeclaringExtension().getNamespaceIdentifier()}), null);
            } else {
                compiledPattern = Pattern.compile(patternString);
                this.includePatterns.add(compiledPattern);
                this.knownIds.clear();
                if (toRespectRoots && isRoot) {
                    this.rootPatterns.add(compiledPattern);
                }
            }
            ++n2;
        }
    }

    void consumeExcludes(IConfigurationElement element) {
        Assert.isTrue((boolean)"excludes".equals(element.getName()));
        IConfigurationElement[] contentExtensionPatterns = element.getChildren(this.TAG_EXTENSION);
        String patternString = null;
        Pattern compiledPattern = null;
        IConfigurationElement[] iConfigurationElementArray = contentExtensionPatterns;
        int n = contentExtensionPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contentExtensionPattern = iConfigurationElementArray[n2];
            patternString = contentExtensionPattern.getAttribute("pattern");
            if (patternString == null) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new Object[]{"pattern", element.getDeclaringExtension().getUniqueIdentifier(), element.getDeclaringExtension().getNamespaceIdentifier()}), null);
            } else {
                compiledPattern = Pattern.compile(patternString);
                this.excludePatterns.add(compiledPattern);
                this.knownIds.clear();
            }
            ++n2;
        }
    }

    void addBinding(Binding otherBinding) {
        this.includePatterns.addAll(otherBinding.includePatterns);
        this.excludePatterns.addAll(otherBinding.excludePatterns);
        this.rootPatterns.addAll(otherBinding.rootPatterns);
    }
}

