/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.remote.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportConnectionNodeElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfileElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceGroupElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.ManifestReader;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RemoteImportProfilesReader {
    private static final String SCHEMA_FOLDER_NAME = "schema";
    private static final String PROFILES_SCHEMA_FILE_NAME = "remote-profile.xsd";
    private static final @NonNull TracePackageElement @NonNull [] EMPTY_ARRAY = new TracePackageElement[0];

    public static void validate(InputStream input) throws IOException, SAXException {
        URL schemaFileUrl = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(SCHEMA_FOLDER_NAME).append(PROFILES_SCHEMA_FILE_NAME), null);
        if (schemaFileUrl == null) {
            throw new IOException(MessageFormat.format(Messages.TracePackageExtractManifestOperation_SchemaFileNotFound, PROFILES_SCHEMA_FILE_NAME));
        }
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(schemaFileUrl.openStream()));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(input));
        }
        catch (SAXException e) {
            throw new SAXException(Messages.TracePackageExtractManifestOperation_ErrorManifestNotValid, e);
        }
        catch (IOException e) {
            throw new IOException(Messages.TracePackageExtractManifestOperation_ErrorManifestNotValid, e);
        }
    }

    public static TracePackageElement[] loadElementsFromProfiles(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        ArrayList<RemoteImportProfileElement> packageElements = new ArrayList<RemoteImportProfileElement>();
        RemoteImportProfileElement profile = null;
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        NodeList profileNodes = doc.getDocumentElement().getElementsByTagName("profile");
        int i = 0;
        while (i < profileNodes.getLength()) {
            Node profileNode = profileNodes.item(i);
            if (profileNode.getNodeType() == 1) {
                Element profileElement = (Element)profileNode;
                String traceName = profileElement.getAttribute("name");
                profile = new RemoteImportProfileElement(null, traceName);
                NodeList nodeNodes = profileElement.getElementsByTagName("node");
                int j = 0;
                while (j < nodeNodes.getLength()) {
                    Node nodeNode = nodeNodes.item(j);
                    if (nodeNode.getNodeType() == 1) {
                        Element nodeElement = (Element)nodeNode;
                        String nameAttr = nodeElement.getAttribute("name");
                        NodeList uriNodes = nodeElement.getElementsByTagName("uri");
                        String uri = "";
                        int k = 0;
                        while (k < uriNodes.getLength()) {
                            Node uriNode = uriNodes.item(k);
                            if (uriNode.getNodeType() == 1) {
                                Element uriElement = (Element)uriNode;
                                uri = uriElement.getFirstChild().getNodeValue();
                                break;
                            }
                            ++k;
                        }
                        RemoteImportConnectionNodeElement connectionNode = new RemoteImportConnectionNodeElement(profile, nameAttr, uri);
                        NodeList traceGroupNodes = nodeElement.getElementsByTagName("traceGroup");
                        int k2 = 0;
                        while (k2 < traceGroupNodes.getLength()) {
                            Node traceGroupNode = traceGroupNodes.item(k2);
                            if (traceGroupNode.getNodeType() == 1) {
                                TracePackageElement[] e;
                                Element traceGroupElement = (Element)traceGroupNode;
                                String rootAttr = traceGroupElement.getAttribute("root");
                                String recursiveAttr = traceGroupElement.getAttribute("recursive");
                                RemoteImportTraceGroupElement traceGroup = new RemoteImportTraceGroupElement(connectionNode, rootAttr);
                                traceGroup.setRecursive(Boolean.TRUE.toString().equals(recursiveAttr));
                                TracePackageElement[] tracePackageElementArray = e = ManifestReader.loadElementsFromNode((Element)traceGroupElement);
                                int n = e.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TracePackageElement a = tracePackageElementArray[n2];
                                    traceGroup.addChild(a);
                                    ++n2;
                                }
                            }
                            ++k2;
                        }
                    }
                    ++j;
                }
                packageElements.add(profile);
            }
            ++i;
        }
        return packageElements.toArray(EMPTY_ARRAY);
    }
}

