/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.tree;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfTimeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;

public abstract class AbstractTmfTreeViewer
extends TmfTimeViewer {
    private final TreeViewer fTreeViewer;

    public AbstractTmfTreeViewer(Composite parent, boolean allowMultiSelect) {
        this(parent, new TreeViewer(parent, 0x10100 | (allowMultiSelect ? 2 : 0)));
    }

    public AbstractTmfTreeViewer(Composite parent, TreeViewer treeViewer) {
        super(parent);
        this.fTreeViewer = treeViewer;
        this.fTreeViewer.setAutoExpandLevel(-1);
        Tree tree = this.fTreeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.fTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        List<TmfTreeColumnData> columns = this.getColumnDataProvider().getColumnData();
        this.setTreeColumns(columns);
    }

    protected abstract ITmfTreeColumnDataProvider getColumnDataProvider();

    public void setTreeColumns(final List<TmfTreeColumnData> columns) {
        boolean hasPercentProvider = false;
        for (TmfTreeColumnData columnData : columns) {
            columnData.createColumn(this.fTreeViewer);
            hasPercentProvider |= columnData.getPercentageProvider() != null;
        }
        if (hasPercentProvider) {
            this.fTreeViewer.getTree().addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    if (((TmfTreeColumnData)columns.get(event.index)).getPercentageProvider() != null) {
                        double percentage = ((TmfTreeColumnData)columns.get(event.index)).getPercentageProvider().getPercentage(event.item.getData());
                        if (percentage == 0.0) {
                            return;
                        }
                        if ((event.detail & 2) > 0) {
                            event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                            event.detail &= 0xFFFFFFFD;
                        }
                        int barWidth = (int)((double)(AbstractTmfTreeViewer.this.fTreeViewer.getTree().getColumn(event.index).getWidth() - 8) * percentage);
                        int oldAlpha = event.gc.getAlpha();
                        Color oldForeground = event.gc.getForeground();
                        Color oldBackground = event.gc.getBackground();
                        event.gc.setAlpha(64);
                        event.gc.setForeground(event.item.getDisplay().getSystemColor(9));
                        event.gc.setBackground(event.item.getDisplay().getSystemColor(25));
                        event.gc.fillGradientRectangle(event.x, event.y, barWidth, event.height, true);
                        event.gc.drawRectangle(event.x, event.y, barWidth, event.height);
                        event.gc.setForeground(oldForeground);
                        event.gc.setBackground(oldBackground);
                        event.gc.setAlpha(oldAlpha);
                        event.detail &= 0xFFFFFFF7;
                    }
                }
            });
        }
    }

    protected void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fTreeViewer.setLabelProvider(labelProvider);
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    @Override
    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    @Override
    public void refresh() {
        Tree tree = this.fTreeViewer.getTree();
        tree.setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
        tree.setRedraw(true);
    }

    @Override
    public void loadTrace(final ITmfTrace trace) {
        super.loadTrace(trace);
        if (trace == null) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                AbstractTmfTreeViewer.this.initializeDataSource(trace);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!trace.equals(AbstractTmfTreeViewer.this.getTrace())) {
                            return;
                        }
                        AbstractTmfTreeViewer.this.clearContent();
                        AbstractTmfTreeViewer.this.updateContent(AbstractTmfTreeViewer.this.getWindowStartTime(), AbstractTmfTreeViewer.this.getWindowEndTime(), false);
                    }
                });
            }
        };
        thread.start();
    }

    public void setSelection(@NonNull List<ITmfTreeViewerEntry> selection) {
        StructuredSelection sel = new StructuredSelection(selection);
        this.fTreeViewer.setSelection((ISelection)sel, true);
    }

    public void addSelectionChangeListener(ISelectionChangedListener listener) {
        this.fTreeViewer.addSelectionChangedListener(listener);
    }

    @Deprecated
    protected void initializeDataSource() {
    }

    protected void initializeDataSource(@NonNull ITmfTrace trace) {
    }

    protected void clearContent() {
        this.fTreeViewer.setInput(null);
    }

    protected void contentChanged(ITmfTreeViewerEntry rootEntry) {
    }

    protected void updateContent(final long start, final long end, final boolean isSelection) {
        final ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        Job thread = new Job(""){

            public IStatus run(IProgressMonitor monitor) {
                final ITmfTreeViewerEntry rootEntry = AbstractTmfTreeViewer.this.updateElements(trace, start, end, isSelection);
                if (rootEntry != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (AbstractTmfTreeViewer.this.fTreeViewer.getControl().isDisposed()) {
                                return;
                            }
                            if (rootEntry != AbstractTmfTreeViewer.this.fTreeViewer.getInput()) {
                                AbstractTmfTreeViewer.this.fTreeViewer.setInput((Object)rootEntry);
                                AbstractTmfTreeViewer.this.contentChanged(rootEntry);
                            } else {
                                AbstractTmfTreeViewer.this.fTreeViewer.refresh();
                                AbstractTmfTreeViewer.this.fTreeViewer.expandToLevel(AbstractTmfTreeViewer.this.fTreeViewer.getAutoExpandLevel());
                            }
                            TreeColumn[] treeColumnArray = AbstractTmfTreeViewer.this.fTreeViewer.getTree().getColumns();
                            int n = treeColumnArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeColumn column = treeColumnArray[n2];
                                column.pack();
                                ++n2;
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        thread.setSystem(true);
        thread.schedule();
    }

    @Deprecated
    protected ITmfTreeViewerEntry updateElements(long start, long end, boolean isSelection) {
        throw new UnsupportedOperationException();
    }

    protected ITmfTreeViewerEntry updateElements(@NonNull ITmfTrace trace, long start, long end, boolean isSelection) {
        return this.updateElements(start, end, isSelection);
    }

    protected ITmfTreeViewerEntry getInput() {
        return (ITmfTreeViewerEntry)this.fTreeViewer.getInput();
    }

    @Override
    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        super.windowRangeUpdated(signal);
        this.updateContent(this.getWindowStartTime(), this.getWindowEndTime(), false);
    }

    @Override
    public void reset() {
        super.reset();
        this.clearContent();
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ITmfTreeViewerEntry) {
                return ((ITmfTreeViewerEntry)inputElement).getChildren().toArray(new ITmfTreeViewerEntry[0]);
            }
            return new ITmfTreeViewerEntry[0];
        }

        public Object[] getChildren(Object parentElement) {
            ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)parentElement;
            List<? extends ITmfTreeViewerEntry> children = entry.getChildren();
            return children.toArray(new ITmfTreeViewerEntry[children.size()]);
        }

        public Object getParent(Object element) {
            ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)element;
            return entry.getParent();
        }

        public boolean hasChildren(Object element) {
            ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)element;
            return entry.hasChildren();
        }
    }

    protected static class TreeLabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    ITableColorProvider {
        protected TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ITmfTreeViewerEntry && columnIndex == 0) {
                ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)element;
                return entry.getName();
            }
            return new String();
        }

        public Color getForeground(Object element, int columnIndex) {
            return Display.getCurrent().getSystemColor(24);
        }

        public Color getBackground(Object element, int columnIndex) {
            return Display.getCurrent().getSystemColor(25);
        }

        public Font getFont(Object element, int columnIndex) {
            return null;
        }
    }
}

