/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.presentation;

public class RGBColor {
    private final short fRed;
    private final short fGreen;
    private final short fBlue;

    public RGBColor(int red, int green, int blue) {
        if (red > 255 || red < 0) {
            throw new IllegalArgumentException("Red component must be between 0 and 255");
        }
        if (green > 255 || green < 0) {
            throw new IllegalArgumentException("Green component must be between 0 and 255");
        }
        if (blue > 255 || blue < 0) {
            throw new IllegalArgumentException("Blue component must be between 0 and 255");
        }
        this.fRed = (short)red;
        this.fGreen = (short)green;
        this.fBlue = (short)blue;
    }

    public RGBColor(int color) {
        this.fRed = (short)(color >> 16 & 0xFF);
        this.fGreen = (short)(color >> 8 & 0xFF);
        this.fBlue = (short)(color & 0xFF);
    }

    public int getRed() {
        return this.fRed;
    }

    public int getGreen() {
        return this.fGreen;
    }

    public int getBlue() {
        return this.fBlue;
    }
}

