/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    int x;
    int y;
    boolean hasLocation;
    MenuItem cascade;
    MenuItem selectedItem;
    Decorations parent;
    int imItem;
    int imSeparator;
    int imHandle;
    ImageList imageList;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    void _setVisible(boolean visible) {
        if (visible == OS.gtk_widget_get_mapped(this.handle)) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.getItemCount() != 0) {
                if ((this.parent._getShell().style & 0x4000) != 0) {
                    OS.gtk_menu_shell_set_take_focus(this.handle, false);
                }
                int address = 0;
                this.hasLocation = false;
                int data = 0;
                TrayItem item = this.display.currentTrayItem;
                if (item != null && !item.isDisposed()) {
                    data = item.handle;
                    address = OS.gtk_status_icon_position_menu_func();
                }
                OS.gtk_menu_popup(this.handle, 0, 0, address, data, 0, this.display.getLastEventTime());
            } else {
                this.sendEvent(23);
            }
        } else {
            OS.gtk_menu_popdown(this.handle);
        }
    }

    void addAccelerators(int accelGroup) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.addAccelerators(accelGroup);
            ++i;
        }
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        if ((this.style & 2) != 0) {
            this.handle = OS.gtk_menu_bar_new();
            if (this.handle == 0) {
                this.error(2);
            }
            int vboxHandle = this.parent.vboxHandle;
            OS.gtk_container_add(vboxHandle, this.handle);
            OS.gtk_box_set_child_packing(vboxHandle, this.handle, false, true, 0, 0);
        } else {
            this.handle = OS.gtk_menu_new();
            if (this.handle == 0) {
                this.error(2);
            }
        }
    }

    void createIMMenu(int imHandle) {
        Object[] buffer;
        boolean showInputMethod = false;
        int settings = OS.gtk_settings_get_default();
        if (settings != 0 && OS.GTK_VERSION < OS.VERSION(3, 10, 0)) {
            buffer = new int[1];
            OS.g_object_get(settings, OS.gtk_show_input_method_menu, buffer, 0);
            boolean bl = showInputMethod = buffer[0] != 0;
        }
        if (imHandle == 0 || !showInputMethod) {
            this.imHandle = 0;
            if (this.imItem != 0) {
                OS.gtk_widget_destroy(this.imItem);
                this.imItem = 0;
            }
            if (this.imSeparator != 0) {
                OS.gtk_widget_destroy(this.imSeparator);
                this.imSeparator = 0;
            }
            return;
        }
        if (this.imHandle == imHandle) {
            return;
        }
        this.imHandle = imHandle;
        if (this.imSeparator == 0) {
            this.imSeparator = OS.gtk_separator_menu_item_new();
            OS.gtk_widget_show(this.imSeparator);
            OS.gtk_menu_shell_insert(this.handle, this.imSeparator, -1);
        }
        if (this.imItem == 0) {
            buffer = Converter.wcsToMbcs(SWT.getMessage("SWT_InputMethods"), true);
            if (OS.GTK3) {
                this.imItem = OS.gtk_menu_item_new();
                if (this.imItem == 0) {
                    this.error(2);
                }
                int imageHandle = 0;
                int labelHandle = OS.gtk_accel_label_new((byte[])buffer);
                if (labelHandle == 0) {
                    this.error(2);
                }
                if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                    OS.gtk_label_set_xalign(labelHandle, 0.0f);
                    OS.gtk_widget_set_halign(labelHandle, 0);
                } else {
                    OS.gtk_misc_set_alignment(labelHandle, 0.0f, 0.0f);
                }
                int boxHandle = this.gtk_box_new(0, false, 0);
                if (boxHandle == 0) {
                    this.error(2);
                }
                if (OS.SWT_PADDED_MENU_ITEMS) {
                    imageHandle = OS.gtk_image_new();
                    if (imageHandle == 0) {
                        this.error(2);
                    }
                    OS.gtk_image_set_pixel_size(imageHandle, 16);
                    if (boxHandle != 0) {
                        OS.gtk_container_add(boxHandle, imageHandle);
                        OS.gtk_widget_show(imageHandle);
                    }
                }
                if (labelHandle != 0 && boxHandle != 0) {
                    OS.gtk_box_pack_end(boxHandle, labelHandle, true, true, 0);
                    OS.gtk_widget_show(labelHandle);
                }
                if (boxHandle != 0) {
                    OS.gtk_container_add(this.imItem, boxHandle);
                    OS.gtk_widget_show(boxHandle);
                }
            } else {
                this.imItem = OS.gtk_image_menu_item_new_with_label((byte[])buffer);
                if (this.imItem == 0) {
                    this.error(2);
                }
            }
            OS.gtk_widget_show(this.imItem);
            OS.gtk_menu_shell_insert(this.handle, this.imItem, -1);
        }
        int imSubmenu = OS.gtk_menu_new();
        OS.gtk_im_multicontext_append_menuitems(imHandle, imSubmenu);
        OS.gtk_menu_item_set_submenu(this.imItem, imSubmenu);
    }

    @Override
    void createWidget(int index) {
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.parent.addMenu(this);
    }

    void fixMenus(Decorations newParent) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].fixMenus(newParent);
            ++i;
        }
        this.parent.removeMenu(this);
        newParent.addMenu(this);
        this.parent = newParent;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (!OS.gtk_widget_get_mapped(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int window = this.gtk_widget_get_window(this.handle);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin(window, origin_x, origin_y);
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, allocation);
        int x = origin_x[0] + allocation.x;
        int y = origin_y[0] + allocation.y;
        int width = allocation.width;
        int height = allocation.height;
        return new Rectangle(x, y, width, height);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.gtk_widget_get_sensitive(this.handle);
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        int list = OS.gtk_container_get_children(this.handle);
        if (list == 0) {
            this.error(8);
        }
        int count = OS.g_list_length(list);
        if (this.imSeparator != 0) {
            --count;
        }
        if (this.imItem != 0) {
            --count;
        }
        if (index < 0 || index >= count) {
            this.error(6);
        }
        int data = OS.g_list_nth_data(list, index);
        OS.g_list_free(list);
        if (data == 0) {
            this.error(8);
        }
        return (MenuItem)this.display.getWidget(data);
    }

    public int getItemCount() {
        this.checkWidget();
        int list = OS.gtk_container_get_children(this.handle);
        if (list == 0) {
            return 0;
        }
        int count = OS.g_list_length(list);
        OS.g_list_free(list);
        if (this.imSeparator != 0) {
            --count;
        }
        if (this.imItem != 0) {
            --count;
        }
        return Math.max(0, count);
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        int list = OS.gtk_container_get_children(this.handle);
        if (list == 0) {
            return new MenuItem[0];
        }
        int originalList = list;
        int count = OS.g_list_length(list);
        if (this.imSeparator != 0) {
            --count;
        }
        if (this.imItem != 0) {
            --count;
        }
        MenuItem[] items = new MenuItem[count];
        int index = 0;
        int i = 0;
        while (i < count) {
            int data = OS.g_list_data(list);
            MenuItem item = (MenuItem)this.display.getWidget(data);
            if (item != null) {
                items[index++] = item;
            }
            list = OS.g_list_next(list);
            ++i;
        }
        OS.g_list_free(originalList);
        if (index != items.length) {
            MenuItem[] newItems = new MenuItem[index];
            System.arraycopy(items, 0, newItems, 0, index);
            items = newItems;
        }
        return items;
    }

    @Override
    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade == null) {
            return null;
        }
        return this.cascade.getParent();
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu[] popups;
        this.checkWidget();
        if ((this.style & 8) != 0 && (popups = this.display.popups) != null) {
            int i = 0;
            while (i < popups.length) {
                if (popups[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return OS.gtk_widget_get_mapped(this.handle);
    }

    @Override
    int gtk_hide(int widget) {
        if ((this.style & 8) != 0 && this.display.activeShell != null) {
            this.display.activeShell = this.getShell();
            this.display.activeShell.ignoreFocusOut = false;
        }
        this.sendEvent(23);
        if (OS.ubuntu_menu_proxy_get() != 0) {
            MenuItem[] items = this.getItems();
            int i = 0;
            while (i < items.length) {
                MenuItem item = items[i];
                if (item.updateAcceleratorText(false)) {
                    // empty if block
                }
                ++i;
            }
        }
        return 0;
    }

    @Override
    int gtk_show(int widget) {
        if ((this.style & 8) != 0) {
            if (this.display.activeShell != null) {
                this.display.activeShell = this.getShell();
                this.display.activeShell.ignoreFocusOut = true;
            }
            return 0;
        }
        this.sendEvent(22);
        if (OS.ubuntu_menu_proxy_get() != 0) {
            MenuItem[] items = this.getItems();
            int i = 0;
            while (i < items.length) {
                MenuItem item = items[i];
                if (item.updateAcceleratorText(true)) {
                    // empty if block
                }
                ++i;
            }
        }
        return 0;
    }

    @Override
    int gtk_show_help(int widget, int helpType) {
        if (this.sendHelpEvent(helpType)) {
            OS.gtk_menu_shell_deactivate(this.handle);
            return 1;
        }
        return 0;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[45], 0, this.display.getClosure(45), false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[24], 0, this.display.getClosure(24), false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    @Override
    void releaseChildren(boolean destroy) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.cascade = null;
        this.imHandle = 0;
        this.imSeparator = 0;
        this.imItem = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    void removeAccelerators(int accelGroup) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.removeAccelerators(accelGroup);
            ++i;
        }
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    @Override
    void reskinChildren(int flags) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.reskin(flags);
            ++i;
        }
        super.reskinChildren(flags);
    }

    boolean sendHelpEvent(int helpType) {
        if (this.selectedItem != null && !this.selectedItem.isDisposed() && this.selectedItem.hooks(28)) {
            this.selectedItem.postEvent(28);
            return true;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return true;
        }
        return this.parent.sendHelpEvent(helpType);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        OS.gtk_widget_set_sensitive(this.handle, enabled);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setLocation(new Point(x, y));
    }

    void setLocationInPixels(int x, int y) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(location));
    }

    void setLocationInPixels(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocationInPixels(location.x, location.y);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this._setOrientation(orientation);
    }

    void _setOrientation(int orientation) {
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.style &= ~flags;
        this.style |= orientation & flags;
        this.setOrientation(false);
    }

    @Override
    void setOrientation(boolean create) {
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0) {
                OS.gtk_widget_set_direction(this.handle, dir);
            }
            MenuItem[] items = this.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].setOrientation(create);
                ++i;
            }
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

