/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.activities.ws.ActivityViewerFilter;
import org.eclipse.ui.internal.dialogs.PerspContentProvider;
import org.eclipse.ui.model.PerspectiveLabelProvider;

public class SelectPerspectiveDialog
extends Dialog
implements ISelectionChangedListener {
    private static final int LIST_HEIGHT = 300;
    private static final int LIST_WIDTH = 300;
    private TableViewer list;
    private Button okButton;
    private IPerspectiveDescriptor perspDesc;
    private IPerspectiveRegistry perspReg;
    private ActivityViewerFilter activityViewerFilter = new ActivityViewerFilter();
    private Label descriptionHint;
    private Button showAllButton;
    private PopupDialog perspDescPopupDialog;

    public SelectPerspectiveDialog(Shell parentShell, IPerspectiveRegistry perspReg) {
        super(parentShell);
        this.perspReg = perspReg;
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected void cancelPressed() {
        this.perspDesc = null;
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.SelectPerspective_shellTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.select_perspective_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, WorkbenchMessages.SelectPerspective_open_button_label, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        this.createViewer(composite);
        this.layoutTopControl(this.list.getControl());
        this.descriptionHint = new Label(composite, 64);
        this.descriptionHint.setText(WorkbenchMessages.SelectPerspective_selectPerspectiveHelp);
        this.descriptionHint.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.descriptionHint.setVisible(false);
        if (this.needsShowAllButton()) {
            this.createShowAllButton(composite);
        }
        return composite;
    }

    private boolean needsShowAllButton() {
        return this.activityViewerFilter.getHasEncounteredFilteredItem();
    }

    private void createShowAllButton(Composite parent) {
        this.showAllButton = new Button(parent, 32);
        this.showAllButton.setText(ActivityMessages.Perspective_showAll);
        this.showAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.showAllButton.getSelection()) {
                this.list.resetFilters();
            } else {
                this.list.addFilter((ViewerFilter)this.activityViewerFilter);
            }
        }));
    }

    private void createViewer(Composite parent) {
        this.list = new TableViewer(parent, 2820);
        this.list.getTable().setFont(parent.getFont());
        this.list.setLabelProvider((IBaseLabelProvider)new PerspectiveLabelProvider());
        this.list.setContentProvider((IContentProvider)new PerspContentProvider());
        this.list.addFilter((ViewerFilter)this.activityViewerFilter);
        this.list.setComparator(new ViewerComparator());
        this.list.setInput((Object)this.perspReg);
        this.list.addSelectionChangedListener((ISelectionChangedListener)this);
        this.list.addDoubleClickListener(event -> this.handleDoubleClickEvent());
        this.list.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SelectPerspectiveDialog.this.handleTableViewerKeyPressed(e);
            }
        });
    }

    public IPerspectiveDescriptor getSelection() {
        return this.perspDesc;
    }

    protected void handleDoubleClickEvent() {
        this.okPressed();
    }

    private void layoutTopControl(Control control) {
        GridData spec = new GridData(1808);
        spec.widthHint = 300;
        spec.heightHint = 300;
        control.setLayoutData((Object)spec);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection(event);
        this.updateButtons();
        this.updateTooltip();
    }

    protected void updateButtons() {
        this.okButton.setEnabled(this.getSelection() != null);
    }

    protected void updateSelection(SelectionChangedEvent event) {
        Object obj;
        this.perspDesc = null;
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        if (!sel.isEmpty() && (obj = sel.getFirstElement()) instanceof IPerspectiveDescriptor) {
            this.perspDesc = (IPerspectiveDescriptor)obj;
        }
    }

    private void updateTooltip() {
        String tooltip = "";
        if (this.perspDesc != null) {
            tooltip = this.perspDesc.getDescription();
        }
        boolean hasTooltip = tooltip != null && tooltip.length() > 0;
        this.descriptionHint.setVisible(hasTooltip);
        if (this.perspDescPopupDialog != null) {
            this.perspDescPopupDialog.close();
            this.perspDescPopupDialog = null;
        }
    }

    protected void okPressed() {
        ITriggerPoint triggerPoint = PlatformUI.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.ui.openPerspectiveDialog");
        if (WorkbenchActivityHelper.allowUseOf(triggerPoint, this.getSelection())) {
            super.okPressed();
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void handleTableViewerKeyPressed(KeyEvent event) {
        Object o;
        IStructuredSelection selection;
        if (event.keyCode == 0x100000B && event.stateMask == 0 && (selection = this.list.getStructuredSelection()).size() == 1 && (o = selection.getFirstElement()) instanceof IPerspectiveDescriptor) {
            String description = ((IPerspectiveDescriptor)o).getDescription();
            if (description.length() == 0) {
                description = WorkbenchMessages.SelectPerspective_noDesc;
            }
            this.popUp(description);
        }
    }

    private void popUp(final String description) {
        this.perspDescPopupDialog = new PopupDialog(this.getShell(), 540676, true, false, false, false, false, null, null){
            private static final int CURSOR_SIZE = 15;

            protected Point getInitialLocation(Point initialSize) {
                Display display = this.getShell().getDisplay();
                Point location = display.getCursorLocation();
                location.x += 15;
                location.y += 15;
                return location;
            }

            protected Control createDialogArea(Composite parent) {
                Label label = new Label(parent, 64);
                label.setText(description);
                label.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent event) {
                        this.close();
                    }
                });
                GridData gd = new GridData(1809);
                gd.horizontalIndent = 1;
                gd.verticalIndent = 1;
                label.setLayoutData((Object)gd);
                return label;
            }
        };
        this.perspDescPopupDialog.open();
    }
}

