/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.Statistics;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractSegmentStatisticsAnalysis
extends TmfAbstractAnalysisModule {
    private static Function<ISegment, Long> FCT_LENGTH = s -> s.getLength();
    private @Nullable ISegmentStoreProvider fSegmentStoreProviderModule;
    private @Nullable IStatistics<ISegment> fTotalStats;
    private Map<String, IStatistics<ISegment>> fPerSegmentTypeStats = new HashMap<String, IStatistics<ISegment>>();

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            ISegmentStoreProvider provider;
            this.fSegmentStoreProviderModule = provider = this.getSegmentProviderAnalysis(trace);
            if (provider instanceof IAnalysisModule) {
                return ImmutableList.of((Object)((IAnalysisModule)provider));
            }
        }
        return super.getDependentAnalyses();
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        if (monitor.isCanceled()) {
            return false;
        }
        IStatistics<ISegment> totalStats = this.getTotalStats(TmfTimeRange.ETERNITY.getStartTime().toNanos(), TmfTimeRange.ETERNITY.getEndTime().toNanos(), monitor);
        if (totalStats == null) {
            return false;
        }
        Map<String, IStatistics<ISegment>> perTypeStats = this.getPerTypeStats(TmfTimeRange.ETERNITY.getStartTime().toNanos(), TmfTimeRange.ETERNITY.getEndTime().toNanos(), monitor);
        this.fTotalStats = totalStats;
        this.fPerSegmentTypeStats = perTypeStats;
        return true;
    }

    private @Nullable IStatistics<ISegment> getTotalStats(long start, long end, IProgressMonitor monitor) {
        Iterable<@NonNull ISegment> store = this.getSegmentStore(start, end);
        if (store == null) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        return AbstractSegmentStatisticsAnalysis.calculateTotalManual(store, monitor);
    }

    public @Nullable IStatistics<ISegment> getStatsForRange(long start, long end, IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (trace != null && start == TmfTimeRange.ETERNITY.getStartTime().toNanos() && end == TmfTimeRange.ETERNITY.getEndTime().toNanos()) {
            this.waitForCompletion();
            return this.getStatsTotal();
        }
        return this.getTotalStats(start, end, monitor);
    }

    private Map<@NonNull String, IStatistics<ISegment>> getPerTypeStats(long start, long end, IProgressMonitor monitor) {
        Iterable<@NonNull ISegment> store = this.getSegmentStore(start, end);
        if (monitor.isCanceled() || store == null) {
            return Collections.EMPTY_MAP;
        }
        return this.calculateTotalPerType(store, monitor);
    }

    public Map<@NonNull String, IStatistics<ISegment>> getStatsPerTypeForRange(long start, long end, IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (trace != null && start == TmfTimeRange.ETERNITY.getStartTime().toNanos() && end == TmfTimeRange.ETERNITY.getEndTime().toNanos()) {
            this.waitForCompletion();
            return this.getStatsPerType();
        }
        return this.getPerTypeStats(start, end, monitor);
    }

    private @Nullable Iterable<@NonNull ISegment> getSegmentStore(long start, long end) {
        ISegmentStore<ISegment> segmentStore;
        ISegmentStoreProvider segmentStoreProviderModule = this.fSegmentStoreProviderModule;
        if (segmentStoreProviderModule == null) {
            return null;
        }
        if (segmentStoreProviderModule instanceof IAnalysisModule) {
            ((IAnalysisModule)segmentStoreProviderModule).waitForCompletion();
        }
        long t0 = start;
        long t1 = end;
        if (end < start) {
            t0 = end;
            t1 = start;
        }
        return (segmentStore = segmentStoreProviderModule.getSegmentStore()) != null ? (t0 != TmfTimeRange.ETERNITY.getStartTime().toNanos() || t1 != TmfTimeRange.ETERNITY.getEndTime().toNanos() ? segmentStore.getIntersectingElements(t0, t1) : segmentStore) : Collections.emptyList();
    }

    private static @Nullable IStatistics<ISegment> calculateTotalManual(Iterable<@NonNull ISegment> segments, IProgressMonitor monitor) {
        Statistics<ISegment> total = new Statistics<ISegment>(FCT_LENGTH);
        Iterator<@NonNull ISegment> iter = segments.iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return null;
            }
            ISegment segment = iter.next();
            total.update(segment);
        }
        return total;
    }

    private Map<@NonNull String, IStatistics<ISegment>> calculateTotalPerType(Iterable<ISegment> segments, IProgressMonitor monitor) {
        HashMap<String, IStatistics<ISegment>> perSegmentTypeStats = new HashMap<String, IStatistics<ISegment>>();
        Iterator<ISegment> iter = segments.iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return Collections.EMPTY_MAP;
            }
            ISegment segment = iter.next();
            String segmentType = this.getSegmentType(segment);
            if (segmentType == null) continue;
            Statistics<ISegment> values = (Statistics<ISegment>)perSegmentTypeStats.get(segmentType);
            if (values == null) {
                values = new Statistics<ISegment>(FCT_LENGTH);
            }
            values.update(segment);
            perSegmentTypeStats.put(segmentType, values);
        }
        return perSegmentTypeStats;
    }

    protected abstract @Nullable String getSegmentType(ISegment var1);

    protected abstract @Nullable ISegmentStoreProvider getSegmentProviderAnalysis(ITmfTrace var1);

    protected void canceling() {
    }

    public @Nullable IStatistics<ISegment> getStatsTotal() {
        return this.fTotalStats;
    }

    public Map<String, IStatistics<ISegment>> getStatsPerType() {
        return this.fPerSegmentTypeStats;
    }
}

