/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.GlobalRefreshElementSelectionPage;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorContentServiceListener;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ModelElementSelectionPage
extends GlobalRefreshElementSelectionPage
implements INavigatorContentServiceListener {
    private INavigatorContentService service;
    private ISynchronizationScopeManager manager;
    private ContainerCheckedTreeViewer fViewer;
    private boolean initialized;

    public ModelElementSelectionPage(IResource[] roots) {
        super("elementSelection");
        this.setDescription(TeamUIMessages.GlobalRefreshResourceSelectionPage_2);
        this.setTitle(TeamUIMessages.GlobalRefreshResourceSelectionPage_3);
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        int i = 0;
        while (i < roots.length) {
            IResource resource = roots[i];
            result.add(Utils.getResourceMapping(resource));
            ++i;
        }
        this.manager = new SynchronizationScopeManager(TeamUIMessages.ModelElementSelectionPage_0, result.toArray(new ResourceMapping[result.size()]), ResourceMappingContext.LOCAL_CONTEXT, true);
    }

    @Override
    protected ContainerCheckedTreeViewer createViewer(Composite top) {
        this.fViewer = new ContainerCheckedTreeViewer(top, 2048);
        this.service = NavigatorContentServiceFactory.INSTANCE.createContentService("org.eclipse.team.ui.navigatorViewer", (StructuredViewer)this.fViewer);
        this.service.bindExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(this.manager.getScope()), true);
        this.service.getActivationService().activateExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(this.manager.getScope()), true);
        this.service.addListener((INavigatorContentServiceListener)this);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fViewer.getControl().setLayoutData((Object)data);
        this.fViewer.setContentProvider((IContentProvider)this.service.createCommonContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider(this.service.createCommonLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (event.getChecked() && element instanceof ModelProvider && ((ModelProvider)element).getId().equals("org.eclipse.core.resources.modelProvider")) {
                    ModelElementSelectionPage.this.setWorkspaceSelected(true);
                } else {
                    ResourceMapping mapping = Utils.getResourceMapping(element);
                    if (mapping != null) {
                        if (!(element instanceof ModelProvider)) {
                            ModelElementSelectionPage.this.uncheckOtherModels(mapping.getModelProviderId());
                            event.getCheckable().setChecked(event.getElement(), event.getChecked());
                        }
                        ModelElementSelectionPage.this.updateOKStatus();
                    } else {
                        ModelElementSelectionPage.this.updateOKStatus();
                    }
                }
            }
        });
        this.fViewer.getTree().addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
            }

            public void treeExpanded(TreeEvent e) {
                if (ModelElementSelectionPage.this.isWorkingSetSelected()) {
                    ModelElementSelectionPage.this.checkWorkingSetElements();
                }
            }
        });
        this.fViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        return this.fViewer;
    }

    public ResourceMapping[] getSelectedMappings() {
        if (this.isWorkingSetSelected()) {
            ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
            IWorkingSet[] sets = this.getWorkingSets();
            int i = 0;
            while (i < sets.length) {
                IWorkingSet set = sets[i];
                result.add(Utils.getResourceMapping(set));
                ++i;
            }
            return result.toArray(new ResourceMapping[result.size()]);
        }
        if (this.isWorkspaceSelected()) {
            try {
                ModelProvider provider = ModelProvider.getModelProviderDescriptor((String)"org.eclipse.core.resources.modelProvider").getModelProvider();
                ResourceMapping mapping = Utils.getResourceMapping(provider);
                if (mapping != null) {
                    return new ResourceMapping[]{mapping};
                }
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
            ResourceMapping[] mappings = this.manager.getScope().getMappings("org.eclipse.core.resources.modelProvider");
            return mappings;
        }
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        Object[] objects = this.getRootElement();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            ResourceMapping mapping = Utils.getResourceMapping(object);
            if (mapping != null) {
                result.add(mapping);
            }
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    @Override
    public void dispose() {
        this.service.dispose();
        super.dispose();
    }

    @Override
    protected void checkAll() {
        this.getViewer().setCheckedElements((Object[])this.manager.getScope().getModelProviders());
    }

    @Override
    protected boolean checkWorkingSetElements() {
        ArrayList allWorkingSetElements = new ArrayList();
        IWorkingSet[] workingSets = this.getWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet set = workingSets[i];
            allWorkingSetElements.addAll(this.computeSelectedResources(new StructuredSelection((Object[])set.getElements())));
            ++i;
        }
        this.getViewer().setCheckedElements(allWorkingSetElements.toArray());
        return !allWorkingSetElements.isEmpty();
    }

    private Collection computeSelectedResources(StructuredSelection selection) {
        ArrayList result = new ArrayList();
        for (Object element : selection) {
            ResourceMapping mapping = Utils.getResourceMapping(element);
            if (mapping == null || !this.scopeContainsMapping(mapping)) continue;
            result.add(element);
        }
        return result;
    }

    private boolean scopeContainsMapping(ResourceMapping mapping) {
        ResourceMapping[] mappings = this.manager.getScope().getMappings();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping m = mappings[i];
            if (m.contains(mapping)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void onLoad(INavigatorContentExtension anExtension) {
        anExtension.getStateModel().setProperty("org.eclipse.team.ui.synchronizationScope", (Object)this.manager.getScope());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.initialized) {
            this.initialize();
            if (this.initialized) {
                ISynchronizationScope syncScope = this.manager.getScope();
                ModelProvider[] providers = syncScope.getModelProviders();
                boolean foundEnabledModelProvider = false;
                int i = 0;
                while (i < providers.length) {
                    if (this.isEnabled(providers[i])) {
                        foundEnabledModelProvider = true;
                        break;
                    }
                    ++i;
                }
                if (!foundEnabledModelProvider && MessageDialog.openConfirm((Shell)this.getShell(), (String)TeamUIMessages.ModelElementSelectionPage_AllModelsDisabledTitle, (String)TeamUIMessages.ModelElementSelectionPage_AllModelsDisabledMessage)) {
                    ArrayList<ITeamContentProviderDescriptor> teamProviderDescriptors = new ArrayList<ITeamContentProviderDescriptor>();
                    int i2 = 0;
                    while (i2 < providers.length) {
                        teamProviderDescriptors.add(TeamUI.getTeamContentProviderManager().getDescriptor(providers[i2].getId()));
                        ++i2;
                    }
                    ITeamContentProviderDescriptor[] desc = teamProviderDescriptors.toArray(new ITeamContentProviderDescriptor[teamProviderDescriptors.size()]);
                    TeamUI.getTeamContentProviderManager().setEnabledDescriptors(desc);
                }
                this.service.bindExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(syncScope), true);
                this.service.getActivationService().activateExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(syncScope), true);
                this.fViewer.setInput((Object)syncScope);
                this.initializeScopingHint();
            }
        }
    }

    private void initialize() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ModelElementSelectionPage.this.manager.initialize(monitor);
                        ModelElementSelectionPage.this.initialized = true;
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handleError(this.getShell(), e, null, null);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean isEnabled(ModelProvider provider) {
        ITeamContentProviderDescriptor desc = TeamUI.getTeamContentProviderManager().getDescriptor(provider.getId());
        return desc != null && desc.isEnabled();
    }

    private void uncheckOtherModels(String modelProviderId) {
        if (!this.isSelectedResourcesSelected()) {
            ModelProvider[] providers = this.manager.getScope().getModelProviders();
            ArrayList<ModelProvider> disabledProviders = new ArrayList<ModelProvider>();
            int i = 0;
            while (i < providers.length) {
                if (!providers[i].getId().equals(modelProviderId)) {
                    disabledProviders.add(providers[i]);
                }
                ++i;
            }
            for (ModelProvider disable : disabledProviders) {
                this.fViewer.setChecked((Object)disable, false);
            }
        }
    }
}

