/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlStateChange;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;

public class TmfXmlEventHandler {
    private final List<TmfXmlStateChange> fStateChangeList = new ArrayList<TmfXmlStateChange>();
    private final String fName;
    private final IXmlStateSystemContainer fParent;

    public TmfXmlEventHandler(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer parent) {
        String name;
        this.fParent = parent;
        this.fName = name = node.getAttribute("eventName");
        List<@NonNull Element> childElements = TmfXmlUtils.getChildElements(node, "stateChange");
        for (Element childElem : childElements) {
            TmfXmlStateChange stateChange = modelFactory.createStateChange(childElem, this.fParent);
            this.fStateChangeList.add(stateChange);
        }
    }

    private boolean appliesToEvent(ITmfEvent event) {
        String eventName = event.getName();
        if (eventName.equals(this.fName)) {
            return true;
        }
        return this.fName.endsWith("*") && eventName.startsWith(this.fName.replace("*", ""));
    }

    public void handleEvent(ITmfEvent event) {
        if (!this.appliesToEvent(event)) {
            return;
        }
        for (TmfXmlStateChange stateChange : this.fStateChangeList) {
            try {
                stateChange.handleEvent(event, null);
            }
            catch (AttributeNotFoundException ae) {
                Activator.logError("Attribute not found", ae);
            }
            catch (TimeRangeException tre) {
                Activator.logError("TimeRangeException caught in the state system's event manager.  Are the events in the trace correctly ordered?", tre);
            }
            catch (StateValueTypeException sve) {
                Activator.logError("State value type error", sve);
            }
        }
    }

    public String toString() {
        return "TmfXmlEventHandler: " + this.fName;
    }
}

