/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.AbstractTreeDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTreeCommonXDataProvider<A extends TmfStateSystemAnalysisModule, M extends ITmfTreeDataModel>
extends AbstractTreeDataProvider<A, M>
implements ITmfTreeXYDataProvider<M> {
    public AbstractTreeCommonXDataProvider(ITmfTrace trace, A analysisModule) {
        super(trace, analysisModule);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final TmfModelResponse<ITmfXyModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Object module = this.getAnalysisModule();
        TmfModelResponse<ITmfXyModel> res = this.verifyParameters((TmfStateSystemAnalysisModule)module, filter, monitor);
        if (res != null) {
            return res;
        }
        ITmfStateSystem ss = Objects.requireNonNull(((TmfStateSystemAnalysisModule)module).getStateSystem(), "Statesystem should have been verified by verifyParameters");
        long currentEnd = ss.getCurrentEndTime();
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try {
                TmfModelResponse<ITmfXyModel> tmfModelResponse;
                TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "AbstractTreeXyDataProvider#fetchXY", new Object[0]).setCategory(this.getClass().getSimpleName()).build();
                try {
                    if (!(filter instanceof SelectionTimeQueryFilter)) {
                        tmfModelResponse = TmfXyResponseFactory.create(this.getTitle(), filter.getTimesRequested(), Collections.emptyMap(), complete);
                        return tmfModelResponse;
                    }
                    Map<String, IYModel> yModels = this.getYModels(ss, (SelectionTimeQueryFilter)filter, monitor);
                    if (yModels == null) {
                        return TmfXyResponseFactory.createCancelledResponse(CommonStatusMessage.TASK_CANCELLED);
                    }
                    return TmfXyResponseFactory.create(this.getTitle(), filter.getTimesRequested(), yModels, complete);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (scope == null) return tmfModelResponse;
                    scope.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            return TmfXyResponseFactory.createFailedResponse(String.valueOf(e.getMessage()));
        }
    }

    protected abstract @Nullable Map<String, IYModel> getYModels(ITmfStateSystem var1, SelectionTimeQueryFilter var2, @Nullable IProgressMonitor var3) throws StateSystemDisposedException;

    protected abstract String getTitle();
}

