/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.kernel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.LinuxTestCase;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.kernel.KernelAnalysisTestFactory;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KernelThreadInformationProviderTest {
    private static final @NonNull LinuxTestCase KERNEL_TEST_CASE = KernelAnalysisTestFactory.KERNEL_SCHED;
    private ITmfTrace fTrace;
    private KernelAnalysisModule fModule;

    private static void deleteSuppFiles(@NonNull ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    @Before
    public void setUp() {
        TmfXmlKernelTraceStub trace = KERNEL_TEST_CASE.getKernelTrace();
        KernelThreadInformationProviderTest.deleteSuppFiles((ITmfTrace)trace);
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        IAnalysisModule module = null;
        Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, KernelAnalysisModule.class).iterator();
        while (iterator.hasNext()) {
            IAnalysisModule mod;
            module = mod = (IAnalysisModule)iterator.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        module.waitForCompletion();
        this.fModule = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        this.fTrace = trace;
    }

    @After
    public void tearDown() {
        ITmfTrace trace = this.fTrace;
        if (trace != null) {
            KernelThreadInformationProviderTest.deleteSuppFiles(trace);
            trace.dispose();
        }
    }

    @Test
    public void testGetThreadQuarks() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        Collection threadIds = KernelThreadInformationProvider.getThreadIds((KernelAnalysisModule)module);
        Assert.assertEquals((Object)ImmutableSet.of((Object)10, (Object)11, (Object)12, (Object)20, (Object)21, (Object)30, (Object[])new Integer[]{100}), (Object)threadIds);
    }

    @Test
    public void testGetThreadOnCpu() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        Integer tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)-1L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)90L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)2L, (long)20L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)-1L, (long)20L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)4L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)15L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)1L, (long)15L);
        Assert.assertEquals((Object)11, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)1L, (long)29L);
        Assert.assertEquals((Object)20, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)1L, (long)30L);
        Assert.assertEquals((Object)21, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)59L);
        Assert.assertEquals((Object)11, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)1L, (long)59L);
        Assert.assertEquals((Object)30, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)60L);
        Assert.assertEquals((Object)11, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)1L, (long)60L);
        Assert.assertEquals((Object)21, (Object)tid);
    }

    @Test
    public void testGetThreadsOfCpus() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        long start = 45L;
        long end = 65L;
        Set tids = KernelThreadInformationProvider.getThreadsOfCpus((KernelAnalysisModule)module, Collections.singleton(0L), (long)45L, (long)65L);
        Assert.assertNotNull((Object)tids);
        Assert.assertEquals(Collections.singleton(11), (Object)tids);
        tids = KernelThreadInformationProvider.getThreadsOfCpus((KernelAnalysisModule)module, Collections.singleton(1L), (long)45L, (long)65L);
        Assert.assertNotNull((Object)tids);
        Assert.assertEquals((Object)ImmutableSet.of((Object)21, (Object)30), (Object)tids);
    }

    @Test
    public void testIsThreadActiveRange() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        long start = 45L;
        long end = 65L;
        Set tids = KernelThreadInformationProvider.getActiveThreadsForRange((KernelAnalysisModule)module, (long)45L, (long)65L);
        Assert.assertEquals((Object)ImmutableSet.of((Object)11, (Object)21, (Object)30), (Object)tids);
        tids = KernelThreadInformationProvider.getActiveThreadsForRange((KernelAnalysisModule)module, (long)0L, (long)0L);
        Assert.assertTrue((boolean)tids.isEmpty());
        tids = KernelThreadInformationProvider.getActiveThreadsForRange((KernelAnalysisModule)module, (long)123456789L, (long)1234567890L);
        Assert.assertTrue((boolean)tids.isEmpty());
        tids = KernelThreadInformationProvider.getActiveThreadsForRange((KernelAnalysisModule)module, (long)0L, (long)10L);
        Assert.assertTrue((boolean)tids.isEmpty());
        tids = KernelThreadInformationProvider.getActiveThreadsForRange((KernelAnalysisModule)module, (long)70L, (long)123456L);
        Assert.assertEquals((Object)ImmutableSet.of((Object)11, (Object)20, (Object)21), (Object)tids);
    }

    @Test
    public void testGetPpid() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        Integer ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)11, (long)-1L);
        Assert.assertNull((Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)11, (long)90L);
        Assert.assertNull((Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)-4, (long)20L);
        Assert.assertNull((Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)13, (long)20L);
        Assert.assertNull((Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)10, (long)20L);
        Assert.assertEquals((Object)0, (Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)30, (long)60L);
        Assert.assertEquals((Object)0, (Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)11, (long)4L);
        Assert.assertNull((Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)11, (long)5L);
        Assert.assertEquals((Object)10, (Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)12, (long)10L);
        Assert.assertEquals((Object)11, (Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)21, (long)25L);
        Assert.assertEquals((Object)20, (Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)21, (long)70L);
        Assert.assertEquals((Object)20, (Object)ppid);
    }

    @Test
    public void testGetPid() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        Integer pid = KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)11, (long)-1L);
        Assert.assertNull((Object)pid);
        pid = KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)11, (long)90L);
        Assert.assertNull((Object)pid);
        pid = KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)-4, (long)20L);
        Assert.assertNull((Object)pid);
        pid = KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)13, (long)20L);
        Assert.assertNull((Object)pid);
        pid = KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)10, (long)20L);
        Assert.assertEquals((Object)10, (Object)pid);
        pid = KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)30, (long)60L);
        Assert.assertEquals((Object)30, (Object)pid);
        pid = KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)11, (long)4L);
        Assert.assertNull((Object)pid);
        pid = KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)11, (long)5L);
        Assert.assertEquals((Object)10, (Object)pid);
        pid = KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)12, (long)10L);
        Assert.assertEquals((Object)10, (Object)pid);
        pid = KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)21, (long)25L);
        Assert.assertEquals((Object)20, (Object)pid);
        pid = KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)21, (long)70L);
        Assert.assertEquals((Object)20, (Object)pid);
    }

    @Test
    public void testGetExecutableName() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        String execName = KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)module, (Integer)101);
        Assert.assertNull((Object)execName);
        execName = KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)module, (Integer)-2);
        Assert.assertNull((Object)execName);
        execName = KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)module, (Integer)20);
        Assert.assertEquals((Object)"proc20", (Object)execName);
        execName = KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)module, (Integer)21);
        Assert.assertEquals((Object)"tid21", (Object)execName);
    }

    private static void testIntervals(String info, List<ITmfStateInterval> intervals, ProcessStatus[] values) {
        Assert.assertEquals((String)(String.valueOf(info) + " interval count"), (long)values.length, (long)intervals.size());
        int i = 0;
        while (i < values.length) {
            Assert.assertEquals((String)(String.valueOf(info) + " interval " + i), (Object)values[i], (Object)ProcessStatus.getStatusFromStateValue((ITmfStateValue)intervals.get(i).getStateValue()));
            ++i;
        }
    }

    private static void testIterator(String info, Iterator<ITmfStateInterval> intervals, ProcessStatus[] values) {
        int i = 0;
        while (i < values.length) {
            Assert.assertTrue((boolean)intervals.hasNext());
            ITmfStateInterval interval = intervals.next();
            Assert.assertEquals((String)(String.valueOf(info) + " interval " + i), (Object)values[i], (Object)ProcessStatus.getStatusFromStateValue((ITmfStateValue)interval.getStateValue()));
            ++i;
        }
        Assert.assertFalse((boolean)intervals.hasNext());
    }

    private static void compareIntervals(List<ITmfStateInterval> expecteds, List<ITmfStateInterval> actuals) {
        Assert.assertEquals((long)expecteds.size(), (long)actuals.size());
        int i = 0;
        while (i < expecteds.size()) {
            ITmfStateInterval expected = expecteds.get(i);
            ITmfStateInterval actual = actuals.get(i);
            Assert.assertEquals((long)expected.getStartTime(), (long)actual.getStartTime());
            Assert.assertEquals((long)expected.getEndTime(), (long)actual.getEndTime());
            Assert.assertEquals((Object)expected.getStateValue(), (Object)actual.getStateValue());
            ++i;
        }
    }

    @Test
    public void testGetStatusIntervalsForThread() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        NullProgressMonitor monitor = new NullProgressMonitor();
        Integer process21 = 21;
        Integer process20 = 20;
        List intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)-15L, (long)-5L, (long)3L, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)intervals.isEmpty());
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)90L, (long)1500000000L, (long)50L, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)intervals.isEmpty());
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)-1, (long)0L, (long)70L, (long)3L, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)intervals.isEmpty());
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)0, (long)0L, (long)70L, (long)3L, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)intervals.isEmpty());
        ProcessStatus[] values = new ProcessStatus[]{ProcessStatus.NOT_ALIVE, ProcessStatus.WAIT_CPU, ProcessStatus.RUN, ProcessStatus.WAIT_CPU, ProcessStatus.RUN};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)0L, (long)70L, (long)3L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 21 [0,70,3]", intervals, values);
        ProcessStatus[] values2 = new ProcessStatus[]{ProcessStatus.NOT_ALIVE, ProcessStatus.RUN, ProcessStatus.RUN};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)1L, (long)70L, (long)30L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 21 [0,70,30]", intervals, values2);
        ProcessStatus[] values3 = new ProcessStatus[]{ProcessStatus.WAIT_CPU, ProcessStatus.RUN};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)25L, (long)50L, (long)3L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 21 [25,50,3]", intervals, values3);
        ImmutableList expectedIntervals = ImmutableList.of((Object)new TmfStateInterval(1L, 9L, 0, ProcessStatus.NOT_ALIVE.getStateValue().unboxValue()), (Object)new TmfStateInterval(10L, 19L, 0, ProcessStatus.WAIT_UNKNOWN.getStateValue().unboxValue()), (Object)new TmfStateInterval(20L, 29L, 0, ProcessStatus.RUN.getStateValue().unboxValue()), (Object)new TmfStateInterval(30L, 69L, 0, ProcessStatus.WAIT_BLOCKED.getStateValue().unboxValue()));
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process20, (long)0L, (long)70L, (long)3L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.compareIntervals((List<ITmfStateInterval>)expectedIntervals, intervals);
        expectedIntervals = ImmutableList.of((Object)new TmfStateInterval(1L, 9L, 0, ProcessStatus.NOT_ALIVE.getStateValue().unboxValue()), (Object)new TmfStateInterval(30L, 69L, 0, ProcessStatus.WAIT_BLOCKED.getStateValue().unboxValue()));
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process20, (long)1L, (long)70L, (long)30L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.compareIntervals((List<ITmfStateInterval>)expectedIntervals, intervals);
        ProcessStatus[] values6 = new ProcessStatus[]{ProcessStatus.RUN, ProcessStatus.WAIT_BLOCKED};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process20, (long)25L, (long)50L, (long)3L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 20 [25,50,3]", intervals, values6);
        ProcessStatus[] values7 = new ProcessStatus[]{ProcessStatus.WAIT_CPU};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process20, (long)80L, (long)85L, (long)3L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 20 [80,85,3]", intervals, values7);
    }

    @Test
    public void testGetStatusIntervalsForThreadIt() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        Integer process21 = 21;
        Integer process20 = 20;
        Iterator intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)-15L, (long)-5L);
        Assert.assertFalse((boolean)intervals.hasNext());
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)90L, (long)1500000000L);
        Assert.assertFalse((boolean)intervals.hasNext());
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)-1, (long)0L, (long)70L);
        Assert.assertFalse((boolean)intervals.hasNext());
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)0, (long)0L, (long)70L);
        Assert.assertFalse((boolean)intervals.hasNext());
        ProcessStatus[] values = new ProcessStatus[]{ProcessStatus.NOT_ALIVE, ProcessStatus.WAIT_CPU, ProcessStatus.RUN, ProcessStatus.WAIT_CPU, ProcessStatus.RUN};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)0L, (long)70L);
        KernelThreadInformationProviderTest.testIterator("tid 21 [0,70]", intervals, values);
        ProcessStatus[] values2 = new ProcessStatus[]{ProcessStatus.WAIT_CPU, ProcessStatus.RUN};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)25L, (long)50L);
        KernelThreadInformationProviderTest.testIterator("tid 21 [25,50]", intervals, values2);
        ProcessStatus[] values3 = new ProcessStatus[]{ProcessStatus.NOT_ALIVE, ProcessStatus.WAIT_UNKNOWN, ProcessStatus.RUN, ProcessStatus.WAIT_BLOCKED};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process20, (long)0L, (long)70L);
        KernelThreadInformationProviderTest.testIterator("tid 20 [0,70]", intervals, values3);
        ProcessStatus[] values4 = new ProcessStatus[]{ProcessStatus.RUN, ProcessStatus.WAIT_BLOCKED};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process20, (long)25L, (long)50L);
        KernelThreadInformationProviderTest.testIterator("tid 20 [25,50]", intervals, values4);
        ProcessStatus[] values5 = new ProcessStatus[]{ProcessStatus.WAIT_CPU};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process20, (long)80L, (long)85L);
        KernelThreadInformationProviderTest.testIterator("tid 20 [80,85]", intervals, values5);
    }
}

