/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.ui.swtbot.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class CallStackViewTest {
    private static final String UST_ID = "org.eclipse.linuxtools.lttng2.ust.tracetype";
    private static final String PROJECT_NAME = "TestForCallstack";
    private static final String TRACE = "glxgears-cyg-profile";
    private static final String PROCESS = "UNKNOWN";
    private static final @NonNull String THREAD = "glxgears-16073";
    private static final Logger sfLogger = Logger.getRootLogger();
    private static SWTWorkbenchBot sfBot;
    private static final long TIMESTAMP = 1378850463804917148L;
    private static final long[] TIMESTAMPS;
    private static final String[][] STACK_FRAMES;
    private static final @NonNull String CONFIGURE_SYMBOL_PROVIDERS = "Configure how the addresses are mapped to function names";
    private static final @NonNull String SORT_BY_NAME = "Name";
    private static final @NonNull String SORT_BY_ID = "PID/TID";
    private static final @NonNull String SORT_BY_START = "Start time";
    private static final @NonNull String SHOW_VIEW_FILTERS = "Show View Filters";
    private static final @NonNull String RESET_TIME_SCALE = "Reset the Time Scale to Default";
    private static final @NonNull String SELECT_PREVIOUS_STATE_CHANGE = "Select Previous State Change";
    private static final @NonNull String SELECT_NEXT_STATE_CHANGE = "Select Next State Change";
    private static final @NonNull String ADD_BOOKMARK = "Add Bookmark...";
    private static final @NonNull String PREVIOUS_MARKER = "Previous Marker";
    private static final @NonNull String NEXT_MARKER = "Next Marker";
    private static final @NonNull String SELECT_PREVIOUS_ITEM = "Select Previous Item";
    private static final @NonNull String SELECT_NEXT_ITEM = "Select Next Item";
    private static final @NonNull String ZOOM_IN = "Zoom In";
    private static final @NonNull String ZOOM_OUT = "Zoom Out";
    private static final @NonNull String PIN_VIEW = "Pin View";
    private static final List<String> TOOLBAR_BUTTONS_TOOLTIPS;

    static {
        TIMESTAMPS = new long[]{1378850463804898643L, 1378850463804899057L, 1378850463804900219L, 1378850463804900678L, 1378850463804901308L, 1378850463804901909L, 1378850463804902763L, 1378850463804903168L, 1378850463804903766L, 1378850463804904165L, 1378850463804904970L};
        STACK_FRAMES = new String[][]{{"0x40472b", "0x4045c8", "0x404412"}, {"0x40472b", "0x4045c8", "0x404412", "0x40392b"}, {"0x40472b", "0x4045c8", "0x404412"}, {"0x40472b", "0x4045c8"}, {"0x40472b", "0x4045c8", "0x404412"}, {"0x40472b", "0x4045c8", "0x404412", "0x40392b"}, {"0x40472b", "0x4045c8", "0x404412"}, {"0x40472b", "0x4045c8"}, {"0x40472b", "0x4045c8", "0x404412"}, {"0x40472b", "0x4045c8", "0x404412", "0x40392b"}, {"0x40472b", "0x4045c8", "0x404412"}};
        TOOLBAR_BUTTONS_TOOLTIPS = ImmutableList.of((Object)CONFIGURE_SYMBOL_PROVIDERS, (Object)"", (Object)SHOW_VIEW_FILTERS, (Object)"", (Object)RESET_TIME_SCALE, (Object)SELECT_PREVIOUS_STATE_CHANGE, (Object)SELECT_NEXT_STATE_CHANGE, (Object)"", (Object)ADD_BOOKMARK, (Object)PREVIOUS_MARKER, (Object)NEXT_MARKER, (Object)"", (Object[])new String[]{SELECT_PREVIOUS_ITEM, SELECT_NEXT_ITEM, ZOOM_IN, ZOOM_OUT, "", PIN_VIEW});
    }

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        sfLogger.removeAllAppenders();
        sfLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        sfBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)sfBot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.closeView((String)"Statistics", (SWTWorkbenchBot)sfBot);
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void afterClass() {
        sfLogger.removeAllAppenders();
    }

    @Before
    public void beforeTest() {
        SWTBotUtils.createProject((String)PROJECT_NAME);
        SWTBotTreeItem treeItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)sfBot, (String)PROJECT_NAME);
        Assert.assertNotNull((Object)treeItem);
        CtfTestTrace cygProfile = CtfTestTrace.CYG_PROFILE;
        File file = new File(CtfTmfTestTraceUtils.getTrace((CtfTestTrace)cygProfile).getPath());
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)cygProfile);
        SWTBotUtils.openTrace((String)PROJECT_NAME, (String)file.getAbsolutePath(), (String)UST_ID);
        SWTBotUtils.openView((String)"org.eclipse.linuxtools.tmf.ui.views.callstack");
        WaitUtils.waitForJobs();
    }

    @After
    public void tearDown() {
        sfBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)sfBot);
    }

    @Test
    public void testOpenCallstack() {
        SWTBotView viewBot = sfBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        viewBot.setFocus();
        CallStackViewTest.waitForSymbolNames("0x40472b");
    }

    @Test
    public void testGoToTimeAndCheckStack() {
        SWTBotView viewBot = sfBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        viewBot.setFocus();
        WaitUtils.waitForJobs();
        CallStackViewTest.goToTime(TIMESTAMPS[0]);
        CallStackViewTest.waitForSymbolNames(STACK_FRAMES[0]);
    }

    @Test
    public void testGoToTimeGoBackAndForthAndCheckStack() {
        int currentEventOffset = 0;
        CallStackViewTest.goToTime(TIMESTAMPS[currentEventOffset]);
        SWTBotView viewBot = sfBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        int i = 0;
        while (i < 10) {
            viewBot.toolbarPushButton(SELECT_NEXT_STATE_CHANGE).click();
            sfBot.waitUntil(ConditionHelpers.selectionInEventsTable((SWTWorkbenchBot)sfBot, (long)TIMESTAMPS[++currentEventOffset]));
            WaitUtils.waitForJobs();
            CallStackViewTest.waitForSymbolNames(STACK_FRAMES[currentEventOffset]);
            ++i;
        }
        i = 0;
        while (i < 2) {
            viewBot.toolbarPushButton(SELECT_PREVIOUS_STATE_CHANGE).click();
            sfBot.waitUntil(ConditionHelpers.selectionInEventsTable((SWTWorkbenchBot)sfBot, (long)TIMESTAMPS[--currentEventOffset]));
            WaitUtils.waitForJobs();
            CallStackViewTest.waitForSymbolNames(STACK_FRAMES[currentEventOffset]);
            ++i;
        }
        viewBot.toolbarPushButton(SELECT_PREVIOUS_ITEM).click();
        WaitUtils.waitForJobs();
        viewBot.toolbarPushButton(SELECT_NEXT_ITEM).click();
        WaitUtils.waitForJobs();
        viewBot.toolbarPushButton(ZOOM_IN).click();
        WaitUtils.waitForJobs();
        viewBot.toolbarPushButton(ZOOM_OUT).click();
        WaitUtils.waitForJobs();
    }

    @Test
    public void testGoToTimeSortAndCheckStack() {
        CallStackViewTest.goToTime(TIMESTAMPS[0]);
        SWTBotView viewBot = sfBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        viewBot.setFocus();
        SWTBotTree tree = viewBot.bot().tree();
        tree.header(SORT_BY_NAME).click();
        tree.header(SORT_BY_ID).click();
        tree.header(SORT_BY_START).click();
        viewBot.setFocus();
        WaitUtils.waitForJobs();
        CallStackViewTest.waitForSymbolNames(STACK_FRAMES[0]);
    }

    private static void waitForSymbolNames(String ... symbolNames) {
        SWTBotView viewBot = sfBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        ArrayList symbolNameList = Lists.newArrayList((Object[])symbolNames);
        WaitUtils.waitUntil(vBot -> symbolNameList.equals(CallStackViewTest.getVisibleStackFrames(vBot)), (Object)viewBot, (String)("Wrong symbol names, expected:" + symbolNameList + ", got: " + CallStackViewTest.getVisibleStackFrames(viewBot)));
    }

    private static List<String> getVisibleStackFrames(SWTBotView viewBot) {
        SWTBotTimeGraph timeGraph = new SWTBotTimeGraph(viewBot.bot());
        ArrayList<String> stackFrames = new ArrayList<String>();
        SWTBotTimeGraphEntry[] sWTBotTimeGraphEntryArray = timeGraph.getEntry(new String[]{TRACE, PROCESS, THREAD}).getEntries();
        int n = sWTBotTimeGraphEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTimeGraphEntry entry = sWTBotTimeGraphEntryArray[n2];
            String name = entry.getText();
            if (!name.isEmpty()) {
                stackFrames.add(name);
            }
            ++n2;
        }
        return stackFrames;
    }

    private static void goToTime(long timestamp) {
        SWTBotTable table = sfBot.activeEditor().bot().table();
        table.setFocus();
        WaitUtils.waitForJobs();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)table.widget, TmfTimestamp.fromNanos((long)timestamp)));
        sfBot.waitUntil(ConditionHelpers.selectionInEventsTable((SWTWorkbenchBot)sfBot, (long)timestamp));
    }

    @Test
    public void testManipulatingMappingFiles() throws IOException {
        URL mapUrlA = CtfTmfTestTraceUtils.class.getResource("cyg-profile-mapping.txt");
        URL mapUrlB = CtfTmfTestTraceUtils.class.getResource("dummy-mapping.txt");
        URL mapUrlC = CtfTmfTestTraceUtils.class.getResource("invalid-cyg-profile-mapping.txt");
        URL mapUrlD = CtfTmfTestTraceUtils.class.getResource("random.out");
        URL mapUrlE = CtfTmfTestTraceUtils.class.getResource("win32Random.exe");
        String absoluteFileA = FileLocator.toFileURL((URL)mapUrlA).getFile();
        String absoluteFileB = FileLocator.toFileURL((URL)mapUrlB).getFile();
        String absoluteFileC = FileLocator.toFileURL((URL)mapUrlC).getFile();
        String absoluteFileD = FileLocator.toFileURL((URL)mapUrlD).getFile();
        String absoluteFileE = FileLocator.toFileURL((URL)mapUrlE).getFile();
        String[] overrideFiles = new String[]{absoluteFileA, absoluteFileA, absoluteFileB, absoluteFileC, absoluteFileD, absoluteFileE};
        TmfFileDialogFactory.setOverrideFiles((String[])overrideFiles);
        SWTBotShell shell = CallStackViewTest.openSymbolProviderDialog();
        SWTBot symbolDialog = shell.bot();
        symbolDialog.button("Add...").click();
        SWTBot errorDialog = sfBot.shell("Import failure").bot();
        errorDialog.button("OK").click();
        SWTBotTable table = symbolDialog.table();
        Assert.assertEquals((long)4L, (long)table.rowCount());
        Assert.assertEquals((Object)absoluteFileA, (Object)table.getTableItem(0).getText());
        Assert.assertEquals((Object)absoluteFileB, (Object)table.getTableItem(1).getText());
        Assert.assertEquals((Object)absoluteFileD, (Object)table.getTableItem(2).getText());
        Assert.assertEquals((Object)absoluteFileE, (Object)table.getTableItem(3).getText());
        table.select(new int[]{0});
        symbolDialog.button("Down").click().click().click();
        Assert.assertEquals((Object)absoluteFileB, (Object)table.getTableItem(0).getText());
        Assert.assertEquals((Object)absoluteFileD, (Object)table.getTableItem(1).getText());
        Assert.assertEquals((Object)absoluteFileE, (Object)table.getTableItem(2).getText());
        Assert.assertEquals((Object)absoluteFileA, (Object)table.getTableItem(3).getText());
        symbolDialog.button("Up").click().click().click();
        Assert.assertEquals((Object)absoluteFileA, (Object)table.getTableItem(0).getText());
        Assert.assertEquals((Object)absoluteFileB, (Object)table.getTableItem(1).getText());
        Assert.assertEquals((Object)absoluteFileD, (Object)table.getTableItem(2).getText());
        Assert.assertEquals((Object)absoluteFileE, (Object)table.getTableItem(3).getText());
        table.select(new int[]{0, 1});
        symbolDialog.button("Remove").click();
        Assert.assertEquals((long)2L, (long)table.rowCount());
        symbolDialog.button("Cancel").click();
    }

    @Test
    public void testLoadingMappingFiles() throws IOException {
        URL mapUrlA = CtfTmfTestTraceUtils.class.getResource("cyg-profile-mapping.txt");
        URL mapUrlB = CtfTmfTestTraceUtils.class.getResource("dummy-mapping.txt");
        String absoluteFileA = FileLocator.toFileURL((URL)mapUrlA).getFile();
        String absoluteFileB = FileLocator.toFileURL((URL)mapUrlB).getFile();
        String[] overrideFiles = new String[]{absoluteFileA, absoluteFileB};
        TmfFileDialogFactory.setOverrideFiles((String[])overrideFiles);
        SWTBotShell shell = CallStackViewTest.openSymbolProviderDialog();
        SWTBot symbolDialog = shell.bot();
        symbolDialog.button("Add...").click();
        symbolDialog.button("OK").click();
        sfBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack").setFocus();
        WaitUtils.waitForJobs();
        CallStackViewTest.goToTime(1378850463804917148L);
        CallStackViewTest.waitForSymbolNames("main", "event_loop", "draw_frame", "draw_gears", "drawB");
    }

    private static SWTBotShell openSymbolProviderDialog() {
        SWTBotView viewBot = sfBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        viewBot.setFocus();
        viewBot.toolbarButton(CONFIGURE_SYMBOL_PROVIDERS).click();
        return sfBot.shell("Symbol mapping");
    }

    @Test
    public void testGoToTimeAndCheckStackWithNames() throws IOException {
        CallStackViewTest.goToTime(TIMESTAMPS[0]);
        SWTBotView viewBot = sfBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        viewBot.setFocus();
        URL mapUrl = CtfTmfTestTraceUtils.class.getResource("cyg-profile-mapping.txt");
        String absoluteFile = FileLocator.toFileURL((URL)mapUrl).getFile();
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{absoluteFile});
        SWTBotShell shell = CallStackViewTest.openSymbolProviderDialog();
        SWTBot shellBot = shell.bot();
        shellBot.button("Add...").click();
        shellBot.button("OK").click();
        shellBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        SWTBotTimeGraph timeGraph = new SWTBotTimeGraph(viewBot.bot());
        SWTBotTimeGraphEntry[] threads = timeGraph.getEntry(new String[]{TRACE, PROCESS}).getEntries();
        Assert.assertEquals((long)1L, (long)threads.length);
        Assert.assertEquals((Object)THREAD, (Object)threads[0].getText(0));
        CallStackViewTest.waitForSymbolNames("main", "event_loop", "handle_event");
    }

    @Test
    public void testCallStackToolBar() {
        SWTBotView viewBot = sfBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        viewBot.setFocus();
        List buttons = Lists.transform((List)viewBot.getToolbarButtons(), AbstractSWTBot::getToolTipText);
        Assert.assertEquals(TOOLBAR_BUTTONS_TOOLTIPS, (Object)buttons);
    }
}

