/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tracing.rcp.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tracing.rcp.ui.ApplicationActionBarAdvisor;
import org.eclipse.tracecompass.internal.tracing.rcp.ui.TracingRcpPlugin;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final String[] UNWANTED_ACTION_SET = new String[]{"org.eclipse.search.searchActionSet", "org.eclipse.rse.core.search.searchActionSet", "org.eclipse.debug.ui.launchActionSet", "org.eclipse.debug.ui.debugActionSet", "org.eclipse.debug.ui.breakpointActionSet", "org.eclipse.team.ui", "org.eclipse.ui.externaltools.ExternalToolsSet", "org.eclipse.ui.edit.text.actionSet.convertLineDelimitersTo", "org.eclipse.ui.edit.text.actionSet.openExternalFile"};

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(false);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
    }

    public void postWindowCreate() {
        super.postWindowOpen();
        TracingRcpPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveListener());
        IProject defaultProject = ApplicationWorkbenchWindowAdvisor.createDefaultProject();
        ApplicationWorkbenchWindowAdvisor.hideActionSets();
        ApplicationWorkbenchWindowAdvisor.openTraceIfNecessary(defaultProject);
    }

    private static void openTraceIfNecessary(IProject project) {
        String traceToOpen = TracingRcpPlugin.getDefault().getCli().getArgument(".,-=open=-,.");
        String userHome = System.getProperty("user.home");
        if (traceToOpen != null && traceToOpen.startsWith("~/") && userHome != null) {
            traceToOpen = traceToOpen.replaceFirst("^~", userHome);
        }
        if (traceToOpen != null) {
            try {
                TmfTraceFolder destinationFolder = TmfProjectRegistry.getProject((IProject)project, (boolean)true).getTracesFolder();
                TmfOpenTraceHelper.openTraceFromPath((TmfTraceFolder)destinationFolder, (String)traceToOpen, (Shell)TracingRcpPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell());
            }
            catch (CoreException e) {
                TracingRcpPlugin.getDefault().logError(e.getMessage());
            }
        }
    }

    private static void hideActionSets() {
        IWorkbenchPage page = TracingRcpPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        int i = 0;
        while (i < UNWANTED_ACTION_SET.length) {
            page.hideActionSet(UNWANTED_ACTION_SET[i]);
            ++i;
        }
    }

    private static IProject createDefaultProject() {
        return TmfProjectRegistry.createProject((String)TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public class PerspectiveListener
    implements IPerspectiveListener {
        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            ApplicationWorkbenchWindowAdvisor.createDefaultProject();
            ApplicationWorkbenchWindowAdvisor.hideActionSets();
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }
    }
}

