/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.keyboard.Keyboard;
import org.eclipse.swtbot.swt.finder.keyboard.KeyboardFactory;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCanvas;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.ctf.core.tests.shared.LttngTraceGenerator;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTimeGraphViewTestBase;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphMarkerAxis;
import org.eclipse.ui.IWorkbenchPart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ResourcesViewTest
extends KernelTimeGraphViewTestBase {
    private static final String CHECK_SELECTED = "Check selected";
    private static final String CHECK_ALL = "Check all";
    private static final String CHECK_SUBTREE = "Check subtree";
    private static final String UNCHECK_SELECTED = "Uncheck selected";
    private static final String UNCHECK_ALL = "Uncheck all";
    private static final String UNCHECK_SUBTREE = "Uncheck subtree";
    private static final String NEXT_MARKER = "Next Marker";
    private static final String PREVIOUS_MARKER = "Previous Marker";
    private static final String SELECT_NEXT_STATE_CHANGE = "Select Next State Change";
    private static final String SELECT_PREVIOUS_STATE_CHANGE = "Select Previous State Change";
    private static final String ADD_BOOKMARK = "Add Bookmark...";
    private static final String REMOVE_BOOKMARK = "Remove Bookmark";
    private static final String ADD_BOOKMARK_DIALOG = "Add Bookmark";
    private static final String LOST_EVENTS = "Lost Events";
    private static final String OK = "OK";
    private static final Keyboard KEYBOARD = KeyboardFactory.getSWTKeyboard();
    private static final @NonNull ITmfTimestamp START_TIME = TmfTimestamp.fromNanos((long)1368000272650993664L);
    private static final @NonNull ITmfTimestamp LOST_EVENT_TIME1 = TmfTimestamp.fromNanos((long)1368000272681793477L);
    private static final @NonNull ITmfTimestamp LOST_EVENT_END1 = TmfTimestamp.fromNanos((long)1368000272689218808L);
    private static final @NonNull ITmfTimestamp LOST_EVENT_TIME2 = TmfTimestamp.fromNanos((long)1368000272820875850L);
    private static final @NonNull ITmfTimestamp LOST_EVENT_END2 = TmfTimestamp.fromNanos((long)1368000272827516520L);
    private static final @NonNull ITmfTimestamp LOST_EVENT_TIME3 = TmfTimestamp.fromNanos((long)1368000272882715015L);
    private static final @NonNull ITmfTimestamp LOST_EVENT_END3 = TmfTimestamp.fromNanos((long)1368000272894088400L);
    private static final @NonNull ITmfTimestamp CPU0_TIME1 = TmfTimestamp.fromNanos((long)1368000272651208412L);
    private static final @NonNull ITmfTimestamp CPU0_TIME2 = TmfTimestamp.fromNanos((long)1368000272651852656L);
    private static final @NonNull ITmfTimestamp CPU0_TIME3 = TmfTimestamp.fromNanos((long)1368000272652067404L);
    private static final @NonNull ITmfTimestamp CPU0_TIME4 = TmfTimestamp.fromNanos((long)1368000272652282152L);
    private static final @NonNull ITmfTimestamp CPU0_TIME5 = TmfTimestamp.fromNanos((long)1368000272652496900L);
    private static final int TOP_MARGIN = 1;
    private static final Point TOGGLE_SIZE = new Point(7, 8);
    private static final Point HIDE_SIZE = new Point(16, 16);

    @Override
    protected SWTBotView getViewBot() {
        return fBot.viewById("org.eclipse.tracecompass.analysis.os.linux.views.resources");
    }

    @Override
    protected List<String> getLegendValues() {
        return Arrays.asList("Idle", "Usermode", "System call", "Interrupt", "Soft Irq", "Soft Irq raised");
    }

    @Override
    protected SWTBotView openView() {
        SWTBotUtils.openView((String)"org.eclipse.tracecompass.analysis.os.linux.views.resources");
        return this.getViewBot();
    }

    @Override
    protected List<String> getToolbarTooltips() {
        return Arrays.asList("Show View Filters", "Show Legend", "", "Reset the Time Scale to Default", SELECT_PREVIOUS_STATE_CHANGE, SELECT_NEXT_STATE_CHANGE, "", ADD_BOOKMARK, PREVIOUS_MARKER, NEXT_MARKER, "", "Select Previous Resource", "Select Next Resource", "Zoom In", "Zoom Out", "", "Pin View");
    }

    @Override
    @Before
    public void before() {
        SWTBotView viewBot = this.getViewBot();
        viewBot.show();
        super.before();
        viewBot.setFocus();
    }

    @Test
    public void testKeyboardSelectNextPreviousMarker() {
        this.testNextPreviousMarker(() -> KEYBOARD.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((int)46)}), () -> KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, KeyStroke.getInstance((int)46)}), () -> KEYBOARD.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((int)44)}), () -> KEYBOARD.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, KeyStroke.getInstance((int)44)}));
    }

    @Test
    public void testToolBarSelectNextPreviousMarker() {
        SWTBotView viewBot = this.getViewBot();
        this.testNextPreviousMarker(() -> {
            SWTBotToolbarButton sWTBotToolbarButton = viewBot.toolbarButton(NEXT_MARKER).click();
        }, () -> {
            SWTBotToolbarButton sWTBotToolbarButton = viewBot.toolbarButton(NEXT_MARKER).click(131072);
        }, () -> {
            SWTBotToolbarButton sWTBotToolbarButton = viewBot.toolbarButton(PREVIOUS_MARKER).click();
        }, () -> {
            SWTBotToolbarButton sWTBotToolbarButton = viewBot.toolbarButton(PREVIOUS_MARKER).click(131072);
        });
    }

    private void testNextPreviousMarker(Runnable nextMarker, Runnable shiftNextMarker, Runnable previousMarker, Runnable shiftPreviousMarker) {
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME), START_TIME);
        SWTBotUtils.pressShortcut((Keyboard)KEYBOARD, (KeyStroke[])new KeyStroke[]{Keystrokes.HOME});
        nextMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME1, LOST_EVENT_END1), LOST_EVENT_TIME1);
        nextMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME2, LOST_EVENT_END2), LOST_EVENT_TIME2);
        nextMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME3, LOST_EVENT_END3), LOST_EVENT_TIME3);
        shiftPreviousMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME3, LOST_EVENT_TIME3), LOST_EVENT_TIME3);
        shiftPreviousMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME3, LOST_EVENT_TIME2), LOST_EVENT_TIME2);
        shiftPreviousMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME3, LOST_EVENT_TIME1), LOST_EVENT_TIME1);
        shiftNextMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME3, LOST_EVENT_END1), LOST_EVENT_END1);
        shiftNextMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME3, LOST_EVENT_END2), LOST_EVENT_END2);
        shiftNextMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME3, LOST_EVENT_END3), LOST_EVENT_END3);
        previousMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME2, LOST_EVENT_END2), LOST_EVENT_TIME2);
        previousMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME1, LOST_EVENT_END1), LOST_EVENT_TIME1);
        previousMarker.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME1, LOST_EVENT_END1), LOST_EVENT_TIME1);
    }

    @Test
    public void testShowMarkers() {
        SWTBotView viewBot = this.getViewBot();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME), START_TIME);
        SWTBotUtils.pressShortcut((Keyboard)KEYBOARD, (KeyStroke[])new KeyStroke[]{Keystrokes.HOME});
        Assert.assertTrue((boolean)viewBot.toolbarButton(NEXT_MARKER).isEnabled());
        Assert.assertTrue((boolean)viewBot.toolbarButton(PREVIOUS_MARKER).isEnabled());
        viewBot.viewMenu(LOST_EVENTS).click();
        Assert.assertFalse((boolean)viewBot.toolbarButton(NEXT_MARKER).isEnabled());
        Assert.assertFalse((boolean)viewBot.toolbarButton(PREVIOUS_MARKER).isEnabled());
        viewBot.viewMenu(LOST_EVENTS).click();
        Assert.assertTrue((boolean)viewBot.toolbarButton(NEXT_MARKER).isEnabled());
        Assert.assertTrue((boolean)viewBot.toolbarButton(PREVIOUS_MARKER).isEnabled());
    }

    @Ignore
    @Test
    public void testMarkerNavigationSubMenu() {
        SWTBotView viewBot = this.getViewBot();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME), START_TIME);
        SWTBotUtils.pressShortcut((Keyboard)KEYBOARD, (KeyStroke[])new KeyStroke[]{Keystrokes.HOME});
        viewBot.toolbarDropDownButton(NEXT_MARKER).menuItem(LOST_EVENTS).click();
        viewBot.toolbarButton(NEXT_MARKER).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME), START_TIME);
        viewBot.toolbarDropDownButton(NEXT_MARKER).menuItem(LOST_EVENTS).click();
        viewBot.toolbarButton(NEXT_MARKER).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(LOST_EVENT_TIME1, LOST_EVENT_END1), LOST_EVENT_TIME1);
    }

    @Test
    public void testAddRemoveBookmark() {
        SWTBotView viewBot = this.getViewBot();
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(10000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME), START_TIME);
        SWTBotUtils.pressShortcut((Keyboard)KEYBOARD, (KeyStroke[])new KeyStroke[]{Keystrokes.HOME});
        SWTBotUtils.pressShortcut((Keyboard)KEYBOARD, (KeyStroke[])new KeyStroke[]{Keystrokes.DOWN});
        viewBot.toolbarButton(SELECT_NEXT_STATE_CHANGE).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(CPU0_TIME1, CPU0_TIME1), CPU0_TIME1);
        viewBot.toolbarButton(SELECT_NEXT_STATE_CHANGE).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(CPU0_TIME2, CPU0_TIME2), CPU0_TIME2);
        viewBot.toolbarButton(ADD_BOOKMARK).click();
        SWTBot dialogBot = fBot.shell(ADD_BOOKMARK_DIALOG).bot();
        dialogBot.text().setText("B1");
        dialogBot.button(OK).click();
        viewBot.toolbarButton(SELECT_NEXT_STATE_CHANGE).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(CPU0_TIME3, CPU0_TIME3), CPU0_TIME3);
        viewBot.toolbarButton(SELECT_NEXT_STATE_CHANGE).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(CPU0_TIME4, CPU0_TIME4), CPU0_TIME4);
        viewBot.toolbarButton(SELECT_NEXT_STATE_CHANGE).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(CPU0_TIME4, CPU0_TIME5), CPU0_TIME5);
        viewBot.toolbarButton(ADD_BOOKMARK).click();
        dialogBot = fBot.shell(ADD_BOOKMARK_DIALOG).bot();
        dialogBot.text().setText("B2");
        dialogBot.button(OK).click();
        viewBot.toolbarButton(PREVIOUS_MARKER).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(CPU0_TIME2, CPU0_TIME2), CPU0_TIME2);
        viewBot.toolbarButton(REMOVE_BOOKMARK).click();
        viewBot.toolbarButton(NEXT_MARKER).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(CPU0_TIME4, CPU0_TIME5), CPU0_TIME5);
        viewBot.toolbarButton(REMOVE_BOOKMARK).click();
        viewBot.toolbarButton(PREVIOUS_MARKER).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(CPU0_TIME4, CPU0_TIME5), CPU0_TIME5);
        viewBot.toolbarButton(SELECT_PREVIOUS_STATE_CHANGE).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(CPU0_TIME4, CPU0_TIME4), CPU0_TIME4);
    }

    @Test
    public void testMarkerAxis() {
        SWTBotView viewBot = this.getViewBot();
        ITmfTimestamp startTime = LOST_EVENT_TIME1.normalize(-10000000L, -9);
        ITmfTimestamp endTime = LOST_EVENT_END1.normalize(10000000L, -9);
        TmfTimeRange range = new TmfTimeRange(startTime, endTime);
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, startTime));
        this.timeGraphIsReadyCondition(new TmfTimeRange(startTime, startTime), startTime);
        TimeGraphMarkerAxis markerAxis = (TimeGraphMarkerAxis)viewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphMarkerAxis.class));
        Point size1 = ResourcesViewTest.getSize((Control)markerAxis);
        viewBot.toolbarButton(ADD_BOOKMARK).click();
        SWTBot dialogBot = fBot.shell(ADD_BOOKMARK_DIALOG).bot();
        dialogBot.text().setText("B");
        dialogBot.button(OK).click();
        Point size2 = ResourcesViewTest.getSize((Control)markerAxis);
        int rowHeight = size2.y - size1.y;
        TimeGraphControl timeGraph = (TimeGraphControl)viewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class));
        int x0 = ResourcesViewTest.getXForTime(timeGraph, startTime.toNanos());
        int x1 = ResourcesViewTest.getXForTime(timeGraph, endTime.toNanos());
        SWTBotCanvas markerAxisCanvas = new SWTBotCanvas((Canvas)markerAxis);
        markerAxisCanvas.click((x0 + x1) / 2, 1 + rowHeight / 2);
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(LOST_EVENT_TIME1, LOST_EVENT_END1)));
        markerAxisCanvas.click(x0 + 2, 1 + rowHeight + rowHeight / 2);
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(startTime, startTime)));
        viewBot.toolbarButton(REMOVE_BOOKMARK).click();
        Assert.assertEquals((Object)size1, (Object)ResourcesViewTest.getSize((Control)markerAxis));
        markerAxisCanvas.click(ResourcesViewTest.TOGGLE_SIZE.x / 2, ResourcesViewTest.TOGGLE_SIZE.y / 2);
        Assert.assertEquals((long)ResourcesViewTest.TOGGLE_SIZE.y, (long)ResourcesViewTest.getSize((Control)markerAxis).y);
        markerAxisCanvas.click(ResourcesViewTest.TOGGLE_SIZE.x / 2, ResourcesViewTest.TOGGLE_SIZE.y / 2);
        Assert.assertEquals((Object)size1, (Object)ResourcesViewTest.getSize((Control)markerAxis));
        markerAxisCanvas.click(ResourcesViewTest.TOGGLE_SIZE.x + ResourcesViewTest.HIDE_SIZE.x / 2, 1 + ResourcesViewTest.HIDE_SIZE.y / 2);
        Assert.assertEquals((long)0L, (long)ResourcesViewTest.getSize((Control)markerAxis).y);
        viewBot.viewMenu(LOST_EVENTS).click();
        Assert.assertEquals((Object)size1, (Object)ResourcesViewTest.getSize((Control)markerAxis));
    }

    @Test
    public void testFilter() {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(1000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME), START_TIME);
        SWTBotToolbarButton filterButton = this.getViewBot().toolbarButton("Show View Filters");
        filterButton.click();
        SWTBot bot = fBot.shell("Filter").activate().bot();
        SWTBotTree treeBot = bot.tree();
        SWTBotTreeItem treeItem = treeBot.getTreeItem(LttngTraceGenerator.getName());
        bot.text().setText("24");
        fBot.waitUntil(ConditionHelpers.treeItemCount((SWTBotTreeItem)treeItem, (int)2));
        bot.text().setText(LttngTraceGenerator.getName());
        fBot.waitUntil(ConditionHelpers.treeItemCount((SWTBotTreeItem)treeItem, (int)75));
        int checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)"default", (long)76L, (long)checked);
        bot.button(UNCHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((long)0L, (long)checked);
        bot.button(CHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)CHECK_ALL, (long)76L, (long)checked);
        treeBot.getTreeItem(LttngTraceGenerator.getName()).select("CPU 1 States");
        bot.button(UNCHECK_ALL).click();
        bot.button(CHECK_SELECTED).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)CHECK_SELECTED, (long)2L, (long)checked);
        bot.button(UNCHECK_ALL).click();
        bot.button(CHECK_SUBTREE).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)CHECK_SUBTREE, (long)2L, (long)checked);
        bot.button(CHECK_ALL).click();
        bot.button(UNCHECK_SELECTED).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)UNCHECK_SELECTED, (long)75L, (long)checked);
        bot.button(CHECK_ALL).click();
        bot.button(UNCHECK_SUBTREE).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)UNCHECK_SELECTED, (long)75L, (long)checked);
        bot.button(UNCHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((long)0L, (long)checked);
        bot.text().setText("CPU 2");
        fBot.waitUntil(ConditionHelpers.treeItemCount((SWTBotTreeItem)treeItem, (int)75));
        bot.button(CHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)"Filtered", (long)76L, (long)checked);
        bot.button(OK).click();
    }

    private void timeGraphIsReadyCondition(@NonNull TmfTimeRange selectionRange, @NonNull ITmfTimestamp visibleTime) {
        IWorkbenchPart part = this.getViewBot().getViewReference().getPart(false);
        fBot.waitUntil(ConditionHelpers.timeGraphIsReadyCondition((AbstractTimeGraphView)((AbstractTimeGraphView)part), (TmfTimeRange)selectionRange, (ITmfTimestamp)visibleTime));
    }

    private static int getXForTime(final TimeGraphControl timeGraph, final long time) {
        return (Integer)UIThreadRunnable.syncExec((Result)new Result<Integer>(){

            public Integer run() {
                return timeGraph.getXForTime(time);
            }
        });
    }

    private static Point getSize(final Control control) {
        return (Point)UIThreadRunnable.syncExec((Result)new Result<Point>(){

            public Point run() {
                return control.getSize();
            }
        });
    }
}

