/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module;

import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.DataDrivenAnalysisModule;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.timegraph.TmfTimeGraphCompositeDataProvider;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlDataProviderManager;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;

public class XmlDataProviderManagerTest {
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace4.xml";
    private static final @NonNull String TEST_TRACE2 = "test_traces/testTrace5.xml";
    private static final @NonNull String EXPERIMENT_VIEW_ID = "test.xml.experiment.timegraph";
    private static final @NonNull String TRACE_VIEW_ID = "org.eclipse.linuxtools.tmf.analysis.xml.ui.views.statesystem";

    @Before
    public void setUp() {
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.EXPERIMENT.getFile());
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.STATE_VALUE_FILE.getFile());
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    public void cleanUp() {
        XmlUtils.deleteFile((String)TmfXmlTestFiles.EXPERIMENT.getFile().getName());
        XmlUtils.deleteFile((String)TmfXmlTestFiles.STATE_VALUE_FILE.getFile().getName());
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testOneTrace() {
        ITmfTrace trace = null;
        try {
            trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
            TmfTraceOpenedSignal signal = new TmfTraceOpenedSignal((Object)this, trace, null);
            ((TmfTrace)trace).traceOpened(signal);
            TmfTraceManager.getInstance().traceOpened(signal);
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.STATE_VALUE_FILE.getPath().toOSString(), (String)"timeGraphView", (String)TRACE_VIEW_ID);
            Assert.assertNotNull((Object)viewElement);
            @NonNull ITimeGraphDataProvider timeGraphProvider = XmlDataProviderManager.getInstance().getTimeGraphProvider(trace, viewElement);
            Assert.assertNotNull((Object)timeGraphProvider);
        }
        finally {
            if (trace != null) {
                trace.dispose();
                TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testOneTraceWithExperimentAnalysis() {
        ITmfTrace trace = null;
        try {
            trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
            TmfTraceOpenedSignal signal = new TmfTraceOpenedSignal((Object)this, trace, null);
            ((TmfTrace)trace).traceOpened(signal);
            TmfTraceManager.getInstance().traceOpened(signal);
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.EXPERIMENT.getPath().toOSString(), (String)"timeGraphView", (String)EXPERIMENT_VIEW_ID);
            Assert.assertNotNull((Object)viewElement);
            @NonNull ITimeGraphDataProvider timeGraphProvider = XmlDataProviderManager.getInstance().getTimeGraphProvider(trace, viewElement);
            Assert.assertNull((Object)timeGraphProvider);
        }
        finally {
            if (trace != null) {
                trace.dispose();
                TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testExperimentWithTraceAnalysis() {
        ITmfTrace trace = null;
        ITmfTrace trace2 = null;
        TmfExperiment experiment = null;
        try {
            trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
            trace2 = XmlUtilsTest.initializeTrace(TEST_TRACE2);
            ITmfTrace[] traces = new ITmfTrace[]{trace, trace2};
            experiment = new TmfExperiment(ITmfEvent.class, "Xml Experiment", traces, 5000, null);
            TmfTraceOpenedSignal signal = new TmfTraceOpenedSignal((Object)this, (ITmfTrace)experiment, null);
            ((TmfTrace)trace).traceOpened(signal);
            ((TmfTrace)trace2).traceOpened(signal);
            ((TmfTrace)experiment).traceOpened(signal);
            TmfTraceManager.getInstance().traceOpened(signal);
            @NonNull Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)experiment, DataDrivenAnalysisModule.class);
            modules.forEach(module -> {
                module.schedule();
                Assert.assertTrue((boolean)module.waitForCompletion());
            });
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.STATE_VALUE_FILE.getPath().toOSString(), (String)"timeGraphView", (String)TRACE_VIEW_ID);
            Assert.assertNotNull((Object)viewElement);
            @NonNull ITimeGraphDataProvider timeGraphProvider = XmlDataProviderManager.getInstance().getTimeGraphProvider((ITmfTrace)experiment, viewElement);
            Assert.assertNotNull((Object)timeGraphProvider);
            Assert.assertTrue((boolean)(timeGraphProvider instanceof TmfTimeGraphCompositeDataProvider));
        }
        catch (Throwable throwable) {
            if (trace != null) {
                trace.dispose();
            }
            if (trace2 != null) {
                trace2.dispose();
            }
            if (experiment != null) {
                experiment.dispose();
                TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, experiment));
            }
            throw throwable;
        }
        if (trace != null) {
            trace.dispose();
        }
        if (trace2 != null) {
            trace2.dispose();
        }
        if (experiment != null) {
            experiment.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, (ITmfTrace)experiment));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testExperiment() {
        ITmfTrace trace = null;
        ITmfTrace trace2 = null;
        TmfExperiment experiment = null;
        try {
            trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
            trace2 = XmlUtilsTest.initializeTrace(TEST_TRACE2);
            ITmfTrace[] traces = new ITmfTrace[]{trace, trace2};
            experiment = new TmfExperiment(ITmfEvent.class, "Xml Experiment", traces, 5000, null);
            TmfTraceOpenedSignal signal = new TmfTraceOpenedSignal((Object)this, (ITmfTrace)experiment, null);
            ((TmfTrace)trace).traceOpened(signal);
            ((TmfTrace)trace2).traceOpened(signal);
            ((TmfTrace)experiment).traceOpened(signal);
            TmfTraceManager.getInstance().traceOpened(signal);
            @NonNull Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)experiment, DataDrivenAnalysisModule.class);
            modules.forEach(module -> {
                module.schedule();
                Assert.assertTrue((boolean)module.waitForCompletion());
            });
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.EXPERIMENT.getPath().toOSString(), (String)"timeGraphView", (String)EXPERIMENT_VIEW_ID);
            Assert.assertNotNull((Object)viewElement);
            @NonNull ITimeGraphDataProvider timeGraphProvider = XmlDataProviderManager.getInstance().getTimeGraphProvider((ITmfTrace)experiment, viewElement);
            Assert.assertNotNull((Object)timeGraphProvider);
            Assert.assertFalse((boolean)(timeGraphProvider instanceof TmfTimeGraphCompositeDataProvider));
        }
        catch (Throwable throwable) {
            if (trace != null) {
                trace.dispose();
            }
            if (trace2 != null) {
                trace2.dispose();
            }
            if (experiment != null) {
                experiment.dispose();
                TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, experiment));
            }
            throw throwable;
        }
        if (trace != null) {
            trace.dispose();
        }
        if (trace2 != null) {
            trace2.dispose();
        }
        if (experiment != null) {
            experiment.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, (ITmfTrace)experiment));
        }
    }
}

