/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class XMLAnalysesManagerPreferencePageTest {
    private static final Logger fLogger = Logger.getRootLogger();
    protected static final String KERNEL_TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    protected static final String TRACE_PROJECT_NAME = "test";
    private static final String TRACE_PATH = "testfiles/syslog_collapse";
    private static final String EXTENSION = ".xml";
    private static final String TEST_FILES_FOLDER = "test_xml_files/";
    private static final String VALID_FILES_FOLDER = "test_valid/";
    private static final String INVALID_FILES_FOLDER = "test_invalid/";
    private static final String FILE_DELETE = "test_valid_extended";
    private static final String FILE_IMPORT_VALID = "test_valid";
    private static final String FILE_IMPORT_INVALID = "test_invalid";
    private static final String FILE_EDIT = "kvm_exits";
    private static final String FILE_EXPORT = "state_provider_placement";
    private static final String[] FILES_BUTTONS = new String[]{"test_state_values", "test_state_values_pattern", "test_pattern_segment", "test_doubles", "test_attributes"};
    private static final @NonNull String CHECK_SELECTED = "Check selected";
    private static final @NonNull String CHECK_ALL = "Check all";
    private static final @NonNull String UNCHECK_SELECTED = "Uncheck selected";
    private static final @NonNull String UNCHECK_ALL = "Uncheck all";
    private static SWTWorkbenchBot fBot;

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToTracingPerspective();
    }

    @Before
    public void before() {
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
        WaitUtils.waitForJobs();
        XMLAnalysesManagerPreferencePageTest.setUpTrace();
    }

    private static void setUpTrace() {
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TRACE_PATH), null);
        try {
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            File testFile = new File(uri);
            SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)testFile.getAbsolutePath(), (String)KERNEL_TRACE_TYPE);
            Assert.assertNotNull((Object)testFile);
            Assume.assumeTrue((boolean)testFile.exists());
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)"Failed to open the trace");
        }
    }

    @Test
    public void testPreferencePage() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testDelete() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, "test_xml_files/test_valid/test_valid_extended.xml");
        SWTBotTable tablebot = bot.table(0);
        tablebot.getTableItem(FILE_DELETE).select();
        bot.button("Delete").click();
        SWTBotShell deleteShell = bot.shell("Delete XML file").activate();
        deleteShell.bot().button("Yes").click();
        Assert.assertFalse((boolean)tablebot.containsItem(FILE_DELETE));
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testImportValid() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, "test_xml_files/test_valid/test_valid.xml");
        SWTBotTable tablebot = bot.table(0);
        tablebot.getTableItem(FILE_IMPORT_VALID).select();
        Assert.assertTrue((boolean)bot.label("File enabled").isVisible());
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testImportInvalid() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, "test_xml_files/test_invalid/test_invalid.xml");
        SWTBotShell popupShell = bot.shell("Import XML analysis file failed.").activate();
        popupShell.bot().button("OK").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testEdit() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, "test_xml_files/test_valid/kvm_exits.xml");
        SWTBotTable tablebot = bot.table(0);
        tablebot.getTableItem(FILE_EDIT).select();
        bot.button("Edit...").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
        fBot.editorByTitle("kvm_exits.xml").isActive();
    }

    @Test
    public void testInvalidLabel() {
        XmlUtils.addXmlFile((File)Activator.getAbsolutePath((Path)new Path("test_xml_files/test_invalid/test_invalid.xml")).toFile());
        XmlAnalysisModuleSource.notifyModuleChange();
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        SWTBotTable tablebot = bot.table(0);
        SWTBotTableItem tableItem = tablebot.getTableItem(FILE_IMPORT_INVALID);
        tableItem.select();
        Assert.assertTrue((boolean)bot.label("Invalid file").isVisible());
        Assert.assertFalse((boolean)tableItem.isChecked());
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testCheckButtons() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        SWTBotTable tableBot = bot.table(0);
        int rowCount = tableBot.rowCount();
        int i = 0;
        while (i < rowCount) {
            tableBot.getTableItem(0).select();
            bot.button("Delete").click();
            SWTBotShell deleteShell = bot.shell("Delete XML file").activate();
            deleteShell.bot().button("Yes").click();
            ++i;
        }
        int preRowCount = tableBot.rowCount();
        String[] stringArray = FILES_BUTTONS;
        int n = FILES_BUTTONS.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, "test_xml_files/test_valid/" + file + EXTENSION);
            ++n2;
        }
        int postRowCount = tableBot.rowCount();
        Assert.assertEquals((long)(preRowCount + FILES_BUTTONS.length), (long)postRowCount);
        int preCheckCount = SWTBotUtils.getTableCheckedItemCount((SWTBotTable)tableBot);
        int uncheckIndex = 2;
        tableBot.getTableItem(FILES_BUTTONS[uncheckIndex]).select();
        bot.button(UNCHECK_SELECTED).click();
        int postCheckCount = SWTBotUtils.getTableCheckedItemCount((SWTBotTable)tableBot);
        Assert.assertEquals((String)UNCHECK_SELECTED, (long)(preCheckCount - 1), (long)postCheckCount);
        tableBot.getTableItem(FILES_BUTTONS[uncheckIndex]).select();
        bot.button(CHECK_SELECTED).click();
        postCheckCount = SWTBotUtils.getTableCheckedItemCount((SWTBotTable)tableBot);
        Assert.assertEquals((String)CHECK_SELECTED, (long)preCheckCount, (long)postCheckCount);
        bot.button(UNCHECK_ALL).click();
        postCheckCount = SWTBotUtils.getTableCheckedItemCount((SWTBotTable)tableBot);
        Assert.assertEquals((String)UNCHECK_ALL, (long)0L, (long)postCheckCount);
        bot.button(CHECK_ALL).click();
        postCheckCount = SWTBotUtils.getTableCheckedItemCount((SWTBotTable)tableBot);
        Assert.assertEquals((String)CHECK_ALL, (long)postRowCount, (long)postCheckCount);
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @Test
    public void testExport() {
        SWTBot bot = XMLAnalysesManagerPreferencePageTest.openXMLAnalysesPreferences().bot();
        XMLAnalysesManagerPreferencePageTest.importAnalysis(bot, "test_xml_files/test_valid/state_provider_placement.xml");
        try {
            File targetFile = File.createTempFile(FILE_EXPORT, EXTENSION);
            TmfFileDialogFactory.setOverrideFiles((String[])new String[]{targetFile.getAbsolutePath()});
        }
        catch (IOException e) {
            Assert.fail((String)"Failed to export XML file");
        }
        SWTBotTable tableBot = bot.table(0);
        tableBot.getTableItem(FILE_EXPORT).select();
        bot.button("Export").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)bot);
    }

    @After
    public void after() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        fBot.closeAllEditors();
    }

    @AfterClass
    public static void afterClass() {
        fLogger.removeAllAppenders();
    }

    private static void importAnalysis(SWTBot bot, String relativePath) {
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{Activator.getAbsolutePath((Path)new Path(relativePath)).toString()});
        bot.button("Import").click();
        SWTBotUtils.waitUntil(tree -> tree.rowCount() > 0, (Object)bot.tree(0), (String)"Failed to import analysis");
    }

    private static SWTBotShell openXMLAnalysesPreferences() {
        SWTBotShell preferencesShell = SWTBotUtils.openPreferences((SWTBot)fBot, (String)"Manage XML analyses files");
        SWTBot bot = preferencesShell.bot();
        SWTBotTree tree = bot.tree(0);
        SWTBotTreeItem treeNode = tree.getTreeItem("Tracing");
        treeNode.select();
        treeNode.expand();
        bot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)"XML Analyses", (SWTBotTreeItem)treeNode));
        treeNode = treeNode.getNode("XML Analyses");
        treeNode.select();
        return preferencesShell;
    }
}

