/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.symbols;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.tracecompass.internal.tmf.core.callstack.FunctionNameMapper;
import org.eclipse.tracecompass.internal.tmf.core.callstack.TmfResolvedSizedSymbol;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;
import org.junit.Assert;
import org.junit.Test;

public class FunctionNameMapperTest {
    @Test
    public void testNmFile() {
        Path nmOutput = Paths.get("..", "..", "tmf", "org.eclipse.tracecompass.tmf.core.tests", "testfiles", "callstack", "nm-output-example");
        Assert.assertTrue((boolean)Files.exists(nmOutput, new LinkOption[0]));
        Map results = FunctionNameMapper.mapFromNmTextFile((File)nmOutput.toFile());
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)28L, (long)results.size());
        Assert.assertNull(results.get(null));
        FunctionNameMapperTest.assertSymbolString("completed.7259", "601190", results);
        FunctionNameMapperTest.assertSymbolString("data_start", "601048", results);
        FunctionNameMapperTest.assertSymbolString("deregister_tm_clones", "400690", results);
        FunctionNameMapperTest.assertSymbolString("__do_global_dtors_aux", "400710", results);
        FunctionNameMapperTest.assertSymbolString("__dso_handle", "601050", results);
        FunctionNameMapperTest.assertSymbolString("_DYNAMIC", "600e18", results);
        FunctionNameMapperTest.assertSymbolString("_end", "601198", results);
        FunctionNameMapperTest.assertSymbolString("_fini", "400874", results);
        FunctionNameMapperTest.assertSymbolString("frame_dummy", "400730", results);
        FunctionNameMapperTest.assertSymbolString("__FRAME_END__", "400a28", results);
        FunctionNameMapperTest.assertSymbolString("_GLOBAL_OFFSET_TABLE_", "601000", results);
        FunctionNameMapperTest.assertSymbolString("_GLOBAL__sub_I_main", "4007ad", results);
        FunctionNameMapperTest.assertSymbolString("_init", "4005d0", results);
        FunctionNameMapperTest.assertSymbolString("__init_array_end", "600e08", results);
        FunctionNameMapperTest.assertSymbolString("__init_array_start", "600df8", results);
        FunctionNameMapperTest.assertSymbolString("_IO_stdin_used", "400880", results);
        FunctionNameMapperTest.assertSymbolString("__JCR_LIST__", "600e10", results);
        FunctionNameMapperTest.assertSymbolString("__libc_csu_fini", "400870", results);
        FunctionNameMapperTest.assertSymbolString("__libc_csu_init", "400800", results);
        FunctionNameMapperTest.assertSymbolString("main", "400756", results);
        FunctionNameMapperTest.assertSymbolString("register_tm_clones", "4006d0", results);
        FunctionNameMapperTest.assertSymbolString("_start", "400660", results);
        FunctionNameMapperTest.assertSymbolString("__TMC_END__", "601058", results);
        FunctionNameMapperTest.assertSymbolString("Bar<int, int>* foo<int, int>(int, int)", "4007c2", results);
        FunctionNameMapperTest.assertSymbolString("__static_initialization_and_destruction_0(int, int)", "400770", results);
        FunctionNameMapperTest.assertSymbolString("std::cout@@GLIBCXX_3.4", "601080", results);
        FunctionNameMapperTest.assertSymbolString("std::piecewise_construct", "400884", results);
        FunctionNameMapperTest.assertSymbolString("std::__ioinit", "601191", results);
    }

    private static void assertSymbolString(String expected, String address, Map<Long, TmfResolvedSymbol> results) {
        TmfResolvedSymbol symbol = results.get(Long.parseUnsignedLong(address, 16));
        Assert.assertNotNull((Object)symbol);
        Assert.assertEquals((Object)expected, (Object)symbol.getSymbolName());
    }

    @Test
    public void testMapFileWithSize() {
        Path nmOutput = Paths.get("..", "..", "tmf", "org.eclipse.tracecompass.tmf.core.tests", "testfiles", "callstack", "withsize-123.map");
        Assert.assertTrue((boolean)Files.exists(nmOutput, new LinkOption[0]));
        Map results = FunctionNameMapper.mapFromSizedTextFile((File)nmOutput.toFile());
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertNull(results.get(null));
        FunctionNameMapperTest.assertSymbolString("Inner function with size", "ffeeddccbbaa0110", results);
        FunctionNameMapperTest.assertSymbolString("Outer function with size", "ffeeddccbbaa0100", results);
        TmfResolvedSymbol symbol = (TmfResolvedSymbol)results.get(Long.parseUnsignedLong("ffeeddccbbaa0100", 16));
        Assert.assertTrue((boolean)(symbol instanceof TmfResolvedSizedSymbol));
        TmfResolvedSizedSymbol sizedSymbol = (TmfResolvedSizedSymbol)symbol;
        Assert.assertEquals((long)Long.parseUnsignedLong("200", 16), (long)sizedSymbol.getLength());
        Assert.assertEquals((long)Long.parseUnsignedLong("ffeeddccbbaa0300", 16), (long)sizedSymbol.getEnd());
        symbol = (TmfResolvedSymbol)results.get(Long.parseUnsignedLong("ffeeddccbbaa0110", 16));
        Assert.assertTrue((boolean)(symbol instanceof TmfResolvedSizedSymbol));
        sizedSymbol = (TmfResolvedSizedSymbol)symbol;
        Assert.assertEquals((long)Long.parseUnsignedLong("20", 16), (long)sizedSymbol.getLength());
        Assert.assertEquals((long)Long.parseUnsignedLong("ffeeddccbbaa0130", 16), (long)sizedSymbol.getEnd());
    }

    @Test
    public void testGuessingFileType() {
        Path path = Paths.get("..", "..", "tmf", "org.eclipse.tracecompass.tmf.core.tests", "testfiles", "callstack", "nm-output-example");
        Assert.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        Assert.assertEquals((String)"guess nm output", (Object)FunctionNameMapper.MappingType.NM, (Object)FunctionNameMapper.guessMappingType((File)path.toFile()));
        path = Paths.get("..", "..", "tmf", "org.eclipse.tracecompass.tmf.core.tests", "testfiles", "callstack", "withsize-123.map");
        Assert.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        Assert.assertEquals((String)"guess sized mapping", (Object)FunctionNameMapper.MappingType.MAP_WITH_SIZE, (Object)FunctionNameMapper.guessMappingType((File)path.toFile()));
        path = Paths.get("..", "..", "tmf", "org.eclipse.tracecompass.tmf.core.tests", "testfiles", "callstack", "emptyFile");
        Assert.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        Assert.assertEquals((String)"guess sized mapping", (Object)FunctionNameMapper.MappingType.UNKNOWN, (Object)FunctionNameMapper.guessMappingType((File)path.toFile()));
    }
}

