/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotStyledText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class FontEventEditorTest {
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String COLUMN_TRACE = "syslog_collapse";
    private static final String COLUMN_TRACE_PATH = "testfiles/syslog_collapse";
    private static final String COLUMN_TRACE_TYPE = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static File fTestFile = null;
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(COLUMN_TRACE_PATH), null);
        try {
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            fTestFile = new File(uri);
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
        Assume.assumeTrue((boolean)fTestFile.exists());
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("Welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void tearDown() {
        fLogger.removeAllAppenders();
    }

    @Test
    public void testChangeFont() {
        SWTBotUtils.createProject(TRACE_PROJECT_NAME);
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, fTestFile.getAbsolutePath(), COLUMN_TRACE_TYPE);
        SWTBotEditor editorBot = SWTBotUtils.activateEditor(fBot, fTestFile.getName());
        SWTBotTable tableBot = editorBot.bot().table();
        SWTBotUtils.maximize(editorBot.getReference(), tableBot);
        tableBot.contextMenu("Show Raw").click();
        tableBot.setFocus();
        tableBot.click(4, 1);
        tableBot.select(new int[]{4});
        SWTBotStyledText rawText = editorBot.bot().styledText();
        FontData font = FontEventEditorTest.getFont(rawText);
        SWTBotShell preferencesShell = SWTBotUtils.openPreferences((SWTBot)fBot);
        SWTBot bot = preferencesShell.bot();
        preferencesShell.activate();
        bot.text().setText("color");
        SWTBotTreeItem generalItem = bot.tree().getTreeItem("General");
        generalItem.click();
        generalItem.select();
        bot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable("Appearance", generalItem));
        SWTBotTreeItem appearanceNode = generalItem.getNode("Appearance");
        appearanceNode.click();
        appearanceNode.select();
        bot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable("Colors and Fonts", appearanceNode));
        SWTBotTreeItem colorAndFontNode = appearanceNode.getNode("Colors and Fonts");
        colorAndFontNode.click();
        colorAndFontNode.select();
        SWTBotTreeItem tracingItem = bot.tree(1).getTreeItem("Tracing");
        tracingItem.click();
        tracingItem.select();
        tracingItem.expand();
        SWTBotTreeItem traceEventTableFont = tracingItem.getNode("Trace event raw text font (set to default: Text Font)");
        traceEventTableFont.click();
        traceEventTableFont.select();
        bot.button("Use System Font").click();
        bot.button("Apply").click();
        FontData font2 = FontEventEditorTest.getFont(rawText);
        Assert.assertFalse((boolean)font2.equals((Object)font));
        bot.button("Reset").click();
        SWTBotUtils.pressOKishButtonInPreferences((SWTBot)fBot);
        Assert.assertEquals((Object)FontEventEditorTest.getFont(rawText), (Object)font);
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject(TRACE_PROJECT_NAME, fBot);
    }

    private static FontData getFont(final SWTBotStyledText rawText) {
        return (FontData)UIThreadRunnable.syncExec((Result)new Result<FontData>(){

            public FontData run() {
                return ((StyledText)rawText.widget).getFont().getFontData()[0];
            }
        });
    }
}

