/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.core.tests.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.btf.core.tests.BtfTestPlugin;
import org.eclipse.tracecompass.btf.core.trace.BtfTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.osgi.framework.Bundle;

public enum BtfTestTrace {
    BTF_TEST("20140219-123819.btf");

    private final String fPath;
    private final String fDirectory = "testfiles";
    private BtfTrace fTrace = null;

    private BtfTestTrace(String file) {
        this.fPath = file;
    }

    public String getPath() {
        return this.fPath;
    }

    public String getFullPath() {
        return "testfiles" + File.separator + this.fPath;
    }

    public BtfTrace getTrace() {
        if (this.fTrace != null) {
            this.fTrace.dispose();
        }
        Bundle bundle = BtfTestPlugin.getBundle();
        Path path = new Path("testfiles" + File.separator + this.fPath);
        URL location = FileLocator.find((Bundle)bundle, (IPath)path, null);
        try {
            File test = new File(FileLocator.toFileURL((URL)location).toURI());
            this.fTrace = new BtfTrace();
            this.fTrace.initTrace(null, test.getAbsolutePath(), null);
        }
        catch (IOException | URISyntaxException | TmfTraceException e) {
            throw new RuntimeException(e);
        }
        return this.fTrace;
    }

    public void dispose() {
        if (this.fTrace != null) {
            this.fTrace.dispose();
            this.fTrace = null;
        }
    }
}

