/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateSystem2DTest {
    private static final long START_TIME = 50L;
    private static final @NonNull String STRING_ATTRIBUTE = "String";
    private static final @NonNull String INTEGER_ATTRIBUTE = "Integer";
    private ITmfStateSystemBuilder fStateSystem;

    @Before
    public void setupStateSystem() throws IOException {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createHistoryTreeBackendNewFile((String)"test", (File)((File)NonNullUtils.checkNotNull((Object)File.createTempFile("2Dtest", "ht"))), (int)0, (long)50L, (int)0);
        this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)((IStateHistoryBackend)NonNullUtils.checkNotNull((Object)backend)));
        int stringQuark = this.fStateSystem.getQuarkAbsoluteAndAdd(new String[]{STRING_ATTRIBUTE});
        int integerQuark = this.fStateSystem.getQuarkAbsoluteAndAdd(new String[]{INTEGER_ATTRIBUTE});
        this.fStateSystem.modifyAttribute(60L, (Object)"String1", stringQuark);
        this.fStateSystem.modifyAttribute(70L, (Object)0, integerQuark);
        this.fStateSystem.modifyAttribute(80L, (Object)1, integerQuark);
        this.fStateSystem.modifyAttribute(90L, (Object)"String2", stringQuark);
        this.fStateSystem.modifyAttribute(100L, (Object)2, integerQuark);
        this.fStateSystem.modifyAttribute(110L, (Object)3, integerQuark);
        this.fStateSystem.modifyAttribute(130L, (Object)"String3", stringQuark);
        this.fStateSystem.modifyAttribute(140L, (Object)"String4", stringQuark);
        this.fStateSystem.modifyAttribute(160L, (Object)4, integerQuark);
        this.fStateSystem.closeHistory(200L);
    }

    @After
    public void tearDown() {
        this.fStateSystem.dispose();
        this.fStateSystem.removeFiles();
    }

    private static void testContinuous(Iterable<ITmfStateInterval> iterable, Collection<Integer> quarks, long start, long end, int totalCount) {
        TreeMultimap treeMap = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        iterable.forEach(arg_0 -> StateSystem2DTest.lambda$1((Multimap)treeMap, arg_0));
        Assert.assertEquals((String)"Wrong number of intervals returned", (long)totalCount, (long)treeMap.size());
        Assert.assertEquals((String)"There should only be as many Sets of intervals as quarks", (long)quarks.size(), (long)treeMap.keySet().size());
        for (Integer quark : quarks) {
            Collection orderedSet = treeMap.get((Object)quark);
            Assert.assertFalse((String)("There should be intervals for quark: " + quark), (boolean)orderedSet.isEmpty());
            ITmfStateInterval previous = null;
            for (ITmfStateInterval interval : orderedSet) {
                if (previous == null) {
                    Assert.assertTrue((String)("The first interval: " + interval + "should intersect start: " + start), (boolean)interval.intersects(start));
                } else {
                    Assert.assertEquals((String)("Current interval: " + interval + " should have been contiguous to the previous one " + previous), (long)(previous.getEndTime() + 1L), (long)interval.getStartTime());
                }
                previous = interval;
            }
            Assert.assertNotNull((String)("There should have been at least one interval for quark " + quark), previous);
            Assert.assertTrue((String)("last interval: " + previous + " should intersect end " + end), (boolean)previous.intersects(end));
        }
    }

    @Test
    public void testContinuous2DQuery() throws AttributeNotFoundException, IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        long end = ss.getCurrentEndTime();
        int stringQuark = this.fStateSystem.getQuarkAbsolute(new String[]{STRING_ATTRIBUTE});
        Iterable iterable = ss.query2D(Collections.singleton(stringQuark), 50L, end);
        StateSystem2DTest.testContinuous(iterable, Collections.singleton(stringQuark), 50L, end, 5);
        int integerQuark = this.fStateSystem.getQuarkAbsolute(new String[]{INTEGER_ATTRIBUTE});
        iterable = ss.query2D(Collections.singleton(integerQuark), 50L, end);
        StateSystem2DTest.testContinuous(iterable, Collections.singleton(integerQuark), 50L, end, 6);
        ImmutableList quarks = ImmutableList.of((Object)stringQuark, (Object)integerQuark);
        iterable = ss.query2D((Collection)quarks, 50L, end);
        StateSystem2DTest.testContinuous(iterable, (Collection<Integer>)quarks, 50L, end, 11);
    }

    private static void testDiscrete(Iterable<ITmfStateInterval> iterable, Collection<Integer> quarks, Collection<Long> times, int totalCount) {
        HashSet<ITmfStateInterval> set = new HashSet<ITmfStateInterval>();
        int countTimeStamps = 0;
        for (ITmfStateInterval interval : iterable) {
            Assert.assertTrue((boolean)quarks.contains(interval.getAttribute()));
            Assert.assertTrue((String)("interval: " + interval + " was returned twice"), (boolean)set.add(interval));
            int timeStamps = (int)times.stream().filter(arg_0 -> ((ITmfStateInterval)interval).intersects(arg_0)).count();
            Assert.assertTrue((String)("interval: " + interval + " does not intersect any time stamp: " + times), (timeStamps > 0 ? 1 : 0) != 0);
            countTimeStamps += timeStamps;
        }
        Assert.assertEquals((String)"incorrect number of intervals returned", (long)totalCount, (long)set.size());
        Assert.assertEquals((String)"All the queried time stamps were not covered", (long)(times.size() * quarks.size()), (long)countTimeStamps);
    }

    @Test
    public void testDiscrete2DQuery() throws AttributeNotFoundException, IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        long end = ss.getCurrentEndTime();
        List times = StateSystemUtils.getTimes((long)50L, (long)end, (long)30L);
        Assert.assertEquals((long)6L, (long)times.size());
        Assert.assertTrue((boolean)Ordering.natural().isStrictlyOrdered((Iterable)times));
        int stringQuark = this.fStateSystem.getQuarkAbsolute(new String[]{STRING_ATTRIBUTE});
        Iterable iterable = ss.query2D(Collections.singleton(stringQuark), (Collection)times);
        StateSystem2DTest.testDiscrete(iterable, Collections.singleton(stringQuark), times, 4);
        int integerQuark = this.fStateSystem.getQuarkAbsolute(new String[]{INTEGER_ATTRIBUTE});
        iterable = ss.query2D(Collections.singleton(integerQuark), (Collection)times);
        StateSystem2DTest.testDiscrete(iterable, Collections.singleton(integerQuark), times, 4);
        ImmutableList quarks = ImmutableList.of((Object)stringQuark, (Object)integerQuark);
        iterable = ss.query2D((Collection)quarks, (Collection)times);
        StateSystem2DTest.testDiscrete(iterable, (Collection<Integer>)quarks, times, 8);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIOOB2DQuery() throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        Set<Long> times = Collections.singleton(77L);
        int stringQuark = Integer.MAX_VALUE;
        ss.query2D(Collections.singleton(stringQuark), times);
    }

    @Test(expected=TimeRangeException.class)
    public void testTimeRangeException2DContinous() throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        ss.query2D(Collections.singleton(0), 0L, 77L);
    }

    @Test(expected=TimeRangeException.class)
    public void testTimeRangeException2DDiscrete() throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        ss.query2D(Collections.singleton(0), Collections.singleton(Long.MIN_VALUE));
    }

    @Test
    public void testEmpty2DQuery() throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        Iterable iterable = ss.query2D(Collections.emptyList(), Collections.singleton(77L));
        Assert.assertNotNull((Object)iterable);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)iterable));
        iterable = ss.query2D(Collections.singleton(0), Collections.emptyList());
        Assert.assertNotNull((Object)iterable);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)iterable));
        iterable = ss.query2D(Collections.emptyList(), 77L, 78L);
        Assert.assertNotNull((Object)iterable);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)iterable));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test(expected=IllegalArgumentException.class)
    public void testIllegalBounds() throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = this.fStateSystem;
        Assert.assertNotNull((Object)ss);
        @NonNull Iterable iterable = ss.query2D(Collections.emptyList(), 80L, 78L);
        Assert.assertNotNull((Object)iterable);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)iterable));
    }

    private static /* synthetic */ void lambda$1(Multimap multimap, ITmfStateInterval interval) {
        Assert.assertTrue((String)("Interval: " + interval + " was already returned: " + multimap), (boolean)multimap.put((Object)interval.getAttribute(), (Object)interval));
    }
}

