/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.DataDrivenStateProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlMapEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.w3c.dom.Element;

public abstract class TmfXmlStateValue
implements ITmfXmlStateValue {
    private final TmfXmlStateValueBase fStateValue;
    private final List<ITmfXmlStateAttribute> fPath;
    private final @Nullable String fEventField;
    private final @Nullable String fID;
    private final boolean fIncrement;
    private final boolean fUpdate;
    private final ValueTypeStack fStackType;
    private final ITmfStateValue.Type fForcedType;
    private final IXmlStateSystemContainer fContainer;
    private final String fMappingGroup;

    protected TmfXmlStateValue(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container, List<ITmfXmlStateAttribute> attributes, @Nullable String eventField) {
        this.fPath = attributes;
        this.fContainer = container;
        this.fEventField = eventField;
        if (!node.getNodeName().equals("stateValue")) {
            throw new IllegalArgumentException("TmfXmlStateValue constructor: Element is not a stateValue");
        }
        String id = node.getAttribute("id");
        this.fID = id.isEmpty() ? null : id;
        this.fIncrement = Boolean.parseBoolean(node.getAttribute("increment"));
        this.fUpdate = Boolean.parseBoolean(node.getAttribute("update"));
        this.fStateValue = this.initializeStateValue(modelFactory, node);
        String forcedTypeName = node.getAttribute("forcedType");
        this.fForcedType = forcedTypeName.isEmpty() ? ITmfStateValue.Type.NULL : TmfXmlUtils.getTmfStateValueByName(forcedTypeName);
        String stack = node.getAttribute("stack");
        this.fStackType = ValueTypeStack.getTypeFromString(stack);
        this.fMappingGroup = node.getAttribute("mappingGroup");
    }

    protected TmfXmlStateValueBase initializeStateValue(ITmfXmlModelFactory modelFactory, Element node) {
        return new TmfXmlStateValueNull();
    }

    public @Nullable String getID() {
        return this.fID;
    }

    protected IXmlStateSystemContainer getSsContainer() {
        return this.fContainer;
    }

    protected @Nullable ITmfStateSystem getStateSystem() {
        return this.fContainer.getStateSystem();
    }

    protected boolean isIncrement() {
        return this.fIncrement;
    }

    protected boolean isUpdate() {
        return this.fUpdate;
    }

    protected ValueTypeStack getStackType() {
        return this.fStackType;
    }

    protected ITmfStateValue.Type getForcedType() {
        return this.fForcedType;
    }

    @Override
    public ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
        return this.getMappedValue(event, scenarioInfo, this.fStateValue.getValue(event, scenarioInfo));
    }

    private ITmfStateValue getMappedValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo, ITmfStateValue value) {
        try {
            Set<TmfXmlMapEntry> group = null;
            if (this.fContainer instanceof XmlPatternStateProvider) {
                group = ((XmlPatternStateProvider)this.fContainer).getLegacyMappingGroup(this.fMappingGroup);
            } else if (this.fContainer instanceof DataDrivenStateProvider) {
                Activator.logError("You should not get to this part of the code if the container is a DataDrivenStateProvider");
            }
            if (group != null) {
                for (TmfXmlMapEntry entry : group) {
                    if (!entry.getKey().getValue(event, scenarioInfo).equals(value)) continue;
                    return entry.getValue().getValue(event, scenarioInfo);
                }
            }
            return value;
        }
        catch (AttributeNotFoundException e) {
            Activator.logError("Unable to map the state value");
            return TmfStateValue.nullValue();
        }
    }

    @Override
    public ITmfStateValue getEventFieldValue(@NonNull ITmfEvent event) {
        String eventField = this.fEventField;
        if (eventField == null) {
            throw new IllegalStateException();
        }
        return this.getEventFieldValue(event, eventField);
    }

    protected ITmfStateValue getEventFieldValue(ITmfEvent event, String fieldName) {
        TmfStateValue value = TmfStateValue.nullValue();
        ITmfEventField field = event.getContent().getField(new String[]{fieldName});
        Object fieldValue = null;
        if (field == null) {
            if (fieldName.equalsIgnoreCase("cpu")) {
                Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
                if (cpu != null) {
                    return TmfStateValue.newValueInt((int)cpu);
                }
            } else {
                if (fieldName.equalsIgnoreCase("timestamp")) {
                    return TmfStateValue.newValueLong((long)event.getTimestamp().getValue());
                }
                if (fieldName.equalsIgnoreCase("hostId")) {
                    return TmfStateValue.newValueString((String)event.getTrace().getHostId());
                }
            }
            if ((fieldValue = TmfTraceUtils.resolveAspectOfNameForEvent((ITmfTrace)event.getTrace(), (String)fieldName, (ITmfEvent)event)) == null) {
                return value;
            }
        } else {
            fieldValue = field.getValue();
        }
        value = TmfXmlUtils.newTmfStateValueFromObjectWithForcedType(fieldValue, this.fForcedType);
        return value;
    }

    @Override
    public List<ITmfXmlStateAttribute> getAttributes() {
        return this.fPath;
    }

    @Override
    public void handleEvent(@NonNull ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException, StateValueTypeException, TimeRangeException {
        int quark = -1;
        for (ITmfXmlStateAttribute attribute : this.fPath) {
            quark = attribute.getAttributeQuark(event, quark, scenarioInfo);
            if (quark != -1) continue;
            Activator.logError("Not found XML attribute " + attribute);
            return;
        }
        long ts = event.getTimestamp().getValue();
        this.fStateValue.handleEvent(event, quark, ts, scenarioInfo);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TmfXmlStateValue: ");
        if (this.fEventField != null) {
            builder.append("Field=").append(this.fEventField).append("; ");
        } else if (!this.fPath.isEmpty()) {
            builder.append("Path=").append(this.fPath).append("; ");
        }
        builder.append(this.fStateValue);
        return builder.toString();
    }

    protected abstract class TmfXmlStateValueBase {
        protected TmfXmlStateValueBase() {
        }

        public abstract ITmfStateValue getValue(@Nullable ITmfEvent var1, @Nullable TmfXmlScenarioInfo var2) throws AttributeNotFoundException;

        public void handleEvent(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            if (TmfXmlStateValue.this.fIncrement) {
                this.incrementValue(event, quark, timestamp, scenarioInfo);
            } else {
                ITmfStateValue value = this.getValue(event, scenarioInfo);
                this.processValue(quark, timestamp, value);
            }
        }

        protected void processValue(int quark, long timestamp, ITmfStateValue value) throws TimeRangeException, StateValueTypeException, AttributeNotFoundException {
        }

        protected void incrementValue(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
        }
    }

    private class TmfXmlStateValueNull
    extends TmfXmlStateValueBase {
        private TmfXmlStateValueNull() {
        }

        @Override
        public ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
            return TmfStateValue.nullValue();
        }

        public String toString() {
            return "NULL";
        }
    }

    protected static enum ValueTypeStack {
        NULL,
        PEEK,
        POP,
        POP_ALL,
        PUSH;


        public static ValueTypeStack getTypeFromString(String input) {
            switch (input) {
                case "push": {
                    return PUSH;
                }
                case "pop": {
                    return POP;
                }
                case "peek": {
                    return PEEK;
                }
                case "popAll": {
                    return POP_ALL;
                }
            }
            return NULL;
        }
    }
}

