/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.filter.parser;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterCu;
import org.eclipse.tracecompass.tmf.core.tests.filter.parser.ElementResolverStub;
import org.junit.Assert;
import org.junit.Test;

public class ElementResolverFilterTest {
    private static final ElementResolverStub ELEMENT = new ElementResolverStub((Map<String, String>)ImmutableMap.of((Object)"label", (Object)"elementLabel", (Object)"key0", (Object)"value0", (Object)"key1", (Object)"value1", (Object)"key 2", (Object)"value2", (Object)"key3", (Object)"10"));

    @Test
    public void testRegex() {
        FilterCu cu = FilterCu.compile((String)"Label");
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"fail");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"0$");
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"a.*l");
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"y$");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testLogicalOperator() {
        FilterCu cu = FilterCu.compile((String)"Label && value");
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"label && fail");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"Label || absent");
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"absent || fail");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testEqualsOperator() {
        FilterCu cu = FilterCu.compile((String)"label == elementLabel");
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"label == fail");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testNotEqualsOperator() {
        FilterCu cu = FilterCu.compile((String)"label != fail");
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"label != elementLabel");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testNotOperator() {
        FilterCu cu = FilterCu.compile((String)"!fail");
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"!elementLabel");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testContainsOperator() {
        FilterCu cu = FilterCu.compile((String)"label contains element");
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"label contains value");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testPresentOperator() {
        FilterCu cu = FilterCu.compile((String)"key1 present");
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"invalidKey present");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testMatchesOperator() {
        FilterCu cu = FilterCu.compile((String)"key1 matches v.*ue");
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"key1 matches v.*ue$");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)" \"key 2\" matches value2");
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testGreaterThanOperator() {
        FilterCu cu = FilterCu.compile((String)"key3 > 9");
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"key3 > 10");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testLessThanOperator() {
        FilterCu cu = FilterCu.compile((String)"key3 < 11");
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"key3 < 10");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testComplexFilter() {
        FilterCu cu = FilterCu.compile((String)"(key1 matches v.*ue) && Label");
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"!(key1 matches v.*ue) && Label");
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }
}

