/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards;

import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportTraceWizard;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class AbstractStandardImportWizardTest {
    public static final String PROJECT_NAME = "Tracing";
    private Wizard fWizard;
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        fBot = new SWTWorkbenchBot();
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new NullAppender());
    }

    @AfterClass
    public static void terminate() {
        fLogger.removeAllAppenders();
    }

    public static SWTWorkbenchBot getSWTBot() {
        return fBot;
    }

    public void createProject() {
        SWTBotUtils.closeView("Welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.createProject(PROJECT_NAME);
    }

    public void openImportWizard() {
        this.fWizard = new ImportTraceWizard();
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null) {
                    IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                    Shell shell = activeWorkbenchWindow.getShell();
                    Assert.assertNotNull((Object)shell);
                    ((ImportTraceWizard)AbstractStandardImportWizardTest.this.fWizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)AbstractStandardImportWizardTest.this.fWizard);
                    dialog.open();
                }
            }
        });
        fBot.waitUntil(ConditionHelpers.isWizardReady(this.fWizard));
    }

    public void importFinish() {
        SWTBotShell shell = fBot.activeShell();
        SWTBotButton finishButton = fBot.button("Finish");
        finishButton.click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        WaitUtils.waitForJobs();
    }
}

