/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.ui.actions.HttpTraceImportOperation;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.PlatformUI;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class HttpTraceImportOperationTest {
    private static TmfTraceFolder fDestFolder;
    private static String fTestTrace1Url;
    private static String fTestTrace2Url;
    private static String fTraceArchiveUrl;
    private static List<String> fImportedTraceNameList;

    static {
        fTestTrace1Url = "http://archive.eclipse.org/tracecompass/test-traces/tmf/syslog";
        fTestTrace2Url = "http://archive.eclipse.org/tracecompass/test-traces/tmf/syslog_collapse";
        fTraceArchiveUrl = "http://archive.eclipse.org/tracecompass/test-traces/tmf/syslogs.zip";
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        IProject project = TmfProjectRegistry.createProject((String)"Test Project", null, null);
        TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        TmfTraceFolder tracesFolder = (TmfTraceFolder)NonNullUtils.checkNotNull((Object)projectElement.getTracesFolder());
        tracesFolder.getResource().getFolder("Folder").create(false, true, null);
        tracesFolder.refresh();
        fDestFolder = (TmfTraceFolder)tracesFolder.getChildren().stream().filter(element -> element.getName().equals("Folder")).findFirst().get();
        fImportedTraceNameList = new ArrayList<String>();
        fImportedTraceNameList.add("syslog");
        fImportedTraceNameList.add("syslog_collapse");
    }

    @AfterClass
    public static void afterClass() throws CoreException {
        if (fDestFolder != null) {
            fDestFolder.getProject().getResource().delete(true, null);
        }
    }

    @Test
    public void testTraceImport() throws Exception {
        HttpTraceImportOperation operation = new HttpTraceImportOperation(fTestTrace1Url, fDestFolder);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            Assume.assumeTrue((boolean)false);
        }
        HttpTraceImportOperationTest.validateImport(Collections.singletonList("syslog"));
    }

    @Test
    public void testMultipleTracesImport() throws Exception {
        ArrayList<String> tracesUrl = new ArrayList<String>();
        tracesUrl.add(fTestTrace1Url);
        tracesUrl.add(fTestTrace2Url);
        HttpTraceImportOperation operation = new HttpTraceImportOperation(tracesUrl, fDestFolder);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            Assume.assumeTrue((boolean)false);
        }
        HttpTraceImportOperationTest.validateImport(fImportedTraceNameList);
    }

    @Test
    public void testArchiveImport() throws Exception {
        HttpTraceImportOperation operation = new HttpTraceImportOperation(fTraceArchiveUrl, fDestFolder);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            Assume.assumeTrue((boolean)false);
        }
        HttpTraceImportOperationTest.validateImport(fImportedTraceNameList);
    }

    private static void validateImport(List<String> expectedImportFiles) {
        List destFolderChildren = fDestFolder.getChildren();
        Assert.assertEquals((long)expectedImportFiles.size(), (long)destFolderChildren.size());
        for (ITmfProjectModelElement element : destFolderChildren) {
            Assert.assertTrue((boolean)expectedImportFiles.contains(element.getName()));
        }
    }
}

