/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TestRefreshTextTrace {
    private static final String PROJECT_NAME = "Test";
    private static final String TRACE_TYPE_SYSLOG = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static final String TIMESTAMP_FORMAT = "MMM dd HH:mm:ss";
    private static final long INITIAL_NB_EVENTS = 100L;
    private static final int NEW_EVENTS_PER_REFRESH = 40000;
    private static final int NB_REFRESH = 3;
    private static final long SECOND_TO_MILLISECOND = 1000L;
    private static final long MICROSECOND_TO_NANOSECOND = 1000000L;
    private static final int INDEXING_TIMEOUT = 300000;
    private static final Calendar CURRENT = Calendar.getInstance();
    private static final String TRACE_LOCATION = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator + "test.txt";
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;
    private long fNbWrittenEvents = 0L;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void init() {
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new NullAppender());
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void afterClass() {
        fLogger.removeAllAppenders();
    }

    @Before
    public void before() throws Exception {
        SWTBotUtils.createProject(PROJECT_NAME);
        SWTBotUtils.openTrace(PROJECT_NAME, this.createTrace(100L), this.getTraceType());
        WaitUtils.waitForJobs();
    }

    @After
    public void after() {
        SWTBotUtils.deleteProject(PROJECT_NAME, fBot);
    }

    @Test
    public void testRefresh() throws IOException {
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)activeTrace);
        fBot.waitUntil((ICondition)new NumberOfEventsCondition(activeTrace, 100L));
        int i = 0;
        while (i < 3) {
            this.appendToTrace(40000L);
            fBot.viewByTitle("Project Explorer").show();
            fBot.menu().menu(new String[]{"File", "Refresh"}).click();
            fBot.shell("Trace Changed").activate().bot().button("No").click();
            SWTBotEditor eventsEditor = SWTBotUtils.activeEventsEditor(fBot);
            eventsEditor.setFocus();
            fBot.menu().menu(new String[]{"File", "Refresh"}).click();
            fBot.waitUntil((ICondition)new NumberOfEventsCondition(activeTrace, this.getNbWrittenEvents()), 300000L);
            ++i;
        }
        TestRefreshTextTrace.goToTableEnd();
        fBot.waitUntil(ConditionHelpers.selectionInEventsTable(fBot, this.getExpectedEndTimeStamp()));
    }

    protected String createTrace(long nbEvents) throws Exception {
        this.writeToTrace(nbEvents, false);
        return TRACE_LOCATION;
    }

    protected void appendToTrace(long nbEvents) throws IOException {
        this.writeToTrace(nbEvents, true);
    }

    private void writeToTrace(long nbEvents, boolean append) throws IOException {
        File file = new File(TRACE_LOCATION);
        Throwable throwable = null;
        Object var6_6 = null;
        try (FileWriter writer = new FileWriter(file, append);){
            int i = 0;
            while ((long)i < nbEvents) {
                this.writeEvent(writer);
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeEvent(FileWriter fw) throws IOException {
        SimpleDateFormat f = new SimpleDateFormat(TIMESTAMP_FORMAT);
        String timeStampStr = f.format(new Date(this.fNbWrittenEvents * 1000L));
        fw.write(String.valueOf(timeStampStr) + " HostF LoggerF: SourceFileF:9 Message F\n");
        ++this.fNbWrittenEvents;
    }

    protected String getTraceType() {
        return TRACE_TYPE_SYSLOG;
    }

    protected long getExpectedEndTimeStamp() {
        Date date = new Date((this.fNbWrittenEvents - 1L) * 1000L);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(1, CURRENT.get(1));
        if (calendar.after(CURRENT)) {
            calendar.set(1, CURRENT.get(1) - 1);
        }
        return calendar.getTimeInMillis() * 1000000L;
    }

    private static void goToTableEnd() {
        SWTBotEditor eventsEditor = SWTBotUtils.activeEventsEditor(fBot);
        eventsEditor.setFocus();
        eventsEditor.bot().table().pressShortcut(new KeyStroke[]{Keystrokes.END});
    }

    protected long getNbWrittenEvents() {
        return this.fNbWrittenEvents;
    }

    private static class NumberOfEventsCondition
    extends DefaultCondition {
        private ITmfTrace fTrace;
        private long fNbEvents;

        private NumberOfEventsCondition(ITmfTrace trace, long nbEvents) {
            this.fTrace = trace;
            this.fNbEvents = nbEvents;
        }

        public boolean test() throws Exception {
            return this.fTrace.getNbEvents() == this.fNbEvents;
        }

        public String getFailureMessage() {
            return String.valueOf(this.fTrace.getName()) + " did not contain the expected number of " + this.fNbEvents + " events. Current: " + this.fTrace.getNbEvents();
        }
    }
}

