/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TestImportExportPackageWizard {
    private static final String EXPORT_LOCATION = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator + "test.zip";
    private static final String TRACE_LOCATION = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator + "test.xml";
    private static final String IMPORT_TRACE_PACKAGE = "Import Trace Package...";
    private static final String IMPORT_TRACE_PACKAGE_TITLE = "Import trace package";
    private static final String EXPORT_TRACE_PACKAGE = "Export Trace Package...";
    private static final String EXPORT_TRACE_PACKAGE_TITLE = "Export trace package";
    private static final String PROJECT_EXPLORER = "Project Explorer";
    private static final String FINISH = "Finish";
    private static final String CONFIRMATION = "Confirmation";
    private static final String YES_TO_ALL = "Yes To All";
    private static final String COMPRESS_THE_CONTENTS_OF_THE_FILE = "Compress the contents of the file";
    private static final String SAVE_IN_ZIP_FORMAT = "Save in zip format";
    private static final String SAVE_IN_TAR_FORMAT = "Save in tar format";
    private static final String SELECT_ALL = "Select All";
    private static final String DESELECT_ALL = "Deselect All";
    private static final String SWT_BOT_THREAD_NAME = "SWTBot Thread";
    private static final String PROJECT_NAME = "Test";
    private static final String XMLSTUB_ID = "org.eclipse.linuxtools.tmf.core.tests.xmlstub";
    private static final Pattern PATTERN = Pattern.compile("Approximate uncompressed size: (.*)B");
    private static final String TRACE_CONTENT = "<trace><event timestamp=\"100\" name=\"event\"><field name=\"field\" value=\"1\" type=\"int\" /></event><event timestamp=\"200\" name=\"event1\"><field name=\"field\" value=\"2\" type=\"int\" /></event><event timestamp=\"201\" name=\"event\"><field name=\"field\" value=\"3\" type=\"int\" /></event><event timestamp=\"202\" name=\"event1\"><field name=\"field\" value=\"3\" type=\"int\" /></event><event timestamp=\"203\" name=\"event1\"><field name=\"field\" value=\"3\" type=\"int\" /></event><event timestamp=\"300\" name=\"event1\"><field name=\"field\" value=\"2\" type=\"int\" /></event><event timestamp=\"301\" name=\"event\"><field name=\"field\" value=\"3\" type=\"int\" /></event><event timestamp=\"302\" name=\"event1\"><field name=\"field\" value=\"3\" type=\"int\" /></event><event timestamp=\"333\" name=\"event1\"><field name=\"field\" value=\"3\" type=\"int\" /></event><event timestamp=\"500\" name=\"event1\"><field name=\"field\" value=\"2\" type=\"int\" /></event><event timestamp=\"501\" name=\"event\"><field name=\"field\" value=\"3\" type=\"int\" /></event><event timestamp=\"502\" name=\"event1\"><field name=\"field\" value=\"3\" type=\"int\" /></event><event timestamp=\"533\" name=\"event1\"><field name=\"field\" value=\"3\" type=\"int\" /></event></trace>";
    private static final Logger fLogger = Logger.getRootLogger();
    private static SWTWorkbenchBot fBot;

    @BeforeClass
    public static void init() {
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotUtils.initialize();
        Thread.currentThread().setName(SWT_BOT_THREAD_NAME);
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void afterClass() {
        fLogger.removeAllAppenders();
    }

    @Test
    public void test() throws IOException, ParseException {
        SWTBotTreeItem[] items;
        File traceFile = new File(TRACE_LOCATION);
        if (traceFile.exists()) {
            traceFile.delete();
        }
        traceFile.deleteOnExit();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter fw = new FileWriter(traceFile);){
            fw.write(TRACE_CONTENT);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        File exportPackage = new File(EXPORT_LOCATION);
        if (exportPackage.exists()) {
            exportPackage.delete();
        }
        Assert.assertFalse((String)("File: " + EXPORT_LOCATION + " already present, aborting test"), (boolean)exportPackage.exists());
        Assert.assertTrue((String)("Trace :" + traceFile.getAbsolutePath() + " does not exist, aborting test"), (boolean)traceFile.exists());
        SWTBotUtils.createProject(PROJECT_NAME);
        SWTBotUtils.openTrace(PROJECT_NAME, TRACE_LOCATION, XMLSTUB_ID);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)trace);
        Assert.assertEquals((String)"Incorrect opened trace!", (Object)traceFile.getAbsolutePath(), (Object)new File(trace.getPath()).getAbsolutePath());
        SWTBotView projectExplorerBot = fBot.viewByTitle(PROJECT_EXPLORER);
        Assert.assertNotNull((String)"Cannot find Project Explorer", (Object)projectExplorerBot);
        projectExplorerBot.show();
        SWTBotTreeItem treeItem = SWTBotUtils.selectTracesFolder(fBot, PROJECT_NAME);
        treeItem.contextMenu(EXPORT_TRACE_PACKAGE).click();
        SWTBotShell shell = fBot.shell(EXPORT_TRACE_PACKAGE_TITLE).activate();
        SWTBot shellBot = shell.bot();
        shellBot.button(DESELECT_ALL).click();
        SWTBotTreeItem[] sWTBotTreeItemArray = items = fBot.tree().getAllItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            Assert.assertEquals((Object)item.isChecked(), (Object)false);
            ++n2;
        }
        String labelText = fBot.label(1).getText();
        Matcher matcher = PATTERN.matcher(labelText);
        Assert.assertTrue((String)(String.valueOf(labelText) + " matches"), (boolean)matcher.matches());
        String sizeText = matcher.group(1);
        Assert.assertEquals((String)(String.valueOf(labelText) + " value"), (Object)"0", (Object)sizeText.trim());
        shellBot.button(SELECT_ALL).click();
        SWTBotTreeItem[] sWTBotTreeItemArray2 = items;
        int n3 = items.length;
        int n4 = 0;
        while (n4 < n3) {
            SWTBotTreeItem item = sWTBotTreeItemArray2[n4];
            Assert.assertEquals((Object)item.isChecked(), (Object)true);
            ++n4;
        }
        labelText = fBot.label(1).getText();
        matcher = PATTERN.matcher(labelText);
        Assert.assertTrue((String)(String.valueOf(labelText) + " matches"), (boolean)matcher.matches());
        sizeText = matcher.group(1);
        int size = ((Number)DataSizeWithUnitFormat.getInstance().parseObject(sizeText)).intValue();
        Assert.assertTrue((String)(String.valueOf(labelText) + " value"), (size > 0 ? 1 : 0) != 0);
        shellBot.radio(SAVE_IN_TAR_FORMAT).click();
        shellBot.radio(SAVE_IN_ZIP_FORMAT).click();
        shellBot.checkBox(COMPRESS_THE_CONTENTS_OF_THE_FILE).click();
        shellBot.checkBox(COMPRESS_THE_CONTENTS_OF_THE_FILE).click();
        shellBot.comboBox().setText(EXPORT_LOCATION);
        shellBot.button(FINISH).click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        fBot = new SWTWorkbenchBot();
        exportPackage = new File(EXPORT_LOCATION);
        Assert.assertTrue((String)"Exported package", (boolean)exportPackage.exists());
        treeItem = SWTBotUtils.selectTracesFolder(fBot, PROJECT_NAME);
        treeItem.contextMenu(IMPORT_TRACE_PACKAGE).click();
        shell = fBot.shell(IMPORT_TRACE_PACKAGE_TITLE).activate();
        shellBot = shell.bot();
        shellBot.comboBox().setText(EXPORT_LOCATION);
        shellBot.comboBox().typeText("\n");
        shellBot.button(SELECT_ALL).click();
        shellBot.button(FINISH).click();
        fBot.shell(CONFIRMATION).activate().bot().button(YES_TO_ALL).click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.openEditor(fBot, PROJECT_NAME, (IPath)new Path(traceFile.getName()));
        trace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)trace);
        Assert.assertEquals((String)"Test if import matches", (Object)traceFile.getName(), (Object)trace.getName());
        Assert.assertFalse((String)"Test if import files don't match", (boolean)traceFile.getAbsolutePath().equals(trace.getPath()));
        SWTBotUtils.deleteProject(PROJECT_NAME, fBot);
        WaitUtils.waitForJobs();
        traceFile.delete();
        exportPackage.delete();
    }
}

