/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.extensions.CommonContentExtensionSite;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.SafeDelegateCommonLabelProvider;
import org.eclipse.ui.internal.navigator.extensions.SafeDelegateTreeContentProvider;
import org.eclipse.ui.internal.navigator.extensions.SkeletonLabelProvider;
import org.eclipse.ui.internal.navigator.extensions.SkeletonTreeContentProvider;
import org.eclipse.ui.internal.navigator.extensions.StructuredViewerManager;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentExtension;

public class NavigatorContentExtension
implements IMementoAware,
INavigatorContentExtension {
    private static final NavigatorContentExtension[] NO_EXTENSIONS = new NavigatorContentExtension[0];
    private NavigatorContentService contentService;
    private NavigatorContentDescriptor descriptor;
    private SafeDelegateTreeContentProvider contentProvider;
    private ICommonLabelProvider labelProvider;
    private boolean labelProviderInitializationFailed = false;
    private boolean contentProviderInitializationFailed = false;
    private boolean isDisposed = false;
    private IMemento appliedMemento;
    private StructuredViewerManager viewerManager;
    private static final boolean TRIGGER_POINT = true;

    public NavigatorContentExtension(NavigatorContentDescriptor aDescriptor, NavigatorContentService aContentService, StructuredViewerManager aViewerManager) {
        Assert.isNotNull((Object)aDescriptor);
        this.descriptor = aDescriptor;
        this.contentService = aContentService;
        this.viewerManager = aViewerManager;
    }

    @Override
    public String getId() {
        return this.descriptor.getId();
    }

    @Override
    public INavigatorContentDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public ITreeContentProvider getContentProvider() {
        return this.internalGetContentProvider().getDelegateContentProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SafeDelegateTreeContentProvider internalGetContentProvider() {
        if (this.contentProvider != null || this.contentProviderInitializationFailed) {
            return this.contentProvider;
        }
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                @Override
                public void run() throws Exception {
                    if (NavigatorContentExtension.this.contentProvider == null) {
                        ITreeContentProvider treeContentProvider = NavigatorContentExtension.this.descriptor.createContentProvider();
                        if (treeContentProvider != null) {
                            NavigatorContentExtension.this.contentProvider = new SafeDelegateTreeContentProvider(treeContentProvider);
                            NavigatorContentExtension.this.contentProvider.init(new CommonContentExtensionSite(NavigatorContentExtension.this.getId(), NavigatorContentExtension.this.contentService, NavigatorContentExtension.this.appliedMemento));
                            NavigatorContentExtension.this.viewerManager.initialize((IStructuredContentProvider)NavigatorContentExtension.this.contentProvider);
                        } else {
                            NavigatorContentExtension.this.contentProvider = new SafeDelegateTreeContentProvider(SkeletonTreeContentProvider.INSTANCE);
                        }
                    }
                }

                @Override
                public void handleException(Throwable e) {
                    super.handleException(e);
                    NavigatorContentExtension.this.contentProviderInitializationFailed = true;
                }
            });
            if (this.contentProviderInitializationFailed) {
                this.contentProvider = new SafeDelegateTreeContentProvider(SkeletonTreeContentProvider.INSTANCE);
            }
        }
        return this.contentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonLabelProvider getLabelProvider() {
        if (this.labelProvider != null || this.labelProviderInitializationFailed) {
            return this.labelProvider;
        }
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                @Override
                public void run() throws Exception {
                    if (NavigatorContentExtension.this.labelProvider == null) {
                        ILabelProvider tempLabelProvider = NavigatorContentExtension.this.descriptor.createLabelProvider();
                        if (tempLabelProvider instanceof ICommonLabelProvider) {
                            NavigatorContentExtension.this.labelProvider = (ICommonLabelProvider)tempLabelProvider;
                            NavigatorContentExtension.this.labelProvider.init(new CommonContentExtensionSite(NavigatorContentExtension.this.getId(), NavigatorContentExtension.this.contentService, NavigatorContentExtension.this.appliedMemento));
                        } else {
                            NavigatorContentExtension.this.labelProvider = new SafeDelegateCommonLabelProvider(tempLabelProvider);
                        }
                        NavigatorContentExtension.this.labelProvider.addListener((ILabelProviderListener)NavigatorContentExtension.this.contentService.createCommonLabelProvider());
                    }
                }

                @Override
                public void handleException(Throwable e) {
                    super.handleException(e);
                    NavigatorContentExtension.this.labelProviderInitializationFailed = true;
                }
            });
            if (this.labelProviderInitializationFailed) {
                this.labelProvider = SkeletonLabelProvider.INSTANCE;
            }
        }
        return this.labelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            NavigatorContentExtension navigatorContentExtension = this;
            synchronized (navigatorContentExtension) {
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                    @Override
                    public void run() throws Exception {
                        if (NavigatorContentExtension.this.contentProvider != null) {
                            NavigatorContentExtension.this.contentProvider.dispose();
                        }
                    }
                });
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                    @Override
                    public void run() throws Exception {
                        if (NavigatorContentExtension.this.labelProvider != null) {
                            NavigatorContentExtension.this.labelProvider.removeListener((ILabelProviderListener)NavigatorContentExtension.this.contentService.createCommonLabelProvider());
                            NavigatorContentExtension.this.labelProvider.dispose();
                        }
                    }
                });
            }
        }
        finally {
            this.isDisposed = true;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean hasContentProviderInitializationFailed() {
        return this.contentProviderInitializationFailed;
    }

    public boolean hasLabelProviderInitializationFailed() {
        return this.labelProviderInitializationFailed;
    }

    public boolean hasLoadingFailed() {
        return this.contentProviderInitializationFailed;
    }

    @Override
    public boolean isLoaded() {
        return this.contentProvider != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreState(IMemento aMemento) {
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            this.appliedMemento = aMemento;
            this.applyMemento(this.contentProvider);
            this.applyMemento(this.labelProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveState(IMemento aMemento) {
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            if (this.contentProvider != null) {
                this.contentProvider.saveState(aMemento);
            }
            if (this.labelProvider != null) {
                this.labelProvider.saveState(aMemento);
            }
        }
    }

    private void applyMemento(IMementoAware target) {
        if (target != null) {
            target.restoreState(this.appliedMemento);
        }
    }

    protected final void complainDisposedIfNecessary() {
        if (this.isDisposed) {
            throw new IllegalStateException("INavigatorContentExtension " + this.descriptor.getId() + " is disposed!");
        }
    }

    @Override
    public IExtensionStateModel getStateModel() {
        return this.contentService.getExtensionStateService().getExtensionStateModel(this.getDescriptor());
    }

    public NavigatorContentExtension[] getOverridingExtensionsForTriggerPoint(Object anElement) {
        return this.getOverridingExtensions(anElement, true);
    }

    public NavigatorContentExtension[] getOverridingExtensionsForPossibleChild(Object anElement) {
        return this.getOverridingExtensions(anElement, false);
    }

    public NavigatorContentExtension[] getOverridingExtensions() {
        return this.getOverridingExtensions(null, false);
    }

    private NavigatorContentExtension[] getOverridingExtensions(Object anElement, boolean triggerPoint) {
        if (!this.descriptor.hasOverridingExtensions()) {
            return NO_EXTENSIONS;
        }
        LinkedHashSet<NavigatorContentExtension> overridingExtensions = new LinkedHashSet<NavigatorContentExtension>();
        for (NavigatorContentDescriptor overridingDescriptor : this.descriptor.getOverriddingExtensions()) {
            if (!this.contentService.isActive(overridingDescriptor.getId()) || !this.contentService.isVisible(overridingDescriptor.getId()) || anElement != null && !(triggerPoint ? overridingDescriptor.isTriggerPoint(anElement) : overridingDescriptor.isPossibleChild(anElement))) continue;
            overridingExtensions.add(this.contentService.getExtension(overridingDescriptor));
        }
        if (overridingExtensions.isEmpty()) {
            return NO_EXTENSIONS;
        }
        if (Policy.DEBUG_EXTENSION_SETUP) {
            System.out.println(this + " overriding: " + (triggerPoint ? "(trigger pt: " : "(poss child: ") + anElement + "): " + overridingExtensions);
        }
        return overridingExtensions.toArray(new NavigatorContentExtension[overridingExtensions.size()]);
    }

    public String toString() {
        return String.valueOf(this.descriptor.toString()) + " Instance";
    }
}

