/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.cpuusage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageEntryModel;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageAnalysis;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.analysis.os.linux.core.tid.TidAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage.CpuUsageDataProvider;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectedCpuQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CpuUsageDataProviderTest {
    private static final String CPU_USAGE_FILE = "testfiles/cpu_analysis.xml";
    private IKernelTrace fTrace;
    private CpuUsageDataProvider fDataProvider;

    private static void deleteSuppFiles(@NonNull ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    @Before
    public void setUp() {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(CPU_USAGE_FILE);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        CpuUsageDataProviderTest.deleteSuppFiles((ITmfTrace)trace);
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        IAnalysisModule module = null;
        Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, TidAnalysisModule.class).iterator();
        while (iterator.hasNext()) {
            IAnalysisModule mod;
            module = mod = (IAnalysisModule)iterator.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        module.waitForCompletion();
        module = TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelCpuUsageAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.cpuusage");
        Assert.assertNotNull((Object)module);
        module.schedule();
        module.waitForCompletion();
        this.fDataProvider = CpuUsageDataProvider.create((ITmfTrace)trace);
        Assert.assertNotNull((Object)this.fDataProvider);
        this.fTrace = trace;
    }

    @After
    public void tearDown() {
        IKernelTrace trace = this.fTrace;
        if (trace != null) {
            CpuUsageDataProviderTest.deleteSuppFiles((ITmfTrace)trace);
            trace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testTree() {
        CpuUsageDataProvider dataProvider = this.fDataProvider;
        NullProgressMonitor monitor = new NullProgressMonitor();
        SelectedCpuQueryFilter filter = new SelectedCpuQueryFilter(0L, 30L, 2, Collections.emptyList(), Collections.emptySet());
        @NonNull HashMap<@NonNull String, @NonNull Collection<Long>> parameters = new HashMap<String, Collection<Long>>();
        parameters.put("requested_times", CpuUsageDataProviderTest.getTimeRequested((TimeQueryFilter)filter));
        parameters.put("requested_items", Collections.emptyList());
        parameters.put("cpus", Collections.emptySet());
        @NonNull @NonNull TmfModelResponse response = dataProvider.fetchTree(parameters, (IProgressMonitor)monitor);
        Assert.assertTrue((response.getStatus() == ITmfResponse.Status.COMPLETED ? 1 : 0) != 0);
        @NonNull TmfTreeModel model = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)model);
        HashMap<Integer, Long> expected = new HashMap<Integer, Long>();
        expected.put(1, 5L);
        expected.put(2, 19L);
        expected.put(3, 11L);
        expected.put(4, 13L);
        expected.put(-2, 48L);
        CpuUsageDataProviderTest.compareModel(expected, model.getEntries());
        filter = new SelectedCpuQueryFilter(22L, 25L, 2, Collections.emptyList(), Collections.emptySet());
        parameters.put("requested_times", CpuUsageDataProviderTest.getTimeRequested((TimeQueryFilter)filter));
        response = dataProvider.fetchTree(parameters, (IProgressMonitor)monitor);
        Assert.assertTrue((response.getStatus() == ITmfResponse.Status.COMPLETED ? 1 : 0) != 0);
        model = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)model);
        expected.clear();
        expected.put(3, 3L);
        expected.put(4, 3L);
        expected.put(-2, 6L);
        CpuUsageDataProviderTest.compareModel(expected, model.getEntries());
        filter = new SelectedCpuQueryFilter(1L, 4L, 2, Collections.emptyList(), Collections.emptySet());
        parameters.put("requested_times", CpuUsageDataProviderTest.getTimeRequested((TimeQueryFilter)filter));
        response = dataProvider.fetchTree(parameters, (IProgressMonitor)monitor);
        Assert.assertTrue((response.getStatus() == ITmfResponse.Status.COMPLETED ? 1 : 0) != 0);
        model = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)model);
        expected.clear();
        expected.put(2, 3L);
        expected.put(3, 1L);
        expected.put(4, 2L);
        expected.put(-2, 6L);
        CpuUsageDataProviderTest.compareModel(expected, model.getEntries());
        filter = new SelectedCpuQueryFilter(4L, 13L, 2, Collections.emptyList(), Collections.emptySet());
        parameters.put("requested_times", CpuUsageDataProviderTest.getTimeRequested((TimeQueryFilter)filter));
        response = dataProvider.fetchTree(parameters, (IProgressMonitor)monitor);
        Assert.assertTrue((response.getStatus() == ITmfResponse.Status.COMPLETED ? 1 : 0) != 0);
        model = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)model);
        expected.clear();
        expected.put(2, 9L);
        expected.put(3, 5L);
        expected.put(4, 4L);
        expected.put(-2, 18L);
        CpuUsageDataProviderTest.compareModel(expected, model.getEntries());
    }

    private static void compareModel(Map<Integer, Long> expected, List<CpuUsageEntryModel> model) {
        Assert.assertEquals((String)"Size of model entries", (long)expected.size(), (long)model.size());
        HashMap actual = new HashMap();
        model.forEach(entry -> {
            Long l = actual.put(entry.getTid(), entry.getTime());
        });
        Assert.assertEquals((String)"model entries", expected, actual);
    }

    private static @NonNull List<Long> getTimeRequested(TimeQueryFilter filter) {
        ArrayList<Long> times = new ArrayList<Long>();
        long[] lArray = filter.getTimesRequested();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long time = lArray[n2];
            times.add(time);
            ++n2;
        }
        return times;
    }
}

