/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.inputoutput;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.inputoutput.AbstractTestInputOutput;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.inputoutput.IoTestCase;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.inputoutput.IoTestFactory;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.DisksIODataProvider;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InputOutputDataProviderTest
extends AbstractTestInputOutput {
    private static final IProgressMonitor PROGRESS_MONITOR = new NullProgressMonitor();
    private final IoTestCase fTestCase;

    public InputOutputDataProviderTest(IoTestCase test) {
        this.fTestCase = test;
    }

    @After
    public void tearDown() {
        super.deleteTrace();
    }

    @Override
    protected @NonNull InputOutputAnalysisModule setUp(String fileName) {
        InputOutputAnalysisModule module = super.setUp(fileName);
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        return module;
    }

    private @NonNull DisksIODataProvider getProvider() {
        InputOutputAnalysisModule module = this.setUp(this.fTestCase.getTraceFileName());
        ITmfTrace trace = module.getTrace();
        Assert.assertNotNull((Object)trace);
        DisksIODataProvider provider = DisksIODataProvider.create((ITmfTrace)trace);
        Assert.assertNotNull((Object)provider);
        return provider;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList(new Object[][]{{IoTestFactory.SIMPLE_REQUESTS}});
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDiskActivity() {
        DisksIODataProvider provider = this.getProvider();
        Collection<@NonNull IoTestCase.DiskActivity> diskActivity = this.fTestCase.getDiskActivity();
        for (IoTestCase.DiskActivity test : diskActivity) {
            Map<@NonNull String, @NonNull Object> parameters = test.getTimeQuery();
            @NonNull @NonNull TmfModelResponse response = provider.fetchTree(parameters, PROGRESS_MONITOR);
            Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
            @NonNull TmfTreeModel model = (TmfTreeModel)response.getModel();
            Assert.assertNotNull((Object)model);
            parameters = test.getTimeQueryForModel((TmfTreeModel<TmfTreeDataModel>)model);
            @NonNull TmfModelResponse yResponse = provider.fetchXY(parameters, PROGRESS_MONITOR);
            Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)yResponse.getStatus());
            ITmfXyModel yModel = (ITmfXyModel)yResponse.getModel();
            Assert.assertNotNull((Object)yModel);
            @NonNull @NonNull Map data = yModel.getData();
            Assert.assertEquals((long)1L, (long)data.size());
            ISeriesModel ySeries = (ISeriesModel)data.values().iterator().next();
            double[] expected = test.getActivity();
            double[] actual = ySeries.getData();
            int i = 0;
            while (i < expected.length) {
                Assert.assertTrue((String)String.format("No actual value at position %d for %s", i, test), (actual.length > i ? 1 : 0) != 0);
                Assert.assertEquals((String)String.format("Value at position %d for %s", i, test), (double)expected[i], (double)actual[i], (double)0.001);
                ++i;
            }
            Assert.assertEquals((String)String.format("More values than expected for %s", test), (long)expected.length, (long)actual.length);
        }
    }
}

