/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests;

import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.internal.statesystem.core.StateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class StateSystemTest {
    @Rule
    public TestRule globalTimeout = new Timeout(1L, TimeUnit.MINUTES);
    private ITmfStateSystemBuilder fSs;

    @Before
    public void setup() {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createNullBackend((String)"Test");
        this.fSs = new StateSystem(backend);
    }

    @Test
    public void testWaitUntilBuilt() {
        ITmfStateSystemBuilder ss = this.fSs;
        Assert.assertNotNull((Object)ss);
        long timeout = 500L;
        long begin = System.currentTimeMillis();
        Assert.assertFalse((boolean)ss.waitUntilBuilt(timeout));
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - begin >= timeout ? 1 : 0) != 0);
        Assert.assertFalse((boolean)ss.waitUntilBuilt(0L));
        ss.closeHistory(timeout);
        Assert.assertTrue((boolean)ss.waitUntilBuilt(timeout));
        Assert.assertTrue((boolean)ss.waitUntilBuilt(0L));
    }

    @Test
    public void testSetAndQueryOngoing() {
        ITmfStateSystemBuilder ss = this.fSs;
        Assert.assertNotNull((Object)ss);
        long time = 10L;
        int quark = ss.getQuarkAbsoluteAndAdd(new String[]{"Test"});
        long val = 10L;
        ss.modifyAttribute(time, (Object)val, quark);
        ITmfStateValue ongoingState = ss.queryOngoingState(quark);
        Assert.assertTrue((ongoingState.getType() == ITmfStateValue.Type.LONG ? 1 : 0) != 0);
        Assert.assertEquals((long)val, (long)ongoingState.unboxLong());
        Object ongoing = ss.queryOngoing(quark);
        Assert.assertTrue((boolean)(ongoing instanceof Long));
        Assert.assertEquals((Object)val, (Object)ongoing);
        val = 12L;
        ss.modifyAttribute(time + 1L, (Object)val, quark);
        ongoingState = ss.queryOngoingState(quark);
        Assert.assertTrue((ongoingState.getType() == ITmfStateValue.Type.LONG ? 1 : 0) != 0);
        Assert.assertEquals((long)val, (long)ongoingState.unboxLong());
        ongoing = ss.queryOngoing(quark);
        Assert.assertTrue((boolean)(ongoing instanceof Long));
        Assert.assertEquals((Object)val, (Object)ongoing);
        val = 14L;
        ss.updateOngoingState(TmfStateValue.newValue((Object)val), quark);
        ongoingState = ss.queryOngoingState(quark);
        Assert.assertTrue((ongoingState.getType() == ITmfStateValue.Type.LONG ? 1 : 0) != 0);
        Assert.assertEquals((long)val, (long)ongoingState.unboxLong());
        ongoing = ss.queryOngoing(quark);
        Assert.assertTrue((boolean)(ongoing instanceof Long));
        Assert.assertEquals((Object)val, (Object)ongoing);
        val = 16L;
        ss.updateOngoingState((Object)val, quark);
        ongoingState = ss.queryOngoingState(quark);
        Assert.assertTrue((ongoingState.getType() == ITmfStateValue.Type.LONG ? 1 : 0) != 0);
        Assert.assertEquals((long)val, (long)ongoingState.unboxLong());
        ongoing = ss.queryOngoing(quark);
        Assert.assertTrue((boolean)(ongoing instanceof Long));
        Assert.assertEquals((Object)val, (Object)ongoing);
    }
}

