/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.histogram;

import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramBucket;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramDataModel;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramScaledData;
import org.eclipse.tracecompass.tmf.ui.views.histogram.IHistogramModelListener;
import org.junit.Assert;
import org.junit.Test;

public class HistogramDataModelTest {
    private static final double DELTA = 1.0E-15;
    private static final HistogramBucket _0 = new HistogramBucket(new int[1]);
    private static final HistogramBucket _1 = new HistogramBucket(new int[]{1});
    private static final HistogramBucket _2 = new HistogramBucket(new int[]{2});
    private static final HistogramBucket _3 = new HistogramBucket(new int[]{3});
    private static final HistogramBucket _4 = new HistogramBucket(new int[]{4});
    private static final HistogramBucket _17 = new HistogramBucket(new int[]{17});
    private static final HistogramBucket _20 = new HistogramBucket(new int[]{20});
    private static final HistogramBucket _21 = new HistogramBucket(new int[]{21});
    private static final HistogramBucket _24 = new HistogramBucket(new int[]{24});
    private static final HistogramBucket _100 = new HistogramBucket(new int[]{100});
    private static final HistogramBucket _101 = new HistogramBucket(new int[]{101});

    @Test
    public void testHistogramDataModel() {
        HistogramDataModel model = new HistogramDataModel();
        HistogramDataModelTest.testModelConsistency(model, 16000, 0, 1L, 0L, 0L, 0L, 16000L);
    }

    @Test
    public void testHistogramDataModelCopyConstructor() {
        HistogramDataModel model = new HistogramDataModel();
        HistogramDataModel copy = new HistogramDataModel(model);
        HistogramDataModelTest.testModelConsistency(copy, 16000, 0, 1L, 0L, 0L, 0L, 16000L);
    }

    @Test
    public void testHistogramDataModelInt() {
        int nbBuckets = 5000;
        HistogramDataModel model = new HistogramDataModel(5000);
        HistogramDataModelTest.testModelConsistency(model, 5000, 0, 1L, 0L, 0L, 0L, 5000L);
    }

    @Test
    public void testClear() {
        int nbBuckets = 100;
        HistogramDataModel model = new HistogramDataModel(100);
        model.countEvent(0L, -1L, null);
        HistogramDataModelTest.testModelConsistency(model, 100, 0, 1L, 0L, 0L, 0L, 100L);
    }

    @Test
    public void testCountEvent_0() {
        int nbBuckets = 100;
        HistogramDataModel model = new HistogramDataModel(100);
        model.countEvent(0L, -1L, null);
        HistogramDataModelTest.testModelConsistency(model, 100, 0, 1L, 0L, 0L, 0L, 100L);
    }

    @Test
    public void testCountEvent_1() {
        int nbBuckets = 100;
        int maxHeight = 10;
        HistogramDataModel model = new HistogramDataModel(100);
        HistogramScaledData result = model.scaleTo(100, 10, 1);
        int i = 0;
        while (i < result.fData.length) {
            Assert.assertEquals((Object)_0, (Object)result.fData[i]);
            ++i;
        }
        HistogramDataModelTest.testModelConsistency(model, 100, 0, 1L, 0L, 0L, 0L, 100L);
    }

    @Test
    public void testCountEvent_2() {
        int nbBuckets = 100;
        int maxHeight = 10;
        HistogramDataModel model = new HistogramDataModel(100);
        model.countEvent(0L, 1L, null);
        HistogramScaledData result = model.scaleTo(100, 10, 1);
        int i = 0;
        while (i < result.fData.length - 1) {
            Assert.assertEquals((Object)_1, (Object)result.fData[i]);
            ++i;
        }
        Assert.assertEquals((Object)_0, (Object)result.fData[result.fData.length - 1]);
        HistogramDataModelTest.testModelConsistency(model, 100, 1, 1L, 1L, 1L, 1L, 101L);
    }

    @Test
    public void testCountEvent_3() {
        int nbBuckets = 100;
        int maxHeight = 10;
        HistogramDataModel model = new HistogramDataModel(100);
        HistogramDataModelTest.countEventsInModel(100, model);
        HistogramScaledData result = model.scaleTo(100, 10, 1);
        HistogramBucket[] histogramBucketArray = result.fData;
        int n = result.fData.length;
        int n2 = 0;
        while (n2 < n) {
            HistogramBucket data = histogramBucketArray[n2];
            if (data.getNbEvents() != 1 && data.getNbEvents() != 2) {
                Assert.fail();
            }
            ++n2;
        }
        HistogramDataModelTest.testModelConsistency(model, 100, 100, 1L, 0L, 0L, 99L, 100L);
    }

    @Test
    public void testCountEvent_4() {
        int nbBuckets = 100;
        int maxHeight = 10;
        HistogramDataModel model = new HistogramDataModel(100);
        int i = 0;
        while (i < 100) {
            model.countEvent((long)i, (long)i, null);
            model.countEvent((long)(i + 1), (long)i, null);
            ++i;
        }
        HistogramScaledData result = model.scaleTo(100, 10, 1);
        HistogramBucket[] histogramBucketArray = result.fData;
        int n = result.fData.length;
        int n2 = 0;
        while (n2 < n) {
            HistogramBucket data = histogramBucketArray[n2];
            if (data.getNbEvents() != 4 && data.getNbEvents() != 2) {
                Assert.fail();
            }
            ++n2;
        }
        HistogramDataModelTest.testModelConsistency(model, 100, 200, 1L, 0L, 0L, 99L, 100L);
    }

    @Test
    public void testCountEvent_5() {
        int nbBuckets = 100;
        int startTime = 25;
        int maxHeight = 10;
        HistogramDataModel model = new HistogramDataModel(100);
        int i = 25;
        while (i < 125) {
            model.countEvent((long)i, (long)i, null);
            ++i;
        }
        HistogramScaledData result = model.scaleTo(100, 10, 1);
        HistogramBucket[] histogramBucketArray = result.fData;
        int n = result.fData.length;
        int n2 = 0;
        while (n2 < n) {
            HistogramBucket data = histogramBucketArray[n2];
            if (data.getNbEvents() != 1 && data.getNbEvents() != 2) {
                Assert.fail();
            }
            ++n2;
        }
        HistogramDataModelTest.testModelConsistency(model, 100, 100, 1L, 25L, 25L, 124L, 125L);
    }

    @Test
    public void testCountEvent_6() {
        int nbBuckets = 2;
        long interval = 0x100000000L;
        int maxHeight = 10;
        HistogramDataModel model = new HistogramDataModel(2);
        model.countEvent(0L, 0x100000000L, null);
        model.countEvent(1L, 0L, null);
        HistogramScaledData result = model.scaleTo(2, 10, 1);
        HistogramDataModelTest.assertArrayEqualsInt(1, result.fData);
        HistogramDataModelTest.testModelConsistency(model, 2, 2, 0x100000000L, 0L, 0L, 0x100000000L, 0x200000000L);
    }

    @Test
    public void testScaleTo_0() {
        HistogramDataModel model = new HistogramDataModel(10);
        try {
            model.scaleTo(10, 0, 1);
        }
        catch (AssertionError e1) {
            try {
                model.scaleTo(0, 10, 1);
            }
            catch (AssertionError e2) {
                try {
                    model.scaleTo(0, 0, 1);
                }
                catch (AssertionError e3) {
                    return;
                }
            }
        }
        Assert.fail((String)"Uncaught assertion error");
    }

    @Test
    public void testScaleTo_1() {
        int nbBuckets = 10;
        int maxHeight = 10;
        int nbEvents = 5;
        Object[] expectedResult = new HistogramBucket[]{_1, _1, _1, _1, _1, _1, _1, _1, _1, _1};
        HistogramDataModel model = new HistogramDataModel(10);
        HistogramDataModelTest.countEventsInModel(5, model);
        HistogramScaledData result = model.scaleTo(10, 10, 1);
        Assert.assertArrayEquals((Object[])expectedResult, (Object[])result.fData);
        HistogramDataModelTest.testModelConsistency(model, 10, 5, 1L, 0L, 0L, 4L, 10L);
    }

    @Test
    public void testScaleTo_2() {
        int nbBuckets = 10;
        int maxHeight = 10;
        int nbEvents = 10;
        Object[] expectedResult = new HistogramBucket[]{_1, _1, _1, _1, _1, _1, _1, _1, _1, _1};
        HistogramDataModel model = new HistogramDataModel(10);
        HistogramDataModelTest.countEventsInModel(10, model);
        HistogramScaledData result = model.scaleTo(10, 10, 1);
        Assert.assertArrayEquals((Object[])expectedResult, (Object[])result.fData);
        HistogramDataModelTest.testModelConsistency(model, 10, 10, 1L, 0L, 0L, 9L, 10L);
    }

    @Test
    public void testScaleTo_3() {
        int nbBuckets = 10;
        int maxHeight = 10;
        int nbEvents = 20;
        Object[] expectedResult = new HistogramBucket[]{_2, _2, _2, _2, _2, _2, _2, _2, _2, _2};
        HistogramDataModel model = new HistogramDataModel(10);
        HistogramDataModelTest.countEventsInModel(20, model);
        HistogramScaledData result = model.scaleTo(10, 10, 1);
        Assert.assertArrayEquals((Object[])expectedResult, (Object[])result.fData);
        HistogramDataModelTest.testModelConsistency(model, 10, 20, 2L, 0L, 0L, 19L, 20L);
    }

    @Test
    public void testScaleTo_4() {
        int nbBuckets = 10;
        int maxHeight = 10;
        int nbEvents = 30;
        Object[] expectedResult = new HistogramBucket[]{_4, _4, _4, _4, _4, _4, _4, _4, _4, _2};
        HistogramDataModel model = new HistogramDataModel(10);
        HistogramDataModelTest.countEventsInModel(30, model);
        HistogramScaledData result = model.scaleTo(10, 10, 1);
        Assert.assertArrayEquals((Object[])expectedResult, (Object[])result.fData);
        HistogramDataModelTest.testModelConsistency(model, 10, 30, 4L, 0L, 0L, 29L, 40L);
    }

    @Test
    public void testScaleTo_5() {
        int nbBuckets = 100;
        int maxHeight = 20;
        int nbEvents = 200;
        Object[] expectedResult = new HistogramBucket[]{_20, _20, _20, _20, _20, _20, _20, _20, _20, _20};
        HistogramDataModel model = new HistogramDataModel(100);
        HistogramDataModelTest.countEventsInModel(200, model);
        HistogramScaledData result = model.scaleTo(10, 20, 1);
        Assert.assertArrayEquals((Object[])expectedResult, (Object[])result.fData);
        HistogramDataModelTest.testModelConsistency(model, 100, 200, 2L, 0L, 0L, 199L, 200L);
    }

    @Test
    public void testScaleTo_6() {
        int nbBuckets = 100;
        int maxHeight = 24;
        int nbEvents = 201;
        Object[] expectedResult = new HistogramBucket[]{_20, _20, _20, _20, _20, _20, _20, _20, _20, _21};
        HistogramDataModel model = new HistogramDataModel(100);
        HistogramDataModelTest.countEventsInModel(201, model);
        HistogramScaledData result = model.scaleTo(10, 24, 1);
        Assert.assertArrayEquals((Object[])expectedResult, (Object[])result.fData);
        HistogramDataModelTest.testModelConsistency(model, 100, 201, 4L, 0L, 0L, 200L, 400L);
    }

    @Test
    public void testScaleTo_7() {
        int nbBuckets = 100;
        int maxHeight = 24;
        int width = 10;
        int barWidth = 4;
        int nbEvents = 201;
        Object[] expectedResult = new HistogramBucket[]{_100, _101};
        HistogramDataModel model = new HistogramDataModel(100);
        HistogramDataModelTest.countEventsInModel(201, model);
        HistogramScaledData result = model.scaleTo(10, 24, 4);
        Assert.assertEquals((double)100.0, (double)result.fBucketDuration, (double)0.5);
        Assert.assertEquals((long)0L, (long)result.fSelectionBeginBucket);
        Assert.assertEquals((long)0L, (long)result.fSelectionEndBucket);
        Assert.assertEquals((long)0L, (long)result.fFirstBucketTime);
        Assert.assertEquals((long)0L, (long)result.fFirstEventTime);
        Assert.assertEquals((long)1L, (long)result.fLastBucket);
        Assert.assertEquals((long)101L, (long)result.fMaxValue);
        Assert.assertEquals((double)0.2376237623762376, (double)result.fScalingFactor, (double)1.0E-15);
        Assert.assertEquals((long)24L, (long)result.fHeight);
        Assert.assertEquals((long)10L, (long)result.fWidth);
        Assert.assertEquals((long)4L, (long)result.fBarWidth);
        Assert.assertArrayEquals((Object[])expectedResult, (Object[])result.fData);
        HistogramDataModelTest.testModelConsistency(model, 100, 201, 4L, 0L, 0L, 200L, 400L);
    }

    @Test
    public void testScaleToReverse_1() {
        int nbBuckets = 100;
        int maxHeight = 24;
        int width = 10;
        boolean barWidth = true;
        int nbEvents = 201;
        Object[] expectedResult = new HistogramBucket[]{_17, _20, _20, _20, _20, _20, _20, _20, _20, _24};
        HistogramDataModel model = new HistogramDataModel(100);
        HistogramDataModelTest.countInvertedEvents(201, model);
        HistogramScaledData result = model.scaleTo(10, 24, 1);
        Assert.assertEquals((double)20.0, (double)result.fBucketDuration, (double)0.5);
        Assert.assertEquals((long)0L, (long)result.fSelectionBeginBucket);
        Assert.assertEquals((long)0L, (long)result.fSelectionEndBucket);
        Assert.assertEquals((long)-3L, (long)result.fFirstBucketTime);
        Assert.assertEquals((long)0L, (long)result.fFirstEventTime);
        Assert.assertEquals((long)9L, (long)result.fLastBucket);
        Assert.assertEquals((long)24L, (long)result.fMaxValue);
        Assert.assertEquals((double)1.0, (double)result.fScalingFactor, (double)1.0E-15);
        Assert.assertEquals((long)24L, (long)result.fHeight);
        Assert.assertEquals((long)10L, (long)result.fWidth);
        Assert.assertEquals((long)1L, (long)result.fBarWidth);
        Assert.assertArrayEquals((Object[])expectedResult, (Object[])result.fData);
        HistogramDataModelTest.testModelConsistency(model, 100, 201, 4L, -3L, 0L, 200L, 397L);
    }

    private static void countInvertedEvents(int nbEvents, HistogramDataModel model) {
        int i = nbEvents - 1;
        while (i >= 0) {
            model.countEvent((long)i, (long)i, null);
            --i;
        }
    }

    @Test
    public void testScaleToReverse_2() {
        int nbBuckets = 100;
        int maxHeight = 24;
        int width = 10;
        boolean barWidth = true;
        int nbEvents = 200;
        HistogramDataModel model = new HistogramDataModel(100);
        HistogramDataModelTest.countEventsInModel(200, model);
        HistogramScaledData result = model.scaleTo(10, 24, 1);
        model.clear();
        HistogramDataModelTest.countInvertedEvents(200, model);
        HistogramScaledData revResult = model.scaleTo(10, 24, 1);
        HistogramDataModelTest.testModelConsistency(model, 100, 200, 2L, 0L, 0L, 199L, 200L);
        Assert.assertEquals((double)result.fBucketDuration, (double)revResult.fBucketDuration, (double)0.0);
        Assert.assertEquals((long)result.fSelectionBeginBucket, (long)revResult.fSelectionBeginBucket);
        Assert.assertEquals((long)result.fSelectionEndBucket, (long)revResult.fSelectionEndBucket);
        Assert.assertEquals((long)result.fFirstBucketTime, (long)revResult.fFirstBucketTime);
        Assert.assertEquals((long)result.fMaxValue, (long)revResult.fMaxValue);
        Assert.assertEquals((double)result.fScalingFactor, (double)revResult.fScalingFactor, (double)1.0E-15);
        Assert.assertEquals((long)result.fLastBucket, (long)revResult.fLastBucket);
        Assert.assertEquals((long)result.getBucketEndTime(0), (long)revResult.getBucketEndTime(0));
        Assert.assertEquals((long)result.getBucketStartTime(0), (long)revResult.getBucketStartTime(0));
        Assert.assertArrayEquals((Object[])revResult.fData, (Object[])result.fData);
    }

    @Test
    public void testModelListener() {
        int nbBuckets = 2000;
        int nbEvents = 20256;
        final int[] count = new int[]{0};
        IHistogramModelListener listener = new IHistogramModelListener(){

            public void modelUpdated() {
                count[0] = count[0] + 1;
            }
        };
        HistogramDataModel model = new HistogramDataModel(2000);
        model.addHistogramListener(listener);
        HistogramDataModelTest.countEventsInModel(20256, model, 1);
        Assert.assertEquals((long)1L, (long)count[0]);
        model.complete();
        Assert.assertEquals((long)2L, (long)count[0]);
        model.clear();
        Assert.assertEquals((long)3L, (long)count[0]);
        count[0] = 0;
        model.removeHistogramListener(listener);
        HistogramDataModelTest.countEventsInModel(20256, model);
        model.complete();
        Assert.assertEquals((long)0L, (long)count[0]);
    }

    @Test
    public void testLostEventsScaleTo_0() {
        int nbBuckets = 10;
        int maxHeight = 10;
        int nbEvents = 30;
        int nbLostEvents_0 = 4;
        int nbLostEvents_1 = 9;
        int nbCombinedEvents = 32;
        Object[] expectedResult = new HistogramBucket[]{_4, _4, _4, _4, _4, _4, _4, _4, _4, _2};
        int[] nArray = new int[10];
        nArray[1] = 2;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[5] = 3;
        nArray[6] = 3;
        nArray[7] = 3;
        nArray[8] = 3;
        int[] expectedLostEventsResult = nArray;
        HistogramDataModel model = new HistogramDataModel(10);
        HistogramDataModelTest.countEventsInModel(30, model);
        TmfTimeRange timeRange_0 = new TmfTimeRange(TmfTimestamp.fromNanos((long)5L), TmfTimestamp.fromNanos((long)10L));
        model.countLostEvent(timeRange_0, 4L, false);
        TmfTimeRange timeRange_1 = new TmfTimeRange(TmfTimestamp.fromNanos((long)18L), TmfTimestamp.fromNanos((long)27L));
        model.countLostEvent(timeRange_1, 9L, false);
        HistogramScaledData result = model.scaleTo(10, 10, 1);
        Assert.assertArrayEquals((Object[])expectedResult, (Object[])result.fData);
        Assert.assertArrayEquals((int[])expectedLostEventsResult, (int[])result.fLostEventsData);
        HistogramDataModelTest.testModelConsistency(model, 10, 32, 4L, 0L, 0L, 29L, 40L);
        Assert.assertEquals((long)7L, (long)result.fMaxCombinedValue);
    }

    @Test
    public void testLostEventsScaleTo_1() {
        int nbBuckets = 10;
        int maxHeight = 10;
        int nbEvents = 30;
        int nbLostEvents_0 = 4;
        int nbLostEvents_1 = 9;
        int nbCombinedEvents = 32;
        int[] nArray = new int[10];
        nArray[1] = 2;
        nArray[2] = 5;
        nArray[3] = 5;
        nArray[4] = 3;
        nArray[5] = 3;
        nArray[6] = 3;
        int[] expectedLostEventsResult = nArray;
        HistogramDataModel model = new HistogramDataModel(10);
        HistogramDataModelTest.countEventsInModel(30, model);
        TmfTimeRange timeRange_0 = new TmfTimeRange(TmfTimestamp.fromNanos((long)5L), TmfTimestamp.fromNanos((long)10L));
        model.countLostEvent(timeRange_0, 4L, false);
        TmfTimeRange timeRange_1 = new TmfTimeRange(TmfTimestamp.fromNanos((long)11L), TmfTimestamp.fromNanos((long)18L));
        model.countLostEvent(timeRange_1, 9L, false);
        HistogramScaledData result = model.scaleTo(10, 10, 1);
        Assert.assertArrayEquals((int[])expectedLostEventsResult, (int[])result.fLostEventsData);
        HistogramDataModelTest.testModelConsistency(model, 10, 32, 4L, 0L, 0L, 29L, 40L);
        Assert.assertEquals((long)9L, (long)result.fMaxCombinedValue);
    }

    @Test
    public void testLostEventsScaleTo_2() {
        int nbBuckets = 10;
        int maxHeight = 10;
        int nbEvents = 30;
        int nbLostEvents_0 = 5;
        int nbLostEvents_1 = 15;
        int nbLostEvents_2 = 2;
        int nbCombinedEvents = 33;
        int[] nArray = new int[10];
        nArray[2] = 3;
        nArray[3] = 3;
        nArray[4] = 3;
        nArray[5] = 6;
        nArray[6] = 6;
        nArray[7] = 5;
        nArray[8] = 3;
        nArray[9] = 2;
        int[] expectedLostEventsResult = nArray;
        HistogramDataModel model = new HistogramDataModel(10);
        HistogramDataModelTest.countEventsInModel(30, model);
        TmfTimeRange timeRange_0 = new TmfTimeRange(TmfTimestamp.fromNanos((long)18L), TmfTimestamp.fromNanos((long)22L));
        model.countLostEvent(timeRange_0, 5L, false);
        TmfTimeRange timeRange_2 = new TmfTimeRange(TmfTimestamp.fromNanos((long)28L), TmfTimestamp.fromNanos((long)29L));
        model.countLostEvent(timeRange_2, 2L, false);
        TmfTimeRange timeRange_1 = new TmfTimeRange(TmfTimestamp.fromNanos((long)11L), TmfTimestamp.fromNanos((long)26L));
        model.countLostEvent(timeRange_1, 15L, false);
        HistogramScaledData result = model.scaleTo(10, 10, 1);
        Assert.assertArrayEquals((int[])expectedLostEventsResult, (int[])result.fLostEventsData);
        HistogramDataModelTest.testModelConsistency(model, 10, 33, 4L, 0L, 0L, 29L, 40L);
        Assert.assertEquals((long)10L, (long)result.fMaxCombinedValue);
    }

    @Test
    public void testLostEventsScaleTo_3() {
        int nbBuckets = 10;
        int maxHeight = 10;
        int nbEvents = 30;
        int nbLostEvents_0 = 23;
        int nbCombinedEvents = 31;
        int[] nArray = new int[10];
        nArray[2] = 5;
        nArray[3] = 5;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 5;
        nArray[7] = 4;
        nArray[8] = 5;
        int[] expectedLostEventsResult = nArray;
        HistogramDataModel model = new HistogramDataModel(10);
        HistogramDataModelTest.countEventsInModel(30, model);
        TmfTimeRange timeRange_0 = new TmfTimeRange(TmfTimestamp.fromNanos((long)11L), TmfTimestamp.fromNanos((long)26L));
        model.countLostEvent(timeRange_0, 23L, false);
        HistogramScaledData result = model.scaleTo(10, 10, 1);
        Assert.assertArrayEquals((int[])expectedLostEventsResult, (int[])result.fLostEventsData);
        HistogramDataModelTest.testModelConsistency(model, 10, 31, 4L, 0L, 0L, 29L, 40L);
        Assert.assertEquals((long)9L, (long)result.fMaxCombinedValue);
    }

    @Test
    public void testLostEventsScaleTo_4() {
        int nbBuckets = 10;
        int maxHeight = 10;
        int nbEvents = 30;
        int nbLostEvents_0 = 4;
        int nbLostEvents_1 = 9;
        int nbCombinedEvents = 32;
        Object[] expectedResult = new HistogramBucket[]{_3, _4, _4, _4, _4, _4, _4, _4, _4, _3};
        int[] nArray = new int[10];
        nArray[0] = 3;
        nArray[1] = 1;
        nArray[4] = 3;
        nArray[5] = 3;
        nArray[6] = 3;
        nArray[7] = 3;
        int[] expectedLostEventsResult = nArray;
        HistogramDataModel model = new HistogramDataModel(10);
        TmfTimeRange timeRange_0 = new TmfTimeRange(TmfTimestamp.fromNanos((long)5L), TmfTimestamp.fromNanos((long)10L));
        model.countLostEvent(timeRange_0, 4L, false);
        int firstNonLostEventTime = 6;
        HistogramDataModelTest.countEventsInModel(30, model, 0, firstNonLostEventTime);
        TmfTimeRange timeRange_1 = new TmfTimeRange(TmfTimestamp.fromNanos((long)18L), TmfTimestamp.fromNanos((long)27L));
        model.countLostEvent(timeRange_1, 9L, false);
        HistogramScaledData result = model.scaleTo(10, 10, 1);
        HistogramDataModelTest.testModelConsistency(model, 10, 32, 4L, 5L, 5L, 30 + firstNonLostEventTime - 1, 40 + firstNonLostEventTime - 1);
        Assert.assertArrayEquals((Object[])expectedResult, (Object[])result.fData);
        Assert.assertArrayEquals((int[])expectedLostEventsResult, (int[])result.fLostEventsData);
        Assert.assertEquals((long)7L, (long)result.fMaxCombinedValue);
    }

    private static void countEventsInModel(int nbEvents, HistogramDataModel model) {
        HistogramDataModelTest.countEventsInModel(nbEvents, model, 0);
    }

    private static void countEventsInModel(int nbEvents, HistogramDataModel model, int offset) {
        HistogramDataModelTest.countEventsInModel(nbEvents, model, offset, 0);
    }

    private static void countEventsInModel(int nbEvents, HistogramDataModel model, int offset, int startTime) {
        int i = startTime;
        while (i < nbEvents + startTime) {
            model.countEvent((long)(i + offset), (long)i, null);
            ++i;
        }
    }

    private static void testModelConsistency(HistogramDataModel model, int numberOfBuckets, int nbEvents, long bucketduration, long firstBucketTime, long startTime, long endTime, long timeLimit) {
        Assert.assertEquals((long)numberOfBuckets, (long)model.getNbBuckets());
        Assert.assertEquals((long)nbEvents, (long)model.getNbEvents());
        Assert.assertEquals((long)bucketduration, (long)model.getBucketDuration());
        Assert.assertEquals((long)firstBucketTime, (long)model.getFirstBucketTime());
        Assert.assertEquals((long)startTime, (long)model.getStartTime());
        Assert.assertEquals((long)endTime, (long)model.getEndTime());
        Assert.assertEquals((long)timeLimit, (long)model.getTimeLimit());
    }

    private static void assertArrayEqualsInt(int val, HistogramBucket[] result) {
        HistogramDataModelTest.assertArrayEqualsInt(val, result, 0);
    }

    private static void assertArrayEqualsInt(int val, HistogramBucket[] result, int startVal) {
        int i = startVal;
        while (i < result.length) {
            Assert.assertEquals((long)val, (long)result[i].getNbEvents());
            ++i;
        }
    }
}

