/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipEntry;

public class GzipFile
implements AutoCloseable {
    private static final String GZIP_EXTENSION = ".gz";
    private final File fFile;
    private final GzipEntry fEntry;
    private GzipEntry fCurEntry;
    private boolean fIsClosed = false;
    private final InputStream fInternalEntryStream;

    public GzipFile(File source) throws IOException {
        this.fFile = source;
        FileInputStream in = new FileInputStream(source);
        try {
            this.fInternalEntryStream = new GZIPInputStream(in);
        }
        catch (IOException e) {
            ((InputStream)in).close();
            throw e;
        }
        String name = source.getName();
        this.fCurEntry = this.fEntry = new GzipEntry(name.substring(0, name.lastIndexOf(GZIP_EXTENSION)));
    }

    @Override
    public void close() throws IOException {
        if (this.fInternalEntryStream != null && !this.fIsClosed) {
            this.fInternalEntryStream.close();
            this.fIsClosed = true;
        }
    }

    public GzipFile(String filename) throws IOException {
        this(new File(filename));
    }

    public Enumeration<GzipEntry> entries() {
        return new Enumeration<GzipEntry>(){

            @Override
            public boolean hasMoreElements() {
                return GzipFile.this.fCurEntry != null;
            }

            @Override
            public GzipEntry nextElement() {
                GzipEntry oldEntry = GzipFile.this.fCurEntry;
                GzipFile.this.fCurEntry = null;
                return oldEntry;
            }
        };
    }

    public InputStream getInputStream(GzipEntry entry) {
        if (entry != this.fEntry) {
            throw new IllegalArgumentException();
        }
        return this.fInternalEntryStream;
    }

    public String getName() {
        return this.fFile.getPath();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

