/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageBookmarkElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageExperimentElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFileElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileExportOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TracePackageExportOperation
extends AbstractTracePackageOperation {
    private static final String TRACE_EXPORT_TEMP_FOLDER = ".traceExport";
    private final TracePackageTraceElement[] fTraceExportElements;
    private final boolean fUseCompression;
    private final boolean fUseTar;
    private final Set<IResource> fResources;
    private IFolder fExportFolder;

    public TracePackageExportOperation(TracePackageTraceElement[] traceExportElements, boolean useCompression, boolean useTar, String fileName) {
        super(fileName);
        this.fTraceExportElements = traceExportElements;
        this.fUseCompression = useCompression;
        this.fUseTar = useTar;
        this.fResources = new HashSet<IResource>();
    }

    @Override
    public void run(IProgressMonitor progressMonitor) {
        try {
            int totalWork = this.getNbCheckedElements(this.fTraceExportElements) * 2;
            progressMonitor.beginTask(org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageExportOperation_GeneratingPackage, totalWork);
            this.fExportFolder = this.createExportFolder(progressMonitor);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element createElement = doc.createElement("tmf-export");
            Node tmfNode = doc.appendChild(createElement);
            ArrayList<TracePackageExperimentElement> experimentPackageElements = new ArrayList<TracePackageExperimentElement>();
            TracePackageTraceElement[] tracePackageTraceElementArray = this.fTraceExportElements;
            int n = this.fTraceExportElements.length;
            int n2 = 0;
            while (n2 < n) {
                TracePackageTraceElement tracePackageElement = tracePackageTraceElementArray[n2];
                if (TracePackageExportOperation.isFilesChecked(tracePackageElement)) {
                    if (tracePackageElement instanceof TracePackageExperimentElement) {
                        experimentPackageElements.add((TracePackageExperimentElement)tracePackageElement);
                    } else {
                        this.exportTrace(progressMonitor, tmfNode, tracePackageElement);
                    }
                }
                ++n2;
            }
            for (TracePackageExperimentElement experimentPackageElement : experimentPackageElements) {
                this.exportExperiment(progressMonitor, tmfNode, experimentPackageElement);
            }
            Transformer transformer = XmlUtils.newSecureTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StringWriter buffer = new StringWriter();
            StreamResult result = new StreamResult(buffer);
            transformer.transform(source, result);
            String content = buffer.getBuffer().toString();
            ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
            this.exportManifest(content);
            this.setStatus(this.exportToArchive(progressMonitor, totalWork));
            this.fExportFolder.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor));
            progressMonitor.done();
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCEL_STATUS);
        }
        catch (Exception e) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)e));
        }
    }

    private IFolder createExportFolder(IProgressMonitor monitor) throws CoreException {
        IFolder folder = this.fTraceExportElements[0].getTraceElement().getProject().getResource().getFolder(TRACE_EXPORT_TEMP_FOLDER);
        if (folder.exists()) {
            folder.delete(true, null);
        }
        folder.create(4097, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
        return folder;
    }

    private void exportTrace(IProgressMonitor monitor, Node tmfNode, TracePackageTraceElement tracePackageElement) throws InterruptedException, CoreException {
        this.exportCommon(monitor, tmfNode, tracePackageElement, "trace");
    }

    private void exportExperiment(IProgressMonitor monitor, Node tmfNode, TracePackageExperimentElement experimentPackageElement) throws InterruptedException, CoreException {
        Node expNode = this.exportCommon(monitor, tmfNode, experimentPackageElement, "experiment");
        TmfExperimentElement experimentElement = (TmfExperimentElement)experimentPackageElement.getTraceElement();
        for (TmfTraceElement traceElement : experimentElement.getTraces()) {
            Element expTraceXmlElement = expNode.getOwnerDocument().createElement("exp-trace");
            expTraceXmlElement.setAttribute("name", traceElement.getElementPath());
            expNode.appendChild(expTraceXmlElement);
        }
    }

    private Node exportCommon(IProgressMonitor monitor, Node tmfNode, TracePackageTraceElement tracePackageElement, String elementString) throws InterruptedException, CoreException {
        TmfCommonProjectElement commonElement = tracePackageElement.getTraceElement();
        Element commonXmlElement = tmfNode.getOwnerDocument().createElement(elementString);
        commonXmlElement.setAttribute("name", commonElement.getResource().getName());
        commonXmlElement.setAttribute("type", commonElement.getTraceType());
        Node commonNode = tmfNode.appendChild(commonXmlElement);
        TracePackageElement[] tracePackageElementArray = tracePackageElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            ModalContext.checkCanceled((IProgressMonitor)monitor);
            if (element.isChecked()) {
                if (element instanceof TracePackageSupplFilesElement) {
                    this.exportSupplementaryFiles(monitor, commonNode, commonElement, (TracePackageSupplFilesElement)element);
                } else if (element instanceof TracePackageBookmarkElement) {
                    TracePackageExportOperation.exportBookmarks(monitor, commonNode, (TracePackageBookmarkElement)element);
                } else if (element instanceof TracePackageFilesElement && commonElement instanceof TmfTraceElement) {
                    this.exportTraceFiles(monitor, commonNode, (TracePackageFilesElement)element);
                }
                monitor.worked(1);
            }
            ++n2;
        }
        return commonNode;
    }

    private void exportSupplementaryFiles(IProgressMonitor monitor, Node commonNode, TmfCommonProjectElement commonElement, TracePackageSupplFilesElement element) throws InterruptedException, CoreException {
        Document doc = commonNode.getOwnerDocument();
        if (element.getChildren().length > 0) {
            IPath projectPath = commonElement.getProject().getPath();
            TracePackageElement[] tracePackageElementArray = element.getChildren();
            int n = tracePackageElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                TracePackageElement child = tracePackageElementArray[n2];
                TracePackageSupplFileElement supplFile = (TracePackageSupplFileElement)child;
                ModalContext.checkCanceled((IProgressMonitor)monitor);
                IResource res = supplFile.getResource();
                IPath relativeToExportFolder = res.getFullPath().makeRelativeTo(projectPath);
                IFolder folder = this.fExportFolder.getFolder(relativeToExportFolder.removeLastSegments(1));
                TraceUtils.createFolder(folder, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                res.refreshLocal(0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                TracePackageExportOperation.createExportResource(folder, res);
                Element suppFileElement = doc.createElement("supplementary-file");
                suppFileElement.setAttribute("name", relativeToExportFolder.toString());
                commonNode.appendChild(suppFileElement);
                ++n2;
            }
            IFolder suppFilesFolder = this.fExportFolder.getFolder(".tracing");
            this.fResources.add((IResource)suppFilesFolder);
        }
    }

    private void exportTraceFiles(IProgressMonitor monitor, Node traceNode, TracePackageFilesElement element) throws CoreException {
        Document doc = traceNode.getOwnerDocument();
        TmfCommonProjectElement traceElement = ((TracePackageTraceElement)element.getParent()).getTraceElement();
        IResource resource = traceElement.getResource();
        TmfTraceFolder tracesFolder = traceElement.getProject().getTracesFolder();
        if (tracesFolder == null) {
            return;
        }
        IPath traceFolderPath = tracesFolder.getPath();
        IPath relativeToExportFolder = resource.getFullPath().makeRelativeTo(traceFolderPath);
        IFolder folder = this.fExportFolder.getFolder(relativeToExportFolder.removeLastSegments(1));
        TraceUtils.createFolder(folder, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
        TracePackageExportOperation.createExportResource(folder, resource);
        Element fileElement = doc.createElement("file");
        fileElement.setAttribute("name", relativeToExportFolder.toString());
        traceNode.appendChild(fileElement);
        IResource exportedResource = this.fExportFolder.findMember(relativeToExportFolder.segment(0));
        this.fResources.add(exportedResource);
    }

    private static IResource createExportResource(IFolder exportFolder, IResource res) throws CoreException {
        IFolder ret = null;
        if (res instanceof IFolder) {
            IFolder folder = exportFolder.getFolder(res.getName());
            folder.createLink(res.getLocationURI(), 256, null);
            ret = folder;
        } else if (res instanceof IFile) {
            IFile file = exportFolder.getFile(res.getName());
            if (!file.exists()) {
                file.createLink(res.getLocationURI(), 0, null);
            }
            ret = file;
        }
        return ret;
    }

    private static void exportBookmarks(IProgressMonitor monitor, Node commonNode, TracePackageBookmarkElement element) throws CoreException, InterruptedException {
        IMarker[] findMarkers;
        Document doc = commonNode.getOwnerDocument();
        IFile bookmarksFile = ((TracePackageTraceElement)element.getParent()).getTraceElement().getBookmarksFile();
        if (bookmarksFile != null && bookmarksFile.exists() && (findMarkers = bookmarksFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0)).length > 0) {
            Element bookmarksXmlElement = doc.createElement("bookmarks");
            Node bookmarksNode = commonNode.appendChild(bookmarksXmlElement);
            IMarker[] iMarkerArray = findMarkers;
            int n = findMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                ModalContext.checkCanceled((IProgressMonitor)monitor);
                Element singleBookmarkXmlElement = doc.createElement("bookmark");
                for (String key : marker.getAttributes().keySet()) {
                    singleBookmarkXmlElement.setAttribute(key, marker.getAttribute(key).toString());
                }
                bookmarksNode.appendChild(singleBookmarkXmlElement);
                ++n2;
            }
        }
    }

    private void exportManifest(String content) throws CoreException {
        IFile file = this.fExportFolder.getFile("export-manifest.xml");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        if (file.exists()) {
            file.setContents((InputStream)inputStream, 1, null);
        } else {
            file.create((InputStream)inputStream, 4097, null);
        }
        this.fResources.add((IResource)file);
    }

    private IStatus exportToArchive(IProgressMonitor monitor, int totalWork) throws InvocationTargetException, InterruptedException {
        ArchiveFileExportOperation op = new ArchiveFileExportOperation(new ArrayList<IResource>(this.fResources), this.getFileName());
        op.setCreateLeadupStructure(false);
        op.setIncludeLinkedResources(true);
        op.setUseCompression(this.fUseCompression);
        op.setUseTarFormat(this.fUseTar);
        op.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).newChild(totalWork / 2));
        return op.getStatus();
    }
}

