/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.undo;

import java.util.EventObject;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.SSECoreMessages;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.CommandCursorPosition;
import org.eclipse.wst.sse.core.internal.undo.IDocumentSelectionMediator;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.core.internal.undo.StructuredTextCommand;
import org.eclipse.wst.sse.core.internal.undo.StructuredTextCommandImpl;
import org.eclipse.wst.sse.core.internal.undo.StructuredTextCompoundCommandImpl;
import org.eclipse.wst.sse.core.internal.undo.UndoDocumentEvent;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.sse.core.internal.util.Utilities;

public class StructuredTextUndoManager
implements IStructuredTextUndoManager {
    private static final String TEXT_CHANGE_TEXT = SSECoreMessages.Text_Change_UI_;
    private CommandStack fCommandStack = null;
    private StructuredTextCompoundCommandImpl fCompoundCommand = null;
    private String fCompoundCommandDescription = null;
    private String fCompoundCommandLabel = null;
    int fCursorPosition = 0;
    private IDocument fDocument;
    private InternalCommandStackListener fInternalCommandStackListener;
    private IStructuredDocumentListener fInternalStructuredDocumentListener;
    private IDocumentSelectionMediator[] fMediators = null;
    private boolean fRecording = false;
    private int fRecordingCount = 0;
    private Object fRequester;
    StructuredTextCommandImpl fTextCommand = null;
    private int fUndoCursorPosition = -1;
    boolean fUndoManagementEnabled = true;
    private int fUndoSelectionLength = 0;

    public StructuredTextUndoManager() {
        this((CommandStack)new BasicCommandStack());
    }

    public StructuredTextUndoManager(CommandStack commandStack) {
        this.setCommandStack(commandStack);
    }

    private void addDocumentSelectionMediator(IDocumentSelectionMediator mediator) {
        if (!Utilities.contains(this.fMediators, mediator)) {
            int oldSize = 0;
            if (this.fMediators != null) {
                oldSize = this.fMediators.length;
            }
            int newSize = oldSize + 1;
            IDocumentSelectionMediator[] newMediators = new IDocumentSelectionMediator[newSize];
            if (this.fMediators != null) {
                System.arraycopy(this.fMediators, 0, newMediators, 0, oldSize);
            }
            newMediators[newSize - 1] = mediator;
            this.fMediators = newMediators;
        } else {
            this.removeDocumentSelectionMediator(mediator);
            this.addDocumentSelectionMediator(mediator);
        }
    }

    @Override
    public void beginRecording(Object requester) {
        this.beginRecording(requester, null, null);
    }

    @Override
    public void beginRecording(Object requester, int cursorPosition, int selectionLength) {
        this.beginRecording(requester, null, null);
        this.fUndoCursorPosition = cursorPosition;
        this.fUndoSelectionLength = selectionLength;
    }

    @Override
    public void beginRecording(Object requester, String label) {
        this.beginRecording(requester, label, null);
    }

    @Override
    public void beginRecording(Object requester, String label, int cursorPosition, int selectionLength) {
        this.beginRecording(requester, label, null);
        this.fUndoCursorPosition = cursorPosition;
        this.fUndoSelectionLength = selectionLength;
    }

    @Override
    public void beginRecording(Object requester, String label, String description) {
        this.fRequester = requester;
        if (this.fRecordingCount == 0) {
            this.fCompoundCommandLabel = label;
            if (this.fCompoundCommandLabel == null) {
                this.fCompoundCommandLabel = TEXT_CHANGE_TEXT;
            }
            this.fCompoundCommandDescription = description;
            if (this.fCompoundCommandDescription == null) {
                this.fCompoundCommandDescription = TEXT_CHANGE_TEXT;
            }
            this.fTextCommand = null;
            this.fCompoundCommand = null;
        }
        ++this.fRecordingCount;
        this.fRecording = true;
        this.fUndoCursorPosition = -1;
        this.fUndoSelectionLength = 0;
    }

    @Override
    public void beginRecording(Object requester, String label, String description, int cursorPosition, int selectionLength) {
        this.beginRecording(requester, label, description);
        this.fUndoCursorPosition = cursorPosition;
        this.fUndoSelectionLength = selectionLength;
    }

    void checkRequester(Object requester) {
        if (!(this.fRequester == null || this.fRequester.equals(requester) || requester instanceof IStructuredModel || requester instanceof IStructuredDocument)) {
            this.resetInternalCommands();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void connect(IDocumentSelectionMediator mediator) {
        Assert.isNotNull(mediator);
        if (this.fDocument == null) {
            this.fDocument = mediator.getDocument();
            if (!(this.fDocument instanceof IStructuredDocument)) throw new IllegalArgumentException("only meditator with structured documents currently handled");
            ((IStructuredDocument)this.fDocument).addDocumentChangedListener(this.getInternalStructuredDocumentListener());
        } else if (!this.fDocument.equals(mediator.getDocument())) {
            throw new IllegalStateException("Connection to undo manager failed. Document for document selection mediator inconistent with undo manager.");
        }
        this.addDocumentSelectionMediator(mediator);
    }

    void createNewTextCommand(String textDeleted, String textInserted, int textStart, int textEnd) {
        StructuredTextCommandImpl textCommand = new StructuredTextCommandImpl(this.fDocument);
        textCommand.setLabel(TEXT_CHANGE_TEXT);
        textCommand.setDescription(TEXT_CHANGE_TEXT);
        textCommand.setTextStart(textStart);
        textCommand.setTextEnd(textEnd);
        textCommand.setTextDeleted(textDeleted);
        textCommand.setTextInserted(textInserted);
        if (this.fRecording) {
            if (this.fCompoundCommand == null) {
                StructuredTextCompoundCommandImpl compoundCommand = new StructuredTextCompoundCommandImpl();
                compoundCommand.setUndoCursorPosition(this.fUndoCursorPosition);
                compoundCommand.setUndoSelectionLength(this.fUndoSelectionLength);
                compoundCommand.setLabel(this.fCompoundCommandLabel);
                compoundCommand.setDescription(this.fCompoundCommandDescription);
                compoundCommand.append((Command)textCommand);
                this.fCompoundCommand = compoundCommand;
            } else {
                this.fCompoundCommand.append((Command)textCommand);
            }
        } else {
            this.fCommandStack.execute((Command)textCommand);
        }
        this.fTextCommand = textCommand;
    }

    @Override
    public void disableUndoManagement() {
        this.fUndoManagementEnabled = false;
    }

    @Override
    public void disconnect(IDocumentSelectionMediator mediator) {
        this.removeDocumentSelectionMediator(mediator);
        if (this.fMediators != null && this.fMediators.length == 0 && this.fDocument != null) {
            if (!(this.fDocument instanceof IStructuredDocument)) {
                throw new IllegalArgumentException("only meditator with structured documents currently handled");
            }
            ((IStructuredDocument)this.fDocument).removeDocumentChangedListener(this.getInternalStructuredDocumentListener());
            this.fDocument = null;
        }
    }

    @Override
    public void enableUndoManagement() {
        this.fUndoManagementEnabled = true;
    }

    @Override
    public void endRecording(Object requester) {
        int cursorPosition = this.fTextCommand != null ? this.fTextCommand.getTextEnd() : -1;
        int selectionLength = 0;
        this.endRecording(requester, cursorPosition, selectionLength);
    }

    @Override
    public void endRecording(Object requester, int cursorPosition, int selectionLength) {
        if (this.fRecording) {
            if (this.fCompoundCommand != null) {
                this.fCompoundCommand.setRedoCursorPosition(cursorPosition);
                this.fCompoundCommand.setRedoSelectionLength(selectionLength);
            }
            this.fTextCommand = null;
            if (this.fRecordingCount > 0) {
                --this.fRecordingCount;
            }
            if (this.fRecordingCount == 0) {
                if (this.fCompoundCommand != null) {
                    this.fCommandStack.execute((Command)this.fCompoundCommand);
                }
                this.fRecording = false;
                this.fCompoundCommand = null;
                this.fCompoundCommandLabel = null;
                this.fCompoundCommandDescription = null;
                this.fRequester = null;
            }
        }
    }

    private IStructuredModel findStructuredModel(IDocument document) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel structuredModel = modelManager.getExistingModelForRead(document);
        return structuredModel;
    }

    @Override
    public void forceEndOfPendingCommand(Object requester, int currentPosition, int length) {
        if (this.fRecording) {
            this.endRecording(requester, currentPosition, length);
        } else {
            this.resetInternalCommands();
        }
    }

    @Override
    public CommandStack getCommandStack() {
        return this.fCommandStack;
    }

    private CommandStackListener getInternalCommandStackListener() {
        if (this.fInternalCommandStackListener == null) {
            this.fInternalCommandStackListener = new InternalCommandStackListener();
        }
        return this.fInternalCommandStackListener;
    }

    private IStructuredDocumentListener getInternalStructuredDocumentListener() {
        if (this.fInternalStructuredDocumentListener == null) {
            this.fInternalStructuredDocumentListener = new InternalStructuredDocumentListener();
        }
        return this.fInternalStructuredDocumentListener;
    }

    @Override
    public Command getRedoCommand() {
        return this.fCommandStack.getRedoCommand();
    }

    @Override
    public Command getUndoCommand() {
        return this.fCommandStack.getUndoCommand();
    }

    @Override
    public void redo() {
        this.redo(null);
    }

    @Override
    public void redo(IDocumentSelectionMediator requester) {
        IStructuredModel model = this.findStructuredModel(this.fDocument);
        if (this.redoable()) {
            IDocumentExtension4 docExt4 = null;
            DocumentRewriteSession rewriteSession = null;
            try {
                Command redoCommand;
                if (model != null) {
                    model.aboutToChangeModel();
                }
                if ((redoCommand = this.getRedoCommand()) instanceof CompoundCommand && model.getStructuredDocument() instanceof IDocumentExtension4) {
                    docExt4 = (IDocumentExtension4)model.getStructuredDocument();
                }
                rewriteSession = docExt4 == null ? null : docExt4.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                this.fCommandStack.redo();
                this.setRedoDocumentSelection(requester, redoCommand);
            }
            catch (Throwable throwable) {
                if (docExt4 != null && rewriteSession != null) {
                    docExt4.stopRewriteSession(rewriteSession);
                }
                if (model != null) {
                    model.changedModel();
                    model.releaseFromRead();
                }
                throw throwable;
            }
            if (docExt4 != null && rewriteSession != null) {
                docExt4.stopRewriteSession(rewriteSession);
            }
            if (model != null) {
                model.changedModel();
                model.releaseFromRead();
            }
        }
    }

    @Override
    public boolean redoable() {
        return this.fCommandStack.canRedo();
    }

    private void removeDocumentSelectionMediator(IDocumentSelectionMediator mediator) {
        if (this.fMediators != null && mediator != null && Utilities.contains(this.fMediators, mediator)) {
            int oldSize = this.fMediators.length;
            int newSize = oldSize - 1;
            IDocumentSelectionMediator[] newMediators = new IDocumentSelectionMediator[newSize];
            int index = 0;
            int i = 0;
            while (i < oldSize) {
                if (this.fMediators[i] != mediator) {
                    newMediators[index++] = this.fMediators[i];
                }
                ++i;
            }
            this.fMediators = newMediators;
        }
    }

    void resetInternalCommands() {
        this.fCompoundCommand = null;
        this.fTextCommand = null;
        this.fRequester = null;
    }

    @Override
    public void setCommandStack(CommandStack commandStack) {
        if (this.fCommandStack != null) {
            this.fCommandStack.removeCommandStackListener(this.getInternalCommandStackListener());
        }
        this.fCommandStack = commandStack;
        if (this.fCommandStack != null) {
            this.fCommandStack.addCommandStackListener(this.getInternalCommandStackListener());
        }
    }

    private void setRedoDocumentSelection(IDocumentSelectionMediator requester, Command command) {
        int cursorPosition = -1;
        int selectionLength = 0;
        if (command instanceof CommandCursorPosition) {
            CommandCursorPosition commandCursorPosition = (CommandCursorPosition)command;
            cursorPosition = commandCursorPosition.getRedoCursorPosition();
            selectionLength = commandCursorPosition.getRedoSelectionLength();
        } else if (command instanceof StructuredTextCommand) {
            StructuredTextCommand structuredTextCommand = (StructuredTextCommand)command;
            cursorPosition = structuredTextCommand.getTextStart();
            selectionLength = structuredTextCommand.getTextInserted().length();
        }
        if (cursorPosition > -1 && this.fMediators != null && this.fMediators.length > 0) {
            int i = 0;
            while (i < this.fMediators.length) {
                IDocument document = this.fMediators[i].getDocument();
                this.fMediators[i].undoOperationSelectionChanged(new UndoDocumentEvent(requester, document, cursorPosition, selectionLength));
                ++i;
            }
        }
    }

    private void setUndoDocumentSelection(IDocumentSelectionMediator requester, Command command) {
        int cursorPosition = -1;
        int selectionLength = 0;
        if (command instanceof CommandCursorPosition) {
            CommandCursorPosition commandCursorPosition = (CommandCursorPosition)command;
            cursorPosition = commandCursorPosition.getUndoCursorPosition();
            selectionLength = commandCursorPosition.getUndoSelectionLength();
        } else if (command instanceof StructuredTextCommand) {
            StructuredTextCommand structuredTextCommand = (StructuredTextCommand)command;
            cursorPosition = structuredTextCommand.getTextStart();
            selectionLength = structuredTextCommand.getTextDeleted().length();
        }
        if (cursorPosition > -1 && this.fMediators != null && this.fMediators.length > 0) {
            int i = 0;
            while (i < this.fMediators.length) {
                IDocument document = this.fMediators[i].getDocument();
                this.fMediators[i].undoOperationSelectionChanged(new UndoDocumentEvent(requester, document, cursorPosition, selectionLength));
                ++i;
            }
        }
    }

    @Override
    public void undo() {
        this.undo(null);
    }

    @Override
    public void undo(IDocumentSelectionMediator requester) {
        if (this.fRecording) {
            this.endRecording(this);
        }
        if (this.undoable()) {
            IStructuredModel model = this.findStructuredModel(this.fDocument);
            IDocumentExtension4 docExt4 = null;
            DocumentRewriteSession rewriteSession = null;
            try {
                Command undoCommand;
                if (model != null) {
                    model.aboutToChangeModel();
                }
                if ((undoCommand = this.getUndoCommand()) instanceof CompoundCommand && model.getStructuredDocument() instanceof IDocumentExtension4) {
                    docExt4 = (IDocumentExtension4)model.getStructuredDocument();
                }
                rewriteSession = docExt4 == null ? null : docExt4.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                this.fCommandStack.undo();
                this.setUndoDocumentSelection(requester, undoCommand);
            }
            catch (Throwable throwable) {
                if (docExt4 != null && rewriteSession != null) {
                    docExt4.stopRewriteSession(rewriteSession);
                }
                if (model != null) {
                    model.changedModel();
                    model.releaseFromRead();
                }
                throw throwable;
            }
            if (docExt4 != null && rewriteSession != null) {
                docExt4.stopRewriteSession(rewriteSession);
            }
            if (model != null) {
                model.changedModel();
                model.releaseFromRead();
            }
        }
    }

    @Override
    public boolean undoable() {
        return this.fCommandStack.canUndo();
    }

    class InternalCommandStackListener
    implements CommandStackListener {
        InternalCommandStackListener() {
        }

        public void commandStackChanged(EventObject event) {
            StructuredTextUndoManager.this.resetInternalCommands();
        }
    }

    class InternalStructuredDocumentListener
    implements IStructuredDocumentListener {
        InternalStructuredDocumentListener() {
        }

        @Override
        public void newModel(NewDocumentEvent structuredDocumentEvent) {
        }

        @Override
        public void noChange(NoChangeEvent structuredDocumentEvent) {
        }

        @Override
        public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
            this.processStructuredDocumentEvent(structuredDocumentEvent);
        }

        private void processStructuredDocumentEvent(String textDeleted, String textInserted, int textStart, int textEnd) {
            if (StructuredTextUndoManager.this.fTextCommand != null && textStart == StructuredTextUndoManager.this.fTextCommand.getTextEnd()) {
                StructuredTextUndoManager.this.fTextCommand.setTextDeleted(StructuredTextUndoManager.this.fTextCommand.getTextDeleted().concat(textDeleted));
                StructuredTextUndoManager.this.fTextCommand.setTextInserted(StructuredTextUndoManager.this.fTextCommand.getTextInserted().concat(textInserted));
                StructuredTextUndoManager.this.fTextCommand.setTextEnd(textEnd);
            } else if (StructuredTextUndoManager.this.fTextCommand != null && textStart == StructuredTextUndoManager.this.fTextCommand.getTextStart() - 1 && textEnd <= StructuredTextUndoManager.this.fTextCommand.getTextEnd() - 1 && textDeleted.length() == 1 && textInserted.length() == 0 && StructuredTextUndoManager.this.fTextCommand.getTextDeleted().length() > 0) {
                StructuredTextUndoManager.this.fTextCommand.setTextDeleted(textDeleted.concat(StructuredTextUndoManager.this.fTextCommand.getTextDeleted()));
                StructuredTextUndoManager.this.fTextCommand.setTextStart(textStart);
            } else {
                StructuredTextUndoManager.this.createNewTextCommand(textDeleted, textInserted, textStart, textEnd);
            }
            StructuredTextUndoManager.this.fCursorPosition = textEnd;
        }

        private void processStructuredDocumentEvent(StructuredDocumentEvent structuredDocumentEvent) {
            if (StructuredTextUndoManager.this.fUndoManagementEnabled && !(structuredDocumentEvent.getOriginalRequester() instanceof Command)) {
                if (!StructuredTextUndoManager.this.fRecording) {
                    StructuredTextUndoManager.this.checkRequester(structuredDocumentEvent.getOriginalRequester());
                }
                String textDeleted = structuredDocumentEvent.getDeletedText();
                String textInserted = structuredDocumentEvent.getText();
                int textStart = structuredDocumentEvent.getOffset();
                int textEnd = textStart + textInserted.length();
                this.processStructuredDocumentEvent(textDeleted, textInserted, textStart, textEnd);
            }
        }

        @Override
        public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
            this.processStructuredDocumentEvent(structuredDocumentEvent);
        }

        @Override
        public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
            this.processStructuredDocumentEvent(structuredDocumentEvent);
        }
    }
}

