/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.pb.constraints.pb.ConflictMap;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.pb.constraints.pb.PBConstr;

public final class ConflictMapSwitchToClause
extends ConflictMap {
    public static int UpperBound;

    public ConflictMapSwitchToClause(PBConstr cpb, int level) {
        super(cpb, level);
    }

    public static IConflict createConflict(PBConstr cpb, int level) {
        return new ConflictMapSwitchToClause(cpb, level);
    }

    protected BigInteger reduceUntilConflict(int litImplied, int ind, BigInteger[] reducedCoefs, IWatchPb wpb) {
        BigInteger degreeCons = super.reduceUntilConflict(litImplied, ind, reducedCoefs, wpb);
        int i = 0;
        while (i < reducedCoefs.length && reducedCoefs[i].equals(BigInteger.ZERO) && i != ind) {
            ++i;
        }
        if (i < reducedCoefs.length) {
            BigInteger bigCoef = reducedCoefs[i].multiply(this.coefMultCons);
            if (this.weightedLits.containsKey(wpb.get(i))) {
                bigCoef = bigCoef.add(this.weightedLits.get(wpb.get(i)).multiply(this.coefMult));
            }
            if (bigCoef.toString().length() > UpperBound) {
                ++this.numberOfReductions;
                this.hasBeenReduced = true;
                degreeCons = this.reduceToClause(ind, wpb, reducedCoefs);
                this.coefMultCons = this.weightedLits.get(litImplied ^ 1);
                this.coefMult = BigInteger.ONE;
            }
        }
        return degreeCons;
    }

    private BigInteger reduceToClause(int ind, IWatchPb wpb, BigInteger[] reducedCoefs) {
        int i = 0;
        while (i < reducedCoefs.length) {
            reducedCoefs[i] = i == ind || wpb.getVocabulary().isFalsified(wpb.get(i)) ? BigInteger.ONE : BigInteger.ZERO;
            ++i;
        }
        return BigInteger.ONE;
    }
}

