/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.dataprovider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.tmf.core.model.timegraph.IElementResolver;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;

public class CriticalPathEntry
extends TimeGraphEntryModel
implements IElementResolver {
    private final Long fSum;
    private final Double fPercent;
    private final @NonNull Multimap<@NonNull String, @NonNull Object> fAspects = HashMultimap.create();

    public CriticalPathEntry(long id, long parentId, IGraphWorker worker, long startTime, long endTime, Long sum, Double percent) {
        super(id, parentId, Collections.singletonList(String.valueOf(worker)), startTime, endTime);
        this.fSum = sum;
        this.fPercent = percent;
        this.fAspects.put((Object)"hostId", (Object)worker.getHostId());
        for (Map.Entry<String, String> entry : worker.getWorkerInformation().entrySet()) {
            this.fAspects.put((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    public CriticalPathEntry(long id, long parentId, @NonNull List<@NonNull String> labels, long startTime, long endTime, Long sum, Double percent) {
        super(id, parentId, labels, startTime, endTime);
        this.fSum = sum;
        this.fPercent = percent;
    }

    public Long getSum() {
        return this.fSum;
    }

    public Double getPercent() {
        return this.fPercent;
    }

    public @NonNull Multimap<@NonNull String, @NonNull Object> getMetadata() {
        return this.fAspects;
    }

    public boolean hasRowModel() {
        return this.getParentId() != -1L;
    }
}

