/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class CopyTableRenderingToClipboardAction
extends Action {
    private final String COLUMN_SEPERATOR = "  ";
    protected AbstractBaseTableRendering fRendering;
    protected StructuredViewer fViewer;

    public CopyTableRenderingToClipboardAction(AbstractBaseTableRendering rendering, StructuredViewer viewer) {
        this.fRendering = rendering;
        this.fViewer = viewer;
        this.setText(DebugUIMessages.CopyViewToClipboardAction_title);
        this.setToolTipText(DebugUIMessages.CopyViewToClipboardAction_tooltip);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_COPY_VIEW_TO_CLIPBOARD"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_COPY_VIEW_TO_CLIPBOARD"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_COPY_VIEW_TO_CLIPBOARD"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.PrintViewTabContextAction_context");
    }

    protected String concatenateTableAsString(TableItem[] itemList) {
        if (itemList.length == 0) {
            return null;
        }
        StringBuilder tableContents = new StringBuilder();
        Table table = (Table)this.fViewer.getControl();
        int numColumns = table.getColumnCount();
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.fViewer.getLabelProvider();
        TableColumn[] columns = table.getColumns();
        String label = this.fRendering.getLabel();
        tableContents.append(label);
        tableContents.append(System.getProperty("line.separator"));
        tableContents.append("  ");
        int charsPerByte = this.fRendering.getNumCharsPerByte();
        if (charsPerByte < 0) {
            charsPerByte = 4;
        }
        int k = 0;
        while (k < numColumns) {
            StringBuilder columnLabel = new StringBuilder(columns[k].getText());
            int numBytes = 0;
            int numChars = 0;
            if (k > 0) {
                numBytes = this.fRendering.getBytesPerColumn();
                numChars = numBytes * charsPerByte;
            } else {
                IMemoryBlock memBlock = this.fRendering.getMemoryBlock();
                if (memBlock instanceof IMemoryBlockExtension) {
                    TableRenderingContentDescriptor descriptor = (TableRenderingContentDescriptor)this.fRendering.getAdapter(TableRenderingContentDescriptor.class);
                    if (descriptor == null) {
                        try {
                            numBytes = ((IMemoryBlockExtension)memBlock).getAddressSize();
                        }
                        catch (DebugException debugException) {
                            numBytes = 0;
                        }
                    } else {
                        numBytes = descriptor.getAddressSize();
                    }
                    if (numBytes <= 0) {
                        numBytes = 4;
                    }
                } else {
                    numBytes = 4;
                }
                numChars = numBytes * 2;
            }
            while (columnLabel.length() < numChars) {
                columnLabel.append(" ");
            }
            tableContents.append((CharSequence)columnLabel);
            tableContents.append("  ");
            ++k;
        }
        tableContents.append(System.getProperty("line.separator"));
        int i = 0;
        while (i < itemList.length) {
            int j = 0;
            while (j < numColumns) {
                tableContents.append("  ");
                StringBuilder temp = new StringBuilder(labelProvider.getColumnText(itemList[i].getData(), j));
                if (j > 0) {
                    int numBytes = this.fRendering.getBytesPerColumn();
                    int numChars = numBytes * charsPerByte;
                    while (temp.length() < numChars) {
                        temp.append(" ");
                    }
                }
                tableContents.append((CharSequence)temp);
                ++j;
            }
            tableContents.append(System.getProperty("line.separator"));
            ++i;
        }
        return tableContents.toString();
    }

    public void run() {
        if (this.fRendering == null) {
            return;
        }
        if (!(this.fViewer.getControl() instanceof Table)) {
            return;
        }
        Table table = (Table)this.fViewer.getControl();
        if (table == null) {
            return;
        }
        Clipboard clip = null;
        try {
            clip = new Clipboard(table.getDisplay());
            TableItem[] tableItems = table.getItems();
            String tableAsString = new String();
            tableAsString = this.concatenateTableAsString(tableItems);
            if (!tableAsString.equals("")) {
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                clip.setContents(new Object[]{tableAsString}, new Transfer[]{plainTextTransfer});
            }
        }
        finally {
            if (clip != null) {
                clip.dispose();
            }
        }
    }
}

