/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.stubs;

import java.util.List;
import java.util.Set;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.junit.Assert;

public class GraphOps {
    public static void checkEquality(TmfGraph g1, TmfGraph g2) {
        Set obj1 = g1.getWorkers();
        Set obj2 = g2.getWorkers();
        Assert.assertEquals((String)"Graph objects", (Object)obj1, (Object)obj2);
        for (IGraphWorker graphObject : obj1) {
            Assert.assertNotNull((Object)graphObject);
            List nodesOf1 = g1.getNodesOf(graphObject);
            List nodesOf2 = g2.getNodesOf(graphObject);
            int i = 0;
            while (i < nodesOf1.size()) {
                TmfVertex v1 = (TmfVertex)nodesOf1.get(i);
                TmfVertex v2 = (TmfVertex)nodesOf2.get(i);
                Assert.assertEquals((String)("Node timestamps for " + graphObject + ", node " + i), (long)v1.getTs(), (long)v2.getTs());
                TmfVertex.EdgeDirection[] edgeDirectionArray = TmfVertex.EdgeDirection.values();
                int n = edgeDirectionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TmfVertex.EdgeDirection dir = edgeDirectionArray[n2];
                    TmfEdge edge1 = v1.getEdge(dir);
                    TmfEdge edge2 = v2.getEdge(dir);
                    if (edge1 == null) {
                        Assert.assertNull((String)("Expected null edge for " + graphObject + ", node " + i + " and dir " + dir), (Object)edge2);
                    } else {
                        Assert.assertNotNull((String)("Expected non null edge for " + graphObject + ", node " + i + " and dir " + dir), (Object)edge2);
                        Assert.assertEquals((String)("Edge type for " + graphObject + ", node " + i + " and dir " + dir), (Object)edge1.getType(), (Object)edge2.getType());
                        Assert.assertEquals((String)("Edge duration for " + graphObject + ", node " + i + " edge direction " + dir), (long)edge1.getDuration(), (long)edge2.getDuration());
                        Assert.assertEquals((String)("From objects for " + graphObject + ", node " + i + " and dir " + dir), (Object)g1.getParentOf(edge1.getVertexFrom()), (Object)g2.getParentOf(edge2.getVertexFrom()));
                        Assert.assertEquals((String)("To objects for " + graphObject + ", node " + i + " and dir " + dir), (Object)g1.getParentOf(edge1.getVertexTo()), (Object)g2.getParentOf(edge2.getVertexTo()));
                        Assert.assertEquals((String)("Edge qualifier for " + graphObject + ", node " + i + " and dir " + dir), (Object)edge1.getLinkQualifier(), (Object)edge2.getLinkQualifier());
                    }
                    ++n2;
                }
                ++i;
            }
        }
    }
}

