/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.filter.parser;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterCu;
import org.eclipse.tracecompass.tmf.core.tests.filter.parser.ElementResolverStub;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.junit.Assert;
import org.junit.Test;

public class ElementResolverFilterTest {
    private static final ElementResolverStub ELEMENT = new ElementResolverStub((Multimap<String, Object>)ImmutableMultimap.of((Object)"label", (Object)"elementLabel", (Object)"key0", (Object)"value0", (Object)"key0", (Object)"some other", (Object)"key 2", (Object)"value2", (Object)"key3", (Object)"10"));

    @Test
    public void testRegex() {
        FilterCu cu = FilterCu.compile((String)"Label");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"fail");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"0$");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"a.*l");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"y$");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
    }

    @Test
    public void testLogicalOperator() {
        FilterCu cu = FilterCu.compile((String)"Label && value");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"label && fail");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"Label || absent");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"absent || fail");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
    }

    @Test
    public void testEqualsOperator() {
        FilterCu cu = FilterCu.compile((String)"label == elementLabel");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"label == fail");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
    }

    @Test
    public void testNotEqualsOperator() {
        FilterCu cu = FilterCu.compile((String)"label != fail");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"label != elementLabel");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
    }

    @Test
    public void testNotOperator() {
        FilterCu cu = FilterCu.compile((String)"!fail");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"!elementLabel");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
    }

    @Test
    public void testContainsOperator() {
        FilterCu cu = FilterCu.compile((String)"label contains element");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"label contains value");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
    }

    @Test
    public void testPresentOperator() {
        FilterCu cu = FilterCu.compile((String)"key0 present");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"invalidKey present");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
    }

    @Test
    public void testMatchesOperator() {
        FilterCu cu = FilterCu.compile((String)"key0 matches v.*ue");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"key0 matches o.*er");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"key0 matches v.*ue$");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)" \"key 2\" matches value2");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
    }

    @Test
    public void testGreaterThanOperator() {
        FilterCu cu = FilterCu.compile((String)"key3 > 9");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"key3 > 10");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
    }

    @Test
    public void testLessThanOperator() {
        FilterCu cu = FilterCu.compile((String)"key3 < 11");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"key3 < 10");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
    }

    @Test
    public void testComplexFilter() {
        FilterCu cu = FilterCu.compile((String)"(key0 matches v.*ue) && Label");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"!(key0 matches v.*ue) && Label");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"(key0 matches v.*ue) && (key0 matches \"some other\")");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        cu = FilterCu.compile((String)"(key0 matches v.*ue) && (key0 matches \"invalid\")");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
    }

    @Test
    public void testFilterWithNumber() {
        FilterCu cu = FilterCu.compile((String)"key3 > 9");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.getMetadata()));
        Assert.assertFalse((boolean)predicate.test(ImmutableMultimap.of((Object)"key3", (Object)8)));
        cu = FilterCu.compile((String)"key3 > 9a");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
        Assert.assertTrue((boolean)predicate.test(ImmutableMultimap.of((Object)"key3", (Object)"9b")));
        cu = FilterCu.compile((String)"key3 > 2ms");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
        Assert.assertTrue((boolean)predicate.test(ImmutableMultimap.of((Object)"key3", (Object)10000000)));
        cu = FilterCu.compile((String)"key3 > 2k");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
        Assert.assertTrue((boolean)predicate.test(ImmutableMultimap.of((Object)"key3", (Object)10000000)));
        Map defaultPrefMap = TmfTimePreferences.getPreferenceMap();
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        String dateFormat = (String)defaultPrefMap.get("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime");
        try {
            defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "TTT.SSS SSS SSS");
            TmfTimestampFormat.updateDefaultFormats();
            long timeValue = 1000000000L;
            String dateString = TmfTimestampFormat.getDefaulTimeFormat().format(timeValue);
            cu = FilterCu.compile((String)("key3 == \"" + dateString + "\""));
            Assert.assertNotNull((Object)cu);
            predicate = cu.generate();
            Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
            Assert.assertFalse((boolean)predicate.test(ImmutableMultimap.of((Object)"key3", (Object)(timeValue + 3L))));
            Assert.assertTrue((boolean)predicate.test(ImmutableMultimap.of((Object)"key3", (Object)timeValue)));
            timeValue = 1539786952382956759L;
            dateString = TmfTimestampFormat.getDefaulTimeFormat().format(timeValue);
            cu = FilterCu.compile((String)("key3 == \"" + dateString + "\""));
            Assert.assertNotNull((Object)cu);
            predicate = cu.generate();
            Assert.assertFalse((boolean)predicate.test(ELEMENT.getMetadata()));
            Assert.assertFalse((boolean)predicate.test(ImmutableMultimap.of((Object)"key3", (Object)(timeValue + 3L))));
            Assert.assertTrue((boolean)predicate.test(ImmutableMultimap.of((Object)"key3", (Object)timeValue)));
        }
        finally {
            defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", dateFormat);
            TmfTimestampFormat.updateDefaultFormats();
        }
    }

    @Test
    public void testInvalid() {
        FilterCu cu = FilterCu.compile((String)"label = elementLabel");
        Assert.assertNull((Object)cu);
    }
}

