/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model.provisional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;

public class ModelDelta
implements IModelDelta {
    private IModelDelta fParent;
    private Object fElement;
    private int fFlags;
    private ModelDelta[] fNodes = EMPTY_NODES;
    private List<ModelDelta> fNodesList;
    private Map<Object, Object> fNodesMap;
    private Object fReplacement;
    private int fIndex;
    private int fChildCount;
    private static final ModelDelta[] EMPTY_NODES = new ModelDelta[0];

    public ModelDelta(Object element, int flags) {
        this.fElement = element;
        this.fFlags = flags;
        this.fIndex = -1;
        this.fChildCount = -1;
    }

    public ModelDelta(Object element, Object replacement, int flags) {
        this(element, flags);
        this.fReplacement = replacement;
    }

    public ModelDelta(Object element, int index, int flags) {
        this(element, flags);
        this.fIndex = index;
    }

    public ModelDelta(Object element, int index, int flags, int childCount) {
        this(element, index, flags);
        this.fChildCount = childCount;
    }

    @Override
    public Object getElement() {
        return this.fElement;
    }

    @Override
    public int getFlags() {
        return this.fFlags;
    }

    public ModelDelta addNode(Object element, int flags) {
        ModelDelta node = new ModelDelta(element, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public ModelDelta getChildDelta(Object element) {
        Object nodeOrNodes;
        if (this.fNodesMap == null) {
            this.mapNodes();
        }
        if ((nodeOrNodes = this.fNodesMap.get(element)) instanceof ModelDelta) {
            return (ModelDelta)nodeOrNodes;
        }
        if (nodeOrNodes instanceof ModelDelta[]) {
            return ((ModelDelta[])nodeOrNodes)[0];
        }
        return null;
    }

    public ModelDelta getChildDelta(Object element, int index) {
        Object nodeOrNodes;
        if (this.fNodesMap == null) {
            this.mapNodes();
        }
        if ((nodeOrNodes = this.fNodesMap.get(element)) instanceof ModelDelta) {
            ModelDelta node = (ModelDelta)nodeOrNodes;
            if (index == node.getIndex()) {
                return node;
            }
        } else if (nodeOrNodes instanceof ModelDelta[]) {
            ModelDelta[] nodes = (ModelDelta[])nodeOrNodes;
            int i = 0;
            while (i < nodes.length) {
                if (index == nodes[i].getIndex()) {
                    return nodes[i];
                }
                ++i;
            }
        }
        return null;
    }

    private void mapNodes() {
        if (this.fNodesList == null) {
            this.fNodesMap = new HashMap<Object, Object>(1);
            return;
        }
        this.fNodesMap = new HashMap<Object, Object>(this.fNodesList.size() * 4 / 3);
        int i = 0;
        while (i < this.fNodesList.size()) {
            this.mapNode(this.fNodesList.get(i));
            ++i;
        }
    }

    private void mapNode(ModelDelta node) {
        Object oldValue = this.fNodesMap.put(node.getElement(), node);
        if (oldValue instanceof ModelDelta) {
            ModelDelta[] nodes = new ModelDelta[]{(ModelDelta)oldValue, node};
            this.fNodesMap.put(node.getElement(), nodes);
        } else if (oldValue instanceof ModelDelta[]) {
            ModelDelta[] oldNodes = (ModelDelta[])oldValue;
            ModelDelta[] newNodes = new ModelDelta[oldNodes.length + 1];
            System.arraycopy(oldNodes, 0, newNodes, 0, oldNodes.length);
            newNodes[newNodes.length - 1] = node;
            this.fNodesMap.put(node.getElement(), newNodes);
        }
    }

    public ModelDelta addNode(Object element, Object replacement, int flags) {
        ModelDelta node = new ModelDelta(element, replacement, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public ModelDelta addNode(Object element, int index, int flags) {
        ModelDelta node = new ModelDelta(element, index, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public ModelDelta addNode(Object element, int index, int flags, int numChildren) {
        ModelDelta node = new ModelDelta(element, index, flags, numChildren);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    void setParent(ModelDelta node) {
        this.fParent = node;
    }

    @Override
    public IModelDelta getParentDelta() {
        return this.fParent;
    }

    @Override
    public Object getReplacementElement() {
        return this.fReplacement;
    }

    @Override
    public int getIndex() {
        return this.fIndex;
    }

    @Override
    public IModelDelta[] getChildDeltas() {
        if (this.fNodes == null) {
            this.fNodes = this.fNodesList.toArray(new ModelDelta[this.fNodesList.size()]);
        }
        return this.fNodes;
    }

    private void addDelta(ModelDelta delta) {
        if (this.fNodesList == null) {
            this.fNodesList = new ArrayList<ModelDelta>(4);
        }
        this.fNodesList.add(delta);
        this.fNodes = null;
        if (this.fNodesMap != null) {
            this.mapNode(delta);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Model Delta Start\n");
        this.appendDetail("  ", buf, this);
        buf.append("Model Delta End\n");
        return buf.toString();
    }

    private void appendDetail(String indent, StringBuilder buf, IModelDelta delta) {
        buf.append(indent);
        buf.append("Element: ");
        buf.append(delta.getElement());
        buf.append('\n');
        buf.append(indent);
        buf.append("    Flags: ");
        int flags = delta.getFlags();
        if (flags == 0) {
            buf.append("NO_CHANGE");
        } else {
            if ((flags & 1) > 0) {
                buf.append("ADDED | ");
            }
            if ((flags & 0x400) > 0) {
                buf.append("CONTENT | ");
            }
            if ((flags & 0x2000000) > 0) {
                buf.append("COLLAPSE | ");
            }
            if ((flags & 0x100000) > 0) {
                buf.append("EXPAND | ");
            }
            if ((flags & 0x10) > 0) {
                buf.append("INSERTED | ");
            }
            if ((flags & 2) > 0) {
                buf.append("REMOVED | ");
            }
            if ((flags & 8) > 0) {
                buf.append("REPLACED | ");
            }
            if ((flags & 0x200000) > 0) {
                buf.append("SELECT | ");
            }
            if ((flags & 0x800) > 0) {
                buf.append("STATE | ");
            }
            if ((flags & 0x400000) > 0) {
                buf.append("INSTALL | ");
            }
            if ((flags & 0x800000) > 0) {
                buf.append("UNINSTALL | ");
            }
            if ((flags & 0x1000000) > 0) {
                buf.append("REVEAL | ");
            }
            if ((flags & 0x4000000) > 0) {
                buf.append("FORCE | ");
            }
        }
        buf.append('\n');
        buf.append(indent);
        buf.append("    Index: ");
        buf.append(delta.getIndex());
        buf.append(" Child Count: ");
        buf.append(delta.getChildCount());
        buf.append('\n');
        IModelDelta[] nodes = delta.getChildDeltas();
        int i = 0;
        while (i < nodes.length) {
            this.appendDetail(String.valueOf(indent) + "  ", buf, nodes[i]);
            ++i;
        }
    }

    @Override
    public int getChildCount() {
        return this.fChildCount;
    }

    @Override
    public void accept(IModelDeltaVisitor visitor) {
        this.doAccept(visitor, 0);
    }

    protected void doAccept(IModelDeltaVisitor visitor, int depth) {
        if (visitor.visit(this, depth)) {
            IModelDelta[] childDeltas = this.getChildDeltas();
            int i = 0;
            while (i < childDeltas.length) {
                ((ModelDelta)childDeltas[i]).doAccept(visitor, depth + 1);
                ++i;
            }
        }
    }

    public void setElement(Object element) {
        this.fElement = element;
    }

    public void setFlags(int flags) {
        this.fFlags = flags;
    }

    public void setIndex(int index) {
        this.fIndex = index;
    }

    public void setChildCount(int count) {
        this.fChildCount = count;
    }
}

