/**********************************************************************
 * Copyright (c) 2019 Ericsson
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************/

package org.eclipse.tracecompass.tmf.core.model;

import java.util.Map;

/**
 * Style Model returned by a data provider. The model contains a map of
 * {@link OutputElementStyle} attached to a style key.
 *
 * @author Simon Delisle
 * @since 5.2
 */
public class OutputStyleModel {

    private Map<String, OutputElementStyle> fStyles;

    /**
     * Constructor.
     *
     * @param styleMap
     *            Style map for this model. The map contains a style key
     *            associated to the a specific style. Style key is a string that
     *            is generated by a data provider and used in different elements
     *            (ex. tree entries, time graph states, XY series) that can be
     *            returned by this provider.
     */
    public OutputStyleModel(Map<String, OutputElementStyle> styleMap) {
        fStyles = styleMap;
    }

    /**
     * Get the style map associated to this model
     *
     * @return Style map
     */
    public Map<String, OutputElementStyle> getStyles() {
        return fStyles;
    }

}
