/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.utils.FileUtils;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.tracecompass.tmf.core.model.TmfCommonXAxisModel;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;
import org.eclipse.ui.IViewPart;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.swtchart.Chart;
import org.swtchart.IBarSeries;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public abstract class XYDataProviderBaseTest {
    protected static SWTWorkbenchBot fBot;
    private static final Logger fLogger;
    protected static final String TRACE_PROJECT_NAME = "test";
    private static Gson fGson;
    private SWTBotView fViewBot;
    private Chart fChart;

    static {
        fLogger = Logger.getRootLogger();
        fGson = new GsonBuilder().setPrettyPrinting().create();
    }

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", fBot);
        SWTBotUtils.createProject(TRACE_PROJECT_NAME);
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void tearDown() {
        SWTBotUtils.deleteProject(TRACE_PROJECT_NAME, fBot);
        fLogger.removeAllAppenders();
    }

    @Before
    public void setup() {
        SWTBotUtils.openView(this.getViewID());
        this.fViewBot = fBot.viewById(this.getViewID());
        this.fViewBot.show();
        Matcher widgetOfType = WidgetOfType.widgetOfType(Chart.class);
        this.fChart = (Chart)this.fViewBot.bot().widget(widgetOfType);
        ITmfTrace trace = this.getTestTrace();
        File file = new File(trace.getPath());
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, file.getAbsolutePath(), trace.getTraceTypeId());
        SWTBotUtils.activateEditor(fBot, trace.getName());
    }

    @After
    public void after() {
        fBot.closeAllEditors();
        SWTBotUtils.closeSecondaryShells(fBot);
        this.disposeTestTrace();
    }

    private String getFullPath(String bundlePath) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            URL location = FileLocator.find((Bundle)bundle, (IPath)new Path(bundlePath), null);
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            return new File(uri).getAbsolutePath();
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            return null;
        }
    }

    protected boolean isChartDataValid(Chart chart, String expectedJson, String ... otherSeries) {
        String expected = FileUtils.read((String)this.getFullPath(expectedJson));
        TmfCommonXAxisModel model = this.extractModelFromChart(chart, otherSeries);
        String current = fGson.toJson((Object)model);
        return expected.equals(current);
    }

    protected TmfCommonXAxisModel extractModelFromChart(Chart chart, String ... otherSeries) {
        String mainSeriesName = this.getMainSeriesName();
        ISeries mainSeries = chart.getSeriesSet().getSeries(mainSeriesName);
        if (mainSeries == null) {
            System.out.println("Main Series " + mainSeriesName + " not found in chart");
            return null;
        }
        double[] xMain = mainSeries.getXSeries();
        double[] yMain = mainSeries.getYSeries();
        LinkedHashMap<@NonNull String, @NonNull YModel> yModels = new LinkedHashMap<String, YModel>();
        yModels.put(mainSeriesName, new YModel(-1L, mainSeriesName, Objects.requireNonNull(yMain)));
        String[] stringArray = otherSeries;
        int n = otherSeries.length;
        int n2 = 0;
        while (n2 < n) {
            String other = stringArray[n2];
            if (other != null) {
                ISeries series = chart.getSeriesSet().getSeries(other);
                if (series == null) {
                    System.out.println("Series " + other + " not found in chart");
                    return null;
                }
                double[] xSeries = series.getXSeries();
                double[] ySeries = series.getYSeries();
                if (!Arrays.equals(xMain, xSeries)) {
                    System.out.println("Series don't currently have the same x axis values");
                    return null;
                }
                yModels.put(other, new YModel(-1L, other, Objects.requireNonNull(ySeries)));
            }
            ++n2;
        }
        long[] x = Longs.toArray((Collection)Doubles.asList((double[])xMain));
        Assert.assertNotNull((Object)x);
        return new TmfCommonXAxisModel(this.getTitle(), x, yModels);
    }

    protected static TmfXYChartViewer getChartViewer(IViewPart viewPart) {
        if (viewPart instanceof TmfChartView) {
            return ((TmfChartView)viewPart).getChartViewer();
        }
        return null;
    }

    protected void verifySeriesStyle(String seriesName, ISeries.SeriesType expectedType, @Nullable RGB expectedColor, LineStyle expectedLineStyle, boolean isArea) {
        UIThreadRunnable.syncExec(() -> {});
        ISeries series = this.fChart.getSeriesSet().getSeries(seriesName);
        Assert.assertNotNull((Object)series);
        Assert.assertTrue((boolean)series.isVisible());
        Assert.assertEquals((Object)expectedType, (Object)series.getType());
        if (expectedType == ISeries.SeriesType.LINE) {
            ILineSeries line = (ILineSeries)series;
            if (expectedColor != null) {
                Assert.assertEquals((Object)expectedColor, (Object)line.getLineColor().getRGB());
            }
            Assert.assertEquals((Object)expectedLineStyle, (Object)line.getLineStyle());
            Assert.assertEquals((Object)isArea, (Object)line.isAreaEnabled());
        } else if (expectedType == ISeries.SeriesType.BAR) {
            IBarSeries bar = (IBarSeries)series;
            if (expectedColor != null) {
                Assert.assertEquals((Object)expectedColor, (Object)bar.getBarColor().getRGB());
            }
            Assert.assertTrue((boolean)bar.isStackEnabled());
        }
    }

    protected Chart getChart() {
        return this.fChart;
    }

    protected SWTBotView getSWTBotView() {
        return this.fViewBot;
    }

    protected abstract @NonNull String getMainSeriesName();

    protected abstract @NonNull String getTitle();

    protected abstract String getViewID();

    protected abstract ITmfTrace getTestTrace();

    protected abstract void disposeTestTrace();
}

