/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.views;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.QualitativePaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.SequentialPaletteProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ImageHelper;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.PalettedPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.StubPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.TimeGraphViewStub;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.ui.IWorkbenchPart;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TimeGraphViewTest {
    private static final Logger fLogger = Logger.getRootLogger();
    private static RGB fHair;
    private static RGB fHat;
    private static RGB fLaser;
    private static final int MIN_FILE_SIZE = 1000;
    private static final String SHOW_LEGEND = "Show Legend";
    private static final String LEGEND_NAME = "Legend";
    private static final String OK_BUTTON = "OK";
    private static final String EXPORT_MENU = "Export...";
    private static final String EXTENSION = ".png";
    private static final String REFERENCE_LOC = "reference";
    private static final String SKINNY_LOC = "skinny";
    private static final String RESET_LOC = "reset";
    private static final TmfTimeRange INITIAL_WINDOW_RANGE;
    private static final String LEGEND_ENTRY_KEY = "legend.entry.key";
    private static final String HAIR_ID = "HAIR";
    private static final String QUOTE_LASER_UNQUOTE = "\"LASER\"";
    private SWTBotView fViewBot;
    private SWTBotTimeGraph fTimeGraph;
    private TmfTraceStub fTrace;
    private Rectangle fBounds;
    private SWTWorkbenchBot fBot;
    private final ICondition fTimeGraphIsDirty = new ConditionHelper(this){

        public boolean test() throws Exception {
            SWTBotView viewBot = fViewBot;
            if (viewBot == null) {
                return false;
            }
            return this.getView().isDirty();
        }
    };

    static {
        INITIAL_WINDOW_RANGE = new TmfTimeRange(TmfTimestamp.fromNanos((long)20L), TmfTimestamp.fromNanos((long)100L));
    }

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fHair = ImageHelper.adjustExpectedColor(new RGB(0, 64, 128));
        fHat = ImageHelper.adjustExpectedColor(new RGB(0, 255, 0));
        fLaser = ImageHelper.adjustExpectedColor(new RGB(255, 0, 0));
    }

    @Before
    public void before() throws TmfTraceException {
        this.fBot = new SWTWorkbenchBot();
        this.fBot.closeAllEditors();
        for (SWTBotView viewBot : this.fBot.views()) {
            viewBot.close();
        }
        SWTBotUtils.openView("org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.timegraph.stub");
        this.fViewBot = this.fBot.viewById("org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.timegraph.stub");
        this.fViewBot.show();
        this.fTrace = new TmfTraceStub(){

            public @NonNull String getName() {
                return "Stub";
            }

            public TmfContext seekEvent(ITmfLocation location) {
                return new TmfContext();
            }
        };
        this.fTrace.setStartTime(TmfTimestamp.fromNanos((long)0L));
        this.fTrace.setEndTime(TmfTimestamp.fromNanos((long)180L));
        TmfTraceStub trace = this.fTrace;
        trace.initialize(null, "", ITmfEvent.class);
        Assert.assertNotNull((Object)trace);
        this.fTimeGraph = new SWTBotTimeGraph(this.fViewBot.bot());
        this.fViewBot.bot().waitUntil((ICondition)new TgConditionHelper(t -> this.fTimeGraph.getEntries().length == 0));
        this.fBounds = this.getBounds();
        UIThreadRunnable.syncExec(() -> TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null)));
        this.fViewBot.bot().waitUntil((ICondition)new TgConditionHelper(t -> this.fTimeGraph.getEntries().length >= 2));
        this.resetTimeRange();
        this.fBot.waitUntil((ICondition)new TgConditionHelper(t -> this.fViewBot.bot().slider().getThumb() > 1));
    }

    private void resetTimeRange() {
        TmfTimeRange fullTimeRange = this.fTrace.getTimeRange();
        TmfWindowRangeUpdatedSignal signal = new TmfWindowRangeUpdatedSignal((Object)this, INITIAL_WINDOW_RANGE);
        TimeGraphViewStub view = this.getView();
        this.fBot.waitUntil((ICondition)new TgConditionHelper(t -> {
            if (INITIAL_WINDOW_RANGE.equals((Object)view.getWindowRange())) {
                return true;
            }
            TmfSignalManager.dispatchSignal((TmfSignal)signal);
            return false;
        }));
        this.fBot.waitUntil((ICondition)new TgConditionHelper(t -> {
            if (fullTimeRange.equals((Object)view.getWindowRange())) {
                return true;
            }
            this.fViewBot.toolbarButton("Reset the Time Scale to Default").click();
            return false;
        }));
    }

    private Rectangle getBounds() {
        return (Rectangle)UIThreadRunnable.syncExec(() -> {
            Control control = (Control)this.fTimeGraph.widget;
            Rectangle ctrlRelativeBounds = control.getBounds();
            Point res = control.toDisplay(new Point(this.fTimeGraph.getNameSpace(), 0));
            ctrlRelativeBounds.width -= this.fTimeGraph.getNameSpace();
            ctrlRelativeBounds.x = res.x;
            ctrlRelativeBounds.y = res.y;
            return ctrlRelativeBounds;
        });
    }

    private TimeGraphViewStub getView() {
        IWorkbenchPart part = this.fViewBot.getViewReference().getPart(true);
        Assert.assertTrue((String)part.getClass().getCanonicalName(), (boolean)(part instanceof TimeGraphViewStub));
        TimeGraphViewStub stubView = (TimeGraphViewStub)part;
        return stubView;
    }

    @After
    public void after() {
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        SWTBotShell legendShell = this.fBot.shell(LEGEND_NAME);
        SWTBot legendBot = legendShell.bot();
        int i = 0;
        while (i < StubPresentationProvider.STATES.length) {
            SWTBotButton resetButton = legendBot.button(i);
            if (resetButton.isEnabled()) {
                resetButton.click();
            }
            ++i;
        }
        legendBot.button(OK_BUTTON).click();
        TmfTraceStub trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        UIThreadRunnable.syncExec(() -> TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceClosedSignal((Object)this, (ITmfTrace)trace)));
        this.fBot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.fViewBot.close();
        this.fBot.waitUntil(ConditionHelpers.viewIsClosed(this.fViewBot));
        this.fTrace.dispose();
    }

    @AfterClass
    public static void afterClass() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        bot.closeAllEditors();
        fLogger.removeAllAppenders();
    }

    @Test
    public void testLegendArrow() {
        this.resetTimeRange();
        Rectangle bounds = this.fBounds;
        ImageHelper ref = ImageHelper.grabImage(bounds);
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        SWTBotShell legendShell = this.fBot.shell(LEGEND_NAME);
        legendShell.activate();
        SWTBot legendBot = legendShell.bot();
        Assert.assertFalse((boolean)legendBot.buttonWithId(LEGEND_ENTRY_KEY, (Object)QUOTE_LASER_UNQUOTE).isEnabled());
        int defaultValue = legendBot.scaleWithId(LEGEND_ENTRY_KEY, QUOTE_LASER_UNQUOTE).getValue();
        legendBot.scaleWithId(LEGEND_ENTRY_KEY, QUOTE_LASER_UNQUOTE).setValue(100);
        Assert.assertTrue((boolean)legendBot.buttonWithId(LEGEND_ENTRY_KEY, (Object)QUOTE_LASER_UNQUOTE).isEnabled());
        legendShell.bot().button(OK_BUTTON).click();
        this.fBot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange();
        ImageHelper thick = ImageHelper.waitForNewImage(bounds, ref);
        int refCount = ref.getHistogram().count((Object)fLaser);
        int thickCount = thick.getHistogram().count((Object)fLaser);
        Assert.assertTrue((String)String.format("Count of \"\"LASER\"\" (%s) did not get change despite change of width before: %d after:%d histogram:%s", fLaser, refCount, thickCount, Multisets.copyHighestCountFirst(thick.getHistogram())), (thickCount > refCount ? 1 : 0) != 0);
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        legendShell = this.fBot.shell(LEGEND_NAME);
        legendBot = legendShell.bot();
        Assert.assertTrue((boolean)legendBot.buttonWithId(LEGEND_ENTRY_KEY, (Object)QUOTE_LASER_UNQUOTE).isEnabled());
        legendBot.buttonWithId(LEGEND_ENTRY_KEY, (Object)QUOTE_LASER_UNQUOTE).click();
        Assert.assertEquals((long)defaultValue, (long)legendBot.scaleWithId(LEGEND_ENTRY_KEY, QUOTE_LASER_UNQUOTE).getValue());
        Assert.assertFalse((boolean)legendBot.buttonWithId(LEGEND_ENTRY_KEY, (Object)QUOTE_LASER_UNQUOTE).isEnabled());
        legendBot.button(OK_BUTTON).click();
        this.fBot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange();
        ImageHelper reset = ImageHelper.waitForNewImage(bounds, thick);
        int resetCount = reset.getHistogram().count((Object)fLaser);
        Assert.assertEquals((String)"Count of \"\"LASER\"\" did not get change despite reset of width", (long)refCount, (long)resetCount);
    }

    @Test
    public void testEventStyling() {
        this.resetTimeRange();
        Rectangle bounds = this.fBounds;
        ImageHelper precollapse = ImageHelper.grabImage(bounds);
        SWTBotTimeGraph tg = this.fTimeGraph;
        tg.getEntry("Plumber guy").collapse();
        TimeGraphViewStub view = this.getView();
        ImageHelper ref = ImageHelper.waitForNewImage(bounds, precollapse);
        view.setFilterRegex("row?");
        UIThreadRunnable.syncExec(() -> view.restartZoomThread());
        ImageHelper highlighted = ImageHelper.waitForNewImage(bounds, ref);
        view.setFilterRegex(null);
        UIThreadRunnable.syncExec(() -> view.restartZoomThread());
        ImageHelper reset = ImageHelper.waitForNewImage(bounds, highlighted);
        ImageHelper diff = ref.diff(reset);
        Assert.assertTrue(((double)diff.getHistogram().count((Object)new RGB(0, 0, 0)) / (double)diff.getHistogram().size() > 0.99 ? 1 : 0) != 0);
        ImageHelper delta = highlighted.diff(reset);
        tg.expandAll();
        Assert.assertTrue((String)"Some highlighting", (delta.getHistogram().elementSet().size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testLegend() {
        this.resetTimeRange();
        Rectangle bounds = this.fBounds;
        ImageHelper ref = ImageHelper.grabImage(bounds);
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        SWTBotShell legendShell = this.fBot.shell(LEGEND_NAME);
        legendShell.activate();
        SWTBot legendBot = legendShell.bot();
        Assert.assertFalse((boolean)legendBot.buttonWithId(LEGEND_ENTRY_KEY, (Object)HAIR_ID).isEnabled());
        int defaultValue = legendBot.scaleWithId(LEGEND_ENTRY_KEY, HAIR_ID).getValue();
        legendBot.scaleWithId(LEGEND_ENTRY_KEY, HAIR_ID).setValue(25);
        Assert.assertTrue((boolean)legendBot.buttonWithId(LEGEND_ENTRY_KEY, (Object)HAIR_ID).isEnabled());
        legendShell.bot().button(OK_BUTTON).click();
        this.fBot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange();
        ImageHelper skinny = ImageHelper.waitForNewImage(bounds, ref);
        int refCount = ref.getHistogram().count((Object)fHair);
        int skinnyCount = skinny.getHistogram().count((Object)fHair);
        Assert.assertTrue((String)String.format("Count of \"\"HAIR\"\" (%s) did not get change despite change of width before: %d after:%d histogram:%s", fHair, refCount, skinnyCount, Multisets.copyHighestCountFirst(skinny.getHistogram())), (skinnyCount < refCount ? 1 : 0) != 0);
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        legendShell = this.fBot.shell(LEGEND_NAME);
        legendBot = legendShell.bot();
        Assert.assertTrue((boolean)legendBot.buttonWithId(LEGEND_ENTRY_KEY, (Object)HAIR_ID).isEnabled());
        legendBot.buttonWithId(LEGEND_ENTRY_KEY, (Object)HAIR_ID).click();
        Assert.assertEquals((long)defaultValue, (long)legendBot.scaleWithId(LEGEND_ENTRY_KEY, HAIR_ID).getValue());
        Assert.assertFalse((boolean)legendBot.buttonWithId(LEGEND_ENTRY_KEY, (Object)HAIR_ID).isEnabled());
        legendBot.button(OK_BUTTON).click();
        this.fBot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange();
        ImageHelper reset = ImageHelper.waitForNewImage(bounds, skinny);
        int resetCount = reset.getHistogram().count((Object)fHair);
        Assert.assertEquals((String)"Count of \"HAIR\" did not get change despite reset of width", (long)refCount, (long)resetCount);
    }

    @Ignore
    @Test
    public void testExport() throws IOException {
        this.resetTimeRange();
        File ref = File.createTempFile(REFERENCE_LOC, EXTENSION);
        File skinny = File.createTempFile(SKINNY_LOC, EXTENSION);
        File reset = File.createTempFile(RESET_LOC, EXTENSION);
        ref.deleteOnExit();
        skinny.deleteOnExit();
        reset.deleteOnExit();
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{ref.getAbsolutePath()});
        this.fViewBot.viewMenu(EXPORT_MENU).click();
        ImageHelper refImage = ImageHelper.fromFile(ref);
        this.fBot.waitUntil((ICondition)new FileWritten(ref, 1000));
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        SWTBotShell legendShell = this.fBot.shell(LEGEND_NAME);
        legendShell.activate();
        SWTBot legendBot = legendShell.bot();
        legendBot.scaleWithId(LEGEND_ENTRY_KEY, HAIR_ID).setValue(50);
        legendShell.bot().button(OK_BUTTON).click();
        this.fBot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange();
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{skinny.getAbsolutePath()});
        this.fViewBot.viewMenu(EXPORT_MENU).click();
        ImageHelper skinnyImage = ImageHelper.fromFile(skinny);
        this.fBot.waitUntil((ICondition)new FileWritten(skinny, 1000));
        int refCount = refImage.getHistogram().count((Object)fHair);
        int skinnyCount = skinnyImage.getHistogram().count((Object)fHair);
        Assert.assertTrue((String)String.format("Count of \"\"HAIR\"\" (%s) did not get change despite change of width before: %d after:%d histogram:%s", fHair, refCount, skinnyCount, Multisets.copyHighestCountFirst(skinnyImage.getHistogram())), (skinnyCount < refCount ? 1 : 0) != 0);
        this.fViewBot.toolbarButton(SHOW_LEGEND).click();
        legendShell = this.fBot.shell(LEGEND_NAME);
        legendBot = legendShell.bot();
        legendBot.buttonWithId(LEGEND_ENTRY_KEY, (Object)HAIR_ID).click();
        legendBot.button(OK_BUTTON).click();
        this.fBot.waitUntil(Conditions.shellCloses((SWTBotShell)legendShell));
        this.resetTimeRange();
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{reset.getAbsolutePath()});
        this.fViewBot.viewMenu(EXPORT_MENU).click();
        this.fBot.waitUntil((ICondition)new FileWritten(reset, 1000));
        ImageHelper resetImage = ImageHelper.fromFile(reset);
        int resetCount = resetImage.getHistogram().count((Object)fHair);
        Assert.assertEquals((String)"Count of \"HAIR\" did not get change despite reset of width", (long)refCount, (long)resetCount);
    }

    @Test
    public void testExpandAndCollapse() {
        String pg = "Plumber guy";
        String hpc = "Hungry pie chart";
        String element = "row2";
        int totalItems = 17;
        this.resetTimeRange();
        SWTBotTimeGraph timegraph = this.fTimeGraph;
        Assert.assertEquals((long)totalItems, (long)TimeGraphViewTest.getVisibleItems(timegraph));
        SWTBotTimeGraphEntry[] entries = null;
        entries = timegraph.getEntries();
        Assert.assertNotNull((Object)entries);
        Assert.assertNotNull((Object)((Object)timegraph.getEntry(hpc, element)));
        timegraph.collapseAll();
        entries = timegraph.getEntries();
        Assert.assertEquals((long)3L, (long)TimeGraphViewTest.getVisibleItems(timegraph));
        timegraph.getEntry(pg).select();
        TimeGraphViewTest.fireKey(timegraph, true, 43, new int[0]);
        Assert.assertEquals((long)10L, (long)TimeGraphViewTest.getVisibleItems(timegraph));
        timegraph.getEntry(pg).select();
        TimeGraphViewTest.fireKey(timegraph, true, 45, new int[0]);
        Assert.assertEquals((long)3L, (long)TimeGraphViewTest.getVisibleItems(timegraph));
        timegraph.getEntry(hpc).select();
        TimeGraphViewTest.fireKey(timegraph, true, 43, new int[0]);
        Assert.assertEquals((long)10L, (long)TimeGraphViewTest.getVisibleItems(timegraph));
        Assert.assertNotNull((Object)((Object)timegraph.getEntry(hpc, element)));
        timegraph.getEntry(pg).select();
        TimeGraphViewTest.fireKey(timegraph, true, 42, new int[0]);
        timegraph.getEntry(hpc).select();
        TimeGraphViewTest.fireKey(timegraph, true, 42, new int[0]);
        Assert.assertEquals((long)totalItems, (long)TimeGraphViewTest.getVisibleItems(timegraph));
        Assert.assertNotNull((Object)((Object)timegraph.getEntry(hpc, element)));
    }

    @Test
    public void testVerticalZoom() {
        this.resetTimeRange();
        int threshold = 10;
        SWTBotTimeGraph timegraph = this.fTimeGraph;
        Rectangle bounds = this.fBounds;
        ImageHelper ref = ImageHelper.grabImage(bounds);
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 43, 262144);
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 45, 262144);
        ImageHelper bigSmall = ImageHelper.grabImage(bounds);
        ImageHelper diff = ref.diff(bigSmall);
        threshold = (int)((double)diff.getHistogram().size() * 0.03);
        List<RGB> colors = TimeGraphViewTest.filter(diff.getHistogram(), threshold);
        Assert.assertEquals((String)colors.toString(), (long)1L, (long)colors.size());
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 43, 262144);
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 43, 262144);
        ImageHelper bigBig = ImageHelper.grabImage(bounds);
        diff = ref.diff(bigBig);
        colors = TimeGraphViewTest.filter(diff.getHistogram(), threshold);
        Assert.assertNotEquals((String)colors.toString(), (long)1L, (long)colors.size());
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 43, 262144);
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 45, 262144);
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 48, 262144);
        ImageHelper bigSmallReset = ImageHelper.grabImage(bounds);
        diff = ref.diff(bigSmallReset);
        colors = TimeGraphViewTest.filter(diff.getHistogram(), threshold);
        Assert.assertEquals((String)colors.toString(), (long)1L, (long)colors.size());
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 45, 262144);
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 45, 262144);
        ImageHelper smallSmall = ImageHelper.grabImage(bounds);
        diff = ref.diff(smallSmall);
        colors = TimeGraphViewTest.filter(diff.getHistogram(), threshold);
        Assert.assertNotEquals((String)colors.toString(), (long)1L, (long)colors.size());
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 45, 262144);
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 43, 262144);
        TimeGraphViewTest.fireKeyAndWait(timegraph, bounds, false, 48, 262144);
        ImageHelper smallBigReset = ImageHelper.grabImage(bounds);
        diff = ref.diff(smallBigReset);
        colors = TimeGraphViewTest.filter(diff.getHistogram(), threshold);
        Assert.assertEquals((String)colors.toString(), (long)1L, (long)colors.size());
    }

    private static List<RGB> filter(Multiset<RGB> histogram, int threshold) {
        return histogram.elementSet().stream().filter(e -> histogram.count(e) > threshold).collect(Collectors.toList());
    }

    @Test
    public void testHorizontalZoom() {
        this.resetTimeRange();
        SWTBotTimeGraph timegraph = this.fTimeGraph;
        TimeGraphViewStub view = this.getView();
        timegraph.setFocus();
        Assert.assertEquals((long)80L, (long)TimeGraphViewTest.getDuration(view.getWindowRange()));
        TimeGraphViewTest.fireKeyInGraph(timegraph, '=', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new WindowRangeCondition(view, 52L));
        TimeGraphViewTest.fireKeyInGraph(timegraph, '+', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new WindowRangeCondition(view, 34L));
        TimeGraphViewTest.fireKeyInGraph(timegraph, '-', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new WindowRangeCondition(view, 51L));
        TimeGraphViewTest.fireKeyInGraph(timegraph, '-', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new WindowRangeCondition(view, 77L));
        long previousRange = TimeGraphViewTest.getDuration(view.getWindowRange());
        TimeGraphViewTest.fireKeyInGraph(timegraph, 'w', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new WindowRangeUpdatedCondition(view, previousRange, false));
        previousRange = TimeGraphViewTest.getDuration(view.getWindowRange());
        TimeGraphViewTest.fireKeyInGraph(timegraph, 's', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new WindowRangeUpdatedCondition(view, previousRange, true));
    }

    @Test
    public void testKeyboardNamespaceNavigation() {
        String pg = "Plumber guy";
        this.resetTimeRange();
        SWTBotTimeGraph timegraph = this.fTimeGraph;
        timegraph.getEntry(pg).select();
        TimeGraphViewTest.fireKey(timegraph, true, 0x1000002, new int[0]);
        Assert.assertEquals((Object)"[Hat1]", (Object)timegraph.selection().get(0).toString());
        TimeGraphViewTest.fireKey(timegraph, true, 0x1000002, new int[0]);
        Assert.assertEquals((Object)"[Hat2]", (Object)timegraph.selection().get(0).toString());
        TimeGraphViewTest.fireKey(timegraph, true, 0x1000002, new int[0]);
        Assert.assertEquals((Object)"[Head1]", (Object)timegraph.selection().get(0).toString());
        TimeGraphViewTest.fireKey(timegraph, true, 0x1000001, new int[0]);
        Assert.assertEquals((Object)"[Hat2]", (Object)timegraph.selection().get(0).toString());
        TimeGraphViewTest.fireKey(timegraph, true, 0x1000002, new int[0]);
        Assert.assertEquals((Object)"[Head1]", (Object)timegraph.selection().get(0).toString());
        TimeGraphViewTest.fireKey(timegraph, true, 0x1000007, new int[0]);
        Assert.assertEquals((Object)(String.valueOf('[') + pg + ']'), (Object)timegraph.selection().get(0).toString());
        TimeGraphViewTest.fireKey(timegraph, true, 0x1000006, new int[0]);
        Assert.assertNotEquals((Object)(String.valueOf('[') + pg + ']'), (Object)timegraph.selection().get(0).toString());
        TimeGraphViewTest.fireKey(timegraph, true, 0x1000005, new int[0]);
        Assert.assertEquals((Object)(String.valueOf('[') + pg + ']'), (Object)timegraph.selection().get(0).toString());
        TimeGraphViewTest.fireKey(timegraph, true, 0x1000008, new int[0]);
        Assert.assertEquals((Object)"[pulse]", (Object)timegraph.selection().get(0).toString());
        TimeGraphViewTest.fireKey(timegraph, true, 0x1000007, new int[0]);
        Assert.assertEquals((Object)(String.valueOf('[') + pg + ']'), (Object)timegraph.selection().get(0).toString());
    }

    @Test
    public void testCollapseExpandUsingEnter() {
        String pg = "Plumber guy";
        this.resetTimeRange();
        SWTBotTimeGraph timegraph = this.fTimeGraph;
        Assert.assertEquals((long)0L, (long)timegraph.selection().columnCount());
        timegraph.getEntry(pg).select();
        Assert.assertEquals((long)1L, (long)timegraph.selection().columnCount());
        Assert.assertEquals((long)17L, (long)TimeGraphViewTest.getVisibleItems(timegraph));
        TimeGraphViewTest.fireKey(timegraph, true, 13, new int[0]);
        Assert.assertEquals((long)1L, (long)timegraph.selection().columnCount());
        Assert.assertEquals((Object)(String.valueOf('[') + pg + ']'), (Object)timegraph.selection().get(0).toString());
        Assert.assertEquals((long)10L, (long)TimeGraphViewTest.getVisibleItems(timegraph));
        TimeGraphViewTest.fireKey(timegraph, true, 13, new int[0]);
        Assert.assertEquals((long)1L, (long)timegraph.selection().columnCount());
        Assert.assertEquals((Object)(String.valueOf('[') + pg + ']'), (Object)timegraph.selection().get(0).toString());
        Assert.assertEquals((long)17L, (long)TimeGraphViewTest.getVisibleItems(timegraph));
        timegraph.getEntry(pg, "Hat1").select();
        TimeGraphViewTest.fireKey(timegraph, true, 13, new int[0]);
        Assert.assertEquals((long)1L, (long)timegraph.selection().columnCount());
        Assert.assertEquals((Object)"[Hat1]", (Object)timegraph.selection().get(0).toString());
        Assert.assertEquals((long)17L, (long)TimeGraphViewTest.getVisibleItems(timegraph));
    }

    @Test
    public void testTimeLine() {
        String lines = "pulse";
        this.resetTimeRange();
        SWTBotTimeGraph timegraph = this.fTimeGraph;
        Assert.assertEquals((long)0L, (long)timegraph.selection().columnCount());
        ImageHelper currentImage = ImageHelper.waitForNewImage(this.fBounds, null);
        SWTBotTimeGraphEntry entry = timegraph.getEntry(lines);
        entry = timegraph.getEntry(lines).select();
        ImageHelper.waitForNewImage(this.fBounds, currentImage);
        Rectangle rect = entry.absoluteLocation();
        ImageHelper image = ImageHelper.grabImage(rect);
        ImmutableMultiset ms = Multisets.copyHighestCountFirst(image.getHistogram());
        int black = ms.count((Object)new RGB(0, 0, 0));
        RGB bgColor = (RGB)ms.elementSet().iterator().next();
        int bgCount = ms.count((Object)bgColor);
        float actual = (float)black / (float)bgCount;
        Assert.assertEquals((float)0.113f, (float)actual, (float)0.05f);
    }

    @Test
    @Ignore
    public void testZoomToSelection() {
        this.resetTimeRange();
        SWTBotTimeGraph timegraph = this.fTimeGraph;
        TimeGraphViewStub view = this.getView();
        timegraph.setFocus();
        Assert.assertEquals((long)80L, (long)TimeGraphViewTest.getDuration(view.getWindowRange()));
        ITmfTimestamp selStartTime = TmfTimestamp.fromNanos((long)30L);
        ITmfTimestamp selEndTime = TmfTimestamp.fromNanos((long)80L);
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, selStartTime, selEndTime));
        this.timeGraphIsReadyCondition(new TmfTimeRange(selStartTime, selEndTime));
        TimeGraphViewTest.fireKeyInGraph(timegraph, 'z', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new WindowRangeCondition(view, 50L));
    }

    @Test
    public void testKeyboardNavigation() {
        this.resetTimeRange();
        SWTBotTimeGraph timegraph = this.fTimeGraph;
        TimeGraphViewStub view = this.getView();
        timegraph.setFocus();
        Assert.assertEquals((long)80L, (long)TimeGraphViewTest.getDuration(view.getWindowRange()));
        TmfTimeRange updatedWindowRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)40L), TmfTimestamp.fromNanos((long)120L));
        TimeGraphViewTest.fireKeyInGraph(timegraph, 'd', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new TgConditionHelper(t -> updatedWindowRange.equals((Object)view.getWindowRange())));
        TimeGraphViewTest.fireKeyInGraph(timegraph, 'a', new int[0]);
        this.fViewBot.bot().waitUntil((ICondition)new TgConditionHelper(t -> INITIAL_WINDOW_RANGE.equals((Object)view.getWindowRange())));
    }

    private static long getDuration(TmfTimeRange refRange) {
        return refRange.getEndTime().toNanos() - refRange.getStartTime().toNanos();
    }

    private static void fireKeyAndWait(SWTBotTimeGraph timegraph, Rectangle bounds, boolean inNameSpace, int c, int ... modifiers) {
        ImageHelper ref = ImageHelper.grabImage(bounds);
        TimeGraphViewTest.fireKey(timegraph, inNameSpace, c, modifiers);
        ImageHelper.waitForNewImage(bounds, ref);
    }

    private static void fireKey(SWTBotTimeGraph timegraph, boolean inNameSpace, int c, int ... modifiers) {
        Event event = new Event();
        event.widget = timegraph.widget;
        if ((c & 0x1000000) == 0 && c != 13) {
            event.character = (char)c;
        } else {
            event.keyCode = c;
        }
        event.doit = true;
        UIThreadRunnable.syncExec(() -> {
            event.display = Display.getCurrent();
            TimeGraphViewTest.resetMousePosition(timegraph, inNameSpace, new MouseEvent(event));
            KeyEvent e = new KeyEvent(event);
            int[] nArray2 = modifiers;
            int n = modifiers.length;
            int n2 = 0;
            while (n2 < n) {
                int modifier = nArray2[n2];
                e.stateMask |= modifier;
                ++n2;
            }
            ((TimeGraphControl)sWTBotTimeGraph.widget).keyPressed(e);
        });
        UIThreadRunnable.syncExec(() -> {
            event.display = Display.getCurrent();
            TimeGraphViewTest.resetMousePosition(timegraph, inNameSpace, new MouseEvent(event));
            KeyEvent e = new KeyEvent(event);
            int[] nArray2 = modifiers;
            int n = modifiers.length;
            int n2 = 0;
            while (n2 < n) {
                int modifier = nArray2[n2];
                e.stateMask |= modifier;
                ++n2;
            }
            ((TimeGraphControl)sWTBotTimeGraph.widget).keyReleased(e);
        });
    }

    private static void fireKeyInGraph(SWTBotTimeGraph timegraph, char c, int ... modifiers) {
        timegraph.setFocus();
        timegraph.moveMouseToWidget();
        int mask = 0;
        int[] nArray = modifiers;
        int n = modifiers.length;
        int n2 = 0;
        while (n2 < n) {
            int modifier = nArray[n2];
            mask |= modifier;
            ++n2;
        }
        timegraph.pressShortcut(mask, c);
    }

    private static void resetMousePosition(SWTBotTimeGraph timegraph, boolean inNs, MouseEvent mouseEvent) {
        Rectangle rect = ((TimeGraphControl)timegraph.widget).getBounds();
        mouseEvent.x = !inNs ? rect.width - 1 : 1;
        mouseEvent.y = rect.height / 2 + rect.y;
        ((TimeGraphControl)timegraph.widget).mouseMove(mouseEvent);
    }

    @Ignore
    @Test
    public void testPalettes() {
        this.resetTimeRange();
        TimeGraphViewStub view = this.getView();
        Rectangle bounds = this.fBounds;
        final IPaletteProvider paletteBlue = SequentialPaletteProvider.create((RGBAColor)new RGBAColor(35, 103, 243, 255), (int)5);
        UIThreadRunnable.syncExec(() -> view.setPresentationProvider(new PalettedPresentationProvider(){

            @Override
            public IPaletteProvider getPalette() {
                return paletteBlue;
            }
        }));
        List rgbs = Lists.transform((List)paletteBlue.get(), a -> RGBAUtil.fromInt((int)a.toInt()).rgb);
        this.fViewBot.bot().waitUntil((ICondition)new PaletteIsPresent(rgbs, bounds));
        final IPaletteProvider paletteGreen = SequentialPaletteProvider.create((RGBAColor)new RGBAColor(35, 243, 103, 255), (int)5);
        UIThreadRunnable.syncExec(() -> view.setPresentationProvider(new PalettedPresentationProvider(){

            @Override
            public IPaletteProvider getPalette() {
                return paletteGreen;
            }
        }));
        rgbs = Lists.transform((List)paletteGreen.get(), a -> RGBAUtil.fromInt((int)a.toInt()).rgb);
        this.fViewBot.bot().waitUntil((ICondition)new PaletteIsPresent(rgbs, bounds));
        QualitativePaletteProvider rotating = new QualitativePaletteProvider.Builder().setAttenuation(0.5f).setBrightness(1.0f).setNbColors(4).build();
        UIThreadRunnable.syncExec(() -> this.lambda$19(view, (IPaletteProvider)rotating));
        rgbs = Lists.transform((List)rotating.get(), a -> RGBAUtil.fromInt((int)a.toInt()).rgb);
        this.fViewBot.bot().waitUntil((ICondition)new PaletteIsPresent(rgbs, bounds));
    }

    @Test
    public void testTimegraphEventFiltering() {
        SWTWorkbenchBot bot = this.fBot;
        this.resetTimeRange();
        SWTBot viewBot = this.fViewBot.bot();
        SWTBotTimeGraph timegraph = this.fTimeGraph;
        Assert.assertTrue((String)"timegraph visible", (boolean)timegraph.isVisible());
        timegraph.setFocus();
        Rectangle bounds = this.fBounds;
        ImageHelper ref = ImageHelper.grabImage(bounds);
        timegraph.setFocus();
        timegraph.moveMouseToWidget();
        timegraph.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((int)47)});
        SWTBotShell dialogShell = viewBot.shell("Time Event Filter").activate();
        SWTBot shellBot = dialogShell.bot();
        SWTBotText text = shellBot.text();
        text.setText("Hat1");
        bot.waitWhile(this.fTimeGraphIsDirty);
        timegraph.setFocus();
        ImageHelper filtered = ImageHelper.waitForNewImage(bounds, ref);
        int refHatCount = ref.getHistogram().count((Object)fHat);
        int filteredHatCount = filtered.getHistogram().count((Object)fHat);
        int refHairCount = ref.getHistogram().count((Object)fHair);
        int filteredHairCount = filtered.getHistogram().count((Object)fHair);
        Assert.assertTrue((String)"Count of \"HAT\" did not decrease to non-zero", (filteredHatCount < refHatCount && filteredHatCount > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Count of \"HAIR\" did not decrease to zero", (filteredHairCount < refHairCount && filteredHairCount == 0 ? 1 : 0) != 0);
        int count = TimeGraphViewTest.getVisibleItems(timegraph);
        dialogShell = viewBot.shell("Time Event Filter").activate();
        shellBot = dialogShell.bot();
        text = shellBot.text();
        text.setFocus();
        SWTBotUtils.pressShortcut(text, new KeyStroke[]{Keystrokes.CR});
        bot.waitWhile(this.fTimeGraphIsDirty);
        int newCount = TimeGraphViewTest.getVisibleItems(timegraph);
        Assert.assertTrue((String)("Fewer entries should be visible here. Current value is " + newCount + " previous was " + count), (newCount < count ? 1 : 0) != 0);
    }

    private static int getVisibleItems(final SWTBotTimeGraph timegraph) {
        return (Integer)UIThreadRunnable.syncExec((Display)Display.getDefault(), (Result)new IntResult(){

            public Integer run() {
                ITimeGraphEntry[] expandedElements;
                int count = 0;
                TimeGraphControl control = (TimeGraphControl)timegraph.widget;
                ITimeGraphEntry[] iTimeGraphEntryArray = expandedElements = control.getExpandedElements();
                int n = expandedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    ITimeGraphEntry entry = iTimeGraphEntryArray[n2];
                    Rectangle itemBounds = control.getItemBounds(entry);
                    if (itemBounds.height > 0) {
                        ++count;
                    }
                    ++n2;
                }
                return count;
            }
        });
    }

    private void timeGraphIsReadyCondition(@NonNull TmfTimeRange selectionRange) {
        IWorkbenchPart part = this.fViewBot.getViewReference().getPart(false);
        this.fBot.waitUntil(ConditionHelpers.timeGraphIsReadyCondition((AbstractTimeGraphView)part, selectionRange, selectionRange.getEndTime()));
    }

    private /* synthetic */ void lambda$19(TimeGraphViewStub timeGraphViewStub, final IPaletteProvider iPaletteProvider) {
        timeGraphViewStub.setPresentationProvider(new PalettedPresentationProvider(){

            @Override
            public IPaletteProvider getPalette() {
                return iPaletteProvider;
            }
        });
    }

    private abstract class ConditionHelper
    implements ICondition {
        private ConditionHelper() {
        }

        public final String getFailureMessage() {
            return null;
        }

        public final void init(SWTBot bot) {
        }
    }

    class FileWritten
    extends ConditionHelper {
        private File fFile;
        private int fAmount;

        public FileWritten(File file, int amount) {
            this.fFile = file;
            this.fAmount = amount;
        }

        public boolean test() throws Exception {
            return this.fFile.length() >= (long)this.fAmount;
        }
    }

    private static class PaletteIsPresent
    extends DefaultCondition {
        private String fFailureMessage;
        private List<RGB> fRgbs;
        private Rectangle fRect;

        public PaletteIsPresent(List<RGB> rgbs, Rectangle bounds) {
            this.fRgbs = rgbs;
            this.fRect = bounds;
        }

        public boolean test() throws Exception {
            ImageHelper image = ImageHelper.grabImage(this.fRect);
            if (image == null) {
                this.fFailureMessage = "Grabbed image is null";
                return false;
            }
            Multiset<RGB> histogram = image.getHistogram();
            for (RGB rgb : this.fRgbs) {
                if (histogram.count((Object)rgb) > 0) continue;
                this.fFailureMessage = "Color not found: " + rgb;
                return false;
            }
            return true;
        }

        public String getFailureMessage() {
            return this.fFailureMessage;
        }
    }

    private class TgConditionHelper
    extends ConditionHelper {
        private final Predicate<Object> fTestLogic;

        public TgConditionHelper(Predicate<Object> testLogic) {
            Assert.assertNotNull(testLogic);
            this.fTestLogic = testLogic;
        }

        public final boolean test() throws Exception {
            if (!TimeGraphViewTest.this.fTimeGraphIsDirty.test()) {
                return true;
            }
            return this.fTestLogic.test(null);
        }
    }

    private class WindowRangeCondition
    extends DefaultCondition {
        TimeGraphViewStub fView;
        long fExpectedRange;

        public WindowRangeCondition(TimeGraphViewStub view, long expectedRange) {
            this.fView = view;
            this.fExpectedRange = expectedRange;
        }

        public boolean test() throws Exception {
            return TimeGraphViewTest.getDuration(this.fView.getWindowRange()) == this.fExpectedRange;
        }

        public String getFailureMessage() {
            return "Expected window range (" + this.fExpectedRange + ") not achieved. Actual=" + TimeGraphViewTest.getDuration(this.fView.getWindowRange());
        }
    }

    private class WindowRangeUpdatedCondition
    extends DefaultCondition {
        TimeGraphViewStub fView;
        long fPreviousRange;
        boolean fIsIncreased;

        public WindowRangeUpdatedCondition(TimeGraphViewStub view, long previousRange, boolean increased) {
            this.fView = view;
            this.fPreviousRange = previousRange;
            this.fIsIncreased = increased;
        }

        public boolean test() throws Exception {
            long newRange = TimeGraphViewTest.getDuration(this.fView.getWindowRange());
            if (this.fIsIncreased) {
                return newRange > this.fPreviousRange;
            }
            return newRange < this.fPreviousRange;
        }

        public String getFailureMessage() {
            return "Window range didn't " + (this.fIsIncreased ? "increase" : "decrease") + " (previous: " + this.fPreviousRange + ", actual: " + TimeGraphViewTest.getDuration(this.fView.getWindowRange()) + ")";
        }
    }
}

