/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTBCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMTBHOTITEM;
import org.eclipse.swt.internal.win32.NMTOOLBAR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTON;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    int lastFocusId;
    int lastArrowId;
    int lastHotId;
    ToolItem[] items;
    ToolItem[] tabItemList;
    boolean ignoreResize;
    boolean ignoreMouse;
    ImageList imageList;
    ImageList disabledImageList;
    ImageList hotImageList;
    static final long ToolBarProc;
    static final TCHAR ToolBarClass;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;

    static {
        ToolBarClass = new TCHAR(0, "ToolbarWindow32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, ToolBarClass, lpWndClass);
        ToolBarProc = lpWndClass.lpfnWndProc;
    }

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        if ((style & 0x200) != 0) {
            this.style |= 0x200;
            int bits = OS.GetWindowLong(this.handle, -16);
            if (OS.IsAppThemed() && (style & 0x20000) != 0) {
                bits |= 0x1000;
            }
            OS.SetWindowLong(this.handle, -16, bits | 0x80);
        } else {
            this.style |= 0x100;
        }
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        if (msg == 262) {
            return OS.DefWindowProc(hwnd, msg, wParam, lParam);
        }
        return OS.CallWindowProc(ToolBarProc, hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        if ((style & 0x800000) == 0) {
            style |= 0x80000;
        }
        if ((style & 0x200) != 0) {
            style &= 0xFFFFFFBF;
        }
        return style & 0xFFFFFCFF;
    }

    @Override
    void checkBuffered() {
        super.checkBuffered();
        this.style |= 0x20000000;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        int width = 0;
        int height = 0;
        if ((this.style & 0x200) != 0) {
            RECT rect = new RECT();
            TBBUTTON lpButton = new TBBUTTON();
            int count = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
            int i = 0;
            while (i < count) {
                OS.SendMessage(this.handle, 1053, (long)i, rect);
                height = Math.max(height, rect.bottom);
                OS.SendMessage(this.handle, 1047, (long)i, lpButton);
                if ((lpButton.fsStyle & 1) != 0) {
                    TBBUTTONINFO info = new TBBUTTONINFO();
                    info.cbSize = TBBUTTONINFO.sizeof;
                    info.dwMask = 64;
                    OS.SendMessage(this.handle, 1087, (long)lpButton.idCommand, info);
                    width = Math.max(width, info.cx);
                } else {
                    width = Math.max(width, rect.right);
                }
                ++i;
            }
        } else {
            RECT oldRect = new RECT();
            OS.GetWindowRect(this.handle, oldRect);
            int oldWidth = oldRect.right - oldRect.left;
            int oldHeight = oldRect.bottom - oldRect.top;
            int border = this.getBorderWidthInPixels();
            int newWidth = wHint == -1 ? 16383 : wHint + border * 2;
            int newHeight = hHint == -1 ? 16383 : hHint + border * 2;
            boolean redraw = this.getDrawing() && OS.IsWindowVisible(this.handle);
            this.ignoreResize = true;
            if (redraw) {
                OS.UpdateWindow(this.handle);
            }
            int flags = 30;
            OS.SetWindowPos(this.handle, 0L, 0, 0, newWidth, newHeight, flags);
            int count = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
            if (count != 0) {
                RECT rect = new RECT();
                OS.SendMessage(this.handle, 1053, (long)(count - 1), rect);
                width = Math.max(width, rect.right);
                height = Math.max(height, rect.bottom);
            }
            OS.SetWindowPos(this.handle, 0L, 0, 0, oldWidth, oldHeight, flags);
            if (redraw) {
                OS.ValidateRect(this.handle, null);
            }
            this.ignoreResize = false;
        }
        if (width == 0) {
            width = 24;
        }
        if (height == 0) {
            height = 22;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrimInPixels(0, 0, width, height);
        width = trim.width;
        height = trim.height;
        return new Point(width, height);
    }

    @Override
    Rectangle computeTrimInPixels(int x, int y, int width, int height) {
        Rectangle trim = super.computeTrimInPixels(x, y, width, height);
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0x40) == 0) {
            trim.height += 2;
        }
        return trim;
    }

    @Override
    Widget computeTabGroup() {
        int index;
        ToolItem[] items = this._getItems();
        if (this.tabItemList == null) {
            int i = 0;
            while (i < items.length && items[i].control == null) {
                ++i;
            }
            if (i == items.length) {
                return super.computeTabGroup();
            }
        }
        if ((index = (int)OS.SendMessage(this.handle, 1095, 0L, 0L)) == -1) {
            index = this.lastHotId;
        }
        while (index >= 0) {
            ToolItem item = items[index];
            if (item.isTabGroup()) {
                return item;
            }
            --index;
        }
        return super.computeTabGroup();
    }

    @Override
    Widget[] computeTabList() {
        ToolItem[] list;
        ToolItem[] items = this._getItems();
        if (this.tabItemList == null) {
            int i = 0;
            while (i < items.length && items[i].control == null) {
                ++i;
            }
            if (i == items.length) {
                return super.computeTabList();
            }
        }
        Widget[] result = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return result;
        }
        ToolItem[] toolItemArray = list = this.tabList != null ? this._getTabItemList() : items;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem child = toolItemArray[n2];
            Widget[] childList = child.computeTabList();
            if (childList.length != 0) {
                Widget[] newResult = new Widget[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++n2;
        }
        if (result.length == 0) {
            result = new Widget[]{this};
        }
        return result;
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        if ((this.style & 0x800000) != 0 && !OS.IsAppThemed()) {
            int bits = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, bits &= 0xFFFF7FFF);
        }
        long hFont = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, hFont, 0L);
        OS.SendMessage(this.handle, 1054, (long)TBBUTTON.sizeof, 0L);
        OS.SendMessage(this.handle, 1056, 0L, 0L);
        OS.SendMessage(this.handle, 1055, 0L, 0L);
        int bits = 153;
        OS.SendMessage(this.handle, 1108, 0L, bits);
    }

    void createItem(ToolItem item, int index) {
        int count = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
        if (index < 0 || index > count) {
            this.error(6);
        }
        int id = 0;
        while (id < this.items.length && this.items[id] != null) {
            ++id;
        }
        if (id == this.items.length) {
            ToolItem[] newItems = new ToolItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        int bits = item.widgetStyle();
        TBBUTTON lpButton = new TBBUTTON();
        lpButton.idCommand = id;
        lpButton.fsStyle = (byte)bits;
        lpButton.fsState = (byte)4;
        if ((bits & 1) == 0) {
            lpButton.iBitmap = -2;
        }
        if (OS.SendMessage(this.handle, 1091, (long)index, lpButton) == 0L) {
            this.error(14);
        }
        item.id = id;
        this.items[item.id] = item;
        if ((this.style & 0x200) != 0) {
            this.setRowCount(count + 1);
        }
        this.layoutItems();
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.lastHotId = -1;
        this.lastArrowId = -1;
        this.lastFocusId = -1;
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    void destroyItem(ToolItem item) {
        TBBUTTONINFO info = new TBBUTTONINFO();
        info.cbSize = TBBUTTONINFO.sizeof;
        info.dwMask = 9;
        int index = (int)OS.SendMessage(this.handle, 1087, (long)item.id, info);
        if ((info.fsStyle & 1) == 0 && info.iImage != -2) {
            if (this.imageList != null) {
                this.imageList.put(info.iImage, null);
            }
            if (this.hotImageList != null) {
                this.hotImageList.put(info.iImage, null);
            }
            if (this.disabledImageList != null) {
                this.disabledImageList.put(info.iImage, null);
            }
        }
        OS.SendMessage(this.handle, 1046, (long)index, 0L);
        if (item.id == this.lastFocusId) {
            this.lastFocusId = -1;
        }
        if (item.id == this.lastArrowId) {
            this.lastArrowId = -1;
        }
        if (item.id == this.lastHotId) {
            this.lastHotId = -1;
        }
        this.items[item.id] = null;
        item.id = -1;
        int count = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
        if (count == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 1072, 0L, 0L);
                this.display.releaseToolImageList(this.imageList);
            }
            if (this.hotImageList != null) {
                OS.SendMessage(this.handle, 1076, 0L, 0L);
                this.display.releaseToolHotImageList(this.hotImageList);
            }
            if (this.disabledImageList != null) {
                OS.SendMessage(this.handle, 1078, 0L, 0L);
                this.display.releaseToolDisabledImageList(this.disabledImageList);
            }
            this.disabledImageList = null;
            this.hotImageList = null;
            this.imageList = null;
            this.items = new ToolItem[4];
        }
        if ((this.style & 0x200) != 0) {
            this.setRowCount(count - 1);
        }
        this.layoutItems();
    }

    @Override
    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        ToolItem[] toolItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            if (item != null && (item.style & 2) == 0) {
                item.updateImages(enabled && item.getEnabled());
            }
            ++n2;
        }
    }

    ImageList getDisabledImageList() {
        return this.disabledImageList;
    }

    ImageList getHotImageList() {
        return this.hotImageList;
    }

    ImageList getImageList() {
        return this.imageList;
    }

    public ToolItem getItem(int index) {
        TBBUTTON lpButton;
        long result;
        this.checkWidget();
        int count = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        if ((result = OS.SendMessage(this.handle, 1047, (long)index, lpButton = new TBBUTTON())) == 0L) {
            this.error(8);
        }
        return this.items[lpButton.idCommand];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.getItemInPixels(DPIUtil.autoScaleUp(point));
    }

    ToolItem getItemInPixels(Point point) {
        ToolItem[] toolItemArray = this.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            Rectangle rect = item.getBoundsInPixels();
            if (rect.contains(point)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        int count = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
        TBBUTTON lpButton = new TBBUTTON();
        ToolItem[] result = new ToolItem[count];
        int i = 0;
        while (i < count) {
            OS.SendMessage(this.handle, 1047, (long)i, lpButton);
            result[i] = this.items[lpButton.idCommand];
            ++i;
        }
        return result;
    }

    public int getRowCount() {
        this.checkWidget();
        if ((this.style & 0x200) != 0) {
            return (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
        }
        return (int)OS.SendMessage(this.handle, 1064, 0L, 0L);
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int count = 0;
        ToolItem[] toolItemArray = this.tabItemList;
        int n = this.tabItemList.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            if (!item.isDisposed()) {
                ++count;
            }
            ++n2;
        }
        if (count == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] newList = new ToolItem[count];
        int index = 0;
        ToolItem[] toolItemArray2 = this.tabItemList;
        int n3 = this.tabItemList.length;
        int n4 = 0;
        while (n4 < n3) {
            ToolItem item = toolItemArray2[n4];
            if (!item.isDisposed()) {
                newList[index++] = item;
            }
            ++n4;
        }
        this.tabItemList = newList;
        return this.tabItemList;
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        return (int)OS.SendMessage(this.handle, 1049, (long)item.id, 0L);
    }

    void layoutItems() {
        int bits;
        int itemCount;
        int n;
        int n2;
        ToolItem[] toolItemArray;
        if (OS.IsAppThemed() && (this.style & 0x20000) != 0 && (this.style & 0x200) == 0) {
            int oldBits;
            boolean hasText = false;
            boolean hasImage = false;
            toolItemArray = this.items;
            n2 = this.items.length;
            n = 0;
            while (n < n2) {
                ToolItem item = toolItemArray[n];
                if (item != null) {
                    if (!hasText) {
                        boolean bl = hasText = item.text.length() != 0;
                    }
                    if (!hasImage) {
                        boolean bl = hasImage = item.image != null;
                    }
                    if (hasText && hasImage) break;
                }
                ++n;
            }
            int newBits = oldBits = OS.GetWindowLong(this.handle, -16);
            newBits = hasText && hasImage ? (newBits |= 0x1000) : (newBits &= 0xFFFFEFFF);
            if (newBits != oldBits) {
                this.setDropDownItems(false);
                OS.SetWindowLong(this.handle, -16, newBits);
                long hFont = OS.SendMessage(this.handle, 49, 0L, 0L);
                OS.SendMessage(this.handle, 48, hFont, 0L);
                this.setDropDownItems(true);
            }
        }
        if ((this.style & 0x40) != 0) {
            OS.SendMessage(this.handle, 1057, 0L, 0L);
        }
        if ((this.style & 0x200) != 0 && (itemCount = (int)OS.SendMessage(this.handle, 1048, 0L, 0L)) > 1) {
            ToolItem item;
            TBBUTTONINFO info = new TBBUTTONINFO();
            info.cbSize = TBBUTTONINFO.sizeof;
            info.dwMask = 64;
            long size = OS.SendMessage(this.handle, 1082, 0L, 0L);
            info.cx = (short)OS.LOWORD(size);
            int index = 0;
            int extraPadding = 0;
            while (index < this.items.length) {
                item = this.items[index];
                if (item != null && (item.style & 4) != 0) {
                    extraPadding = 1;
                    break;
                }
                ++index;
            }
            if (index < this.items.length) {
                long padding = OS.SendMessage(this.handle, 1110, 0L, 0L);
                info.cx = (short)(info.cx + OS.LOWORD(padding + (long)extraPadding) * 2);
            }
            ToolItem[] toolItemArray2 = this.items;
            int n3 = this.items.length;
            int n4 = 0;
            while (n4 < n3) {
                item = toolItemArray2[n4];
                if (item != null && (item.style & 2) == 0) {
                    OS.SendMessage(this.handle, 1088, (long)item.id, info);
                }
                ++n4;
            }
        }
        if ((this.style & 0x240) != 0 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x1000) != 0) {
            TBBUTTONINFO info = new TBBUTTONINFO();
            info.cbSize = TBBUTTONINFO.sizeof;
            info.dwMask = 64;
            toolItemArray = this.items;
            n2 = this.items.length;
            n = 0;
            while (n < n2) {
                ToolItem item = toolItemArray[n];
                if (item != null && item.cx > 0) {
                    info.cx = item.cx;
                    OS.SendMessage(this.handle, 1088, (long)item.id, info);
                }
                ++n;
            }
        }
        ToolItem[] toolItemArray3 = this.items;
        int n5 = this.items.length;
        int n6 = 0;
        while (n6 < n5) {
            ToolItem item = toolItemArray3[n6];
            if (item != null) {
                item.resizeControl();
            }
            ++n6;
        }
    }

    @Override
    boolean mnemonicHit(char ch) {
        int[] id = new int[1];
        if (OS.SendMessage(this.handle, 1114, (long)ch, id) == 0L) {
            return false;
        }
        if ((this.style & 0x800000) != 0 && !this.setTabGroupFocus()) {
            return false;
        }
        int index = (int)OS.SendMessage(this.handle, 1049, (long)id[0], 0L);
        if (index == -1) {
            return false;
        }
        OS.SendMessage(this.handle, 1096, (long)index, 0L);
        this.items[id[0]].click(false);
        return true;
    }

    @Override
    boolean mnemonicMatch(char ch) {
        int[] id = new int[1];
        if (OS.SendMessage(this.handle, 1114, (long)ch, id) == 0L) {
            return false;
        }
        int index = (int)OS.SendMessage(this.handle, 1049, (long)id[0], 0L);
        if (index == -1) {
            return false;
        }
        return this.findMnemonic(this.items[id[0]].text) != '\u0000';
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            ToolItem[] toolItemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n2;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 1072, 0L, 0L);
            this.display.releaseToolImageList(this.imageList);
        }
        if (this.hotImageList != null) {
            OS.SendMessage(this.handle, 1076, 0L, 0L);
            this.display.releaseToolHotImageList(this.hotImageList);
        }
        if (this.disabledImageList != null) {
            OS.SendMessage(this.handle, 1078, 0L, 0L);
            this.display.releaseToolDisabledImageList(this.disabledImageList);
        }
        this.disabledImageList = null;
        this.hotImageList = null;
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] toolItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            if (item != null && item.control == control) {
                item.setControl(null);
            }
            ++n2;
        }
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            ToolItem[] toolItemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                if (item != null) {
                    item.reskin(flags);
                }
                ++n2;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    void setBackgroundImage(long hBitmap) {
        super.setBackgroundImage(hBitmap);
        this.setBackgroundTransparent(hBitmap != 0L);
    }

    @Override
    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        this.setBackgroundTransparent(pixel != -1);
    }

    void setBackgroundTransparent(boolean transparent) {
        if ((this.style & 0x800000) != 0 && !OS.IsAppThemed()) {
            int bits = OS.GetWindowLong(this.handle, -16);
            bits = !transparent && this.findBackgroundControl() == null ? (bits &= 0xFFFF7FFF) : (bits |= 0x8000);
            OS.SetWindowLong(this.handle, -16, bits);
        }
    }

    @Override
    void setBoundsInPixels(int x, int y, int width, int height, int flags) {
        if (this.parent.lpwp != null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
            this.parent.setResizeChildren(false);
            this.parent.setResizeChildren(true);
        }
        super.setBoundsInPixels(x, y, width, height, flags);
    }

    @Override
    void setDefaultFont() {
        super.setDefaultFont();
        OS.SendMessage(this.handle, 1056, 0L, 0L);
        OS.SendMessage(this.handle, 1055, 0L, 0L);
    }

    void setDropDownItems(boolean set) {
        if (OS.IsAppThemed()) {
            ToolItem item;
            boolean hasText = false;
            boolean hasImage = false;
            ToolItem[] toolItemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                item = toolItemArray[n2];
                if (item != null) {
                    if (!hasText) {
                        boolean bl = hasText = item.text.length() != 0;
                    }
                    if (!hasImage) {
                        boolean bl = hasImage = item.image != null;
                    }
                    if (hasText && hasImage) break;
                }
                ++n2;
            }
            if (hasImage && !hasText) {
                toolItemArray = this.items;
                n = this.items.length;
                n2 = 0;
                while (n2 < n) {
                    item = toolItemArray[n2];
                    if (item != null && (item.style & 4) != 0) {
                        TBBUTTONINFO info = new TBBUTTONINFO();
                        info.cbSize = TBBUTTONINFO.sizeof;
                        info.dwMask = 8;
                        OS.SendMessage(this.handle, 1087, (long)item.id, info);
                        info.fsStyle = set ? (byte)(info.fsStyle | 8) : (byte)(info.fsStyle & 0xFFFFFFF7);
                        OS.SendMessage(this.handle, 1088, (long)item.id, info);
                    }
                    ++n2;
                }
            }
        }
    }

    void setDisabledImageList(ImageList imageList) {
        if (this.disabledImageList == imageList) {
            return;
        }
        long hImageList = 0L;
        this.disabledImageList = imageList;
        if (this.disabledImageList != null) {
            hImageList = this.disabledImageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1078, 0L, hImageList);
        this.setDropDownItems(true);
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        this.setDropDownItems(false);
        super.setFont(font);
        this.setDropDownItems(true);
        int index = 0;
        int mask = 60;
        while (index < this.items.length) {
            ToolItem item = this.items[index];
            if (item != null && (item.style & mask) != 0) break;
            ++index;
        }
        if (index == this.items.length) {
            OS.SendMessage(this.handle, 1056, 0L, 0L);
            OS.SendMessage(this.handle, 1055, 0L, 0L);
        }
        this.layoutItems();
    }

    void setHotImageList(ImageList imageList) {
        if (this.hotImageList == imageList) {
            return;
        }
        long hImageList = 0L;
        this.hotImageList = imageList;
        if (this.hotImageList != null) {
            hImageList = this.hotImageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1076, 0L, hImageList);
        this.setDropDownItems(true);
    }

    void setImageList(ImageList imageList) {
        if (this.imageList == imageList) {
            return;
        }
        long hImageList = 0L;
        this.imageList = imageList;
        if (this.imageList != null) {
            hImageList = imageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1072, 0L, hImageList);
        this.setDropDownItems(true);
    }

    @Override
    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (!super.setParent(parent)) {
            return false;
        }
        long hwndParent = parent.handle;
        OS.SendMessage(this.handle, 1061, hwndParent, 0L);
        long hwndShell = parent.getShell().handle;
        long hwndToolTip = OS.SendMessage(this.handle, 1059, 0L, 0L);
        OS.SetWindowLongPtr(hwndToolTip, -8, hwndShell);
        return true;
    }

    @Override
    public void setRedraw(boolean redraw) {
        this.checkWidget();
        this.setDropDownItems(false);
        super.setRedraw(redraw);
        this.setDropDownItems(true);
    }

    void setRowCount(int count) {
        if ((this.style & 0x200) != 0) {
            RECT rect = new RECT();
            OS.GetWindowRect(this.handle, rect);
            OS.MapWindowPoints(0L, this.parent.handle, rect, 2);
            this.ignoreResize = true;
            OS.SendMessage(this.handle, 1063, OS.MAKEWPARAM(count += 2, 1), 0L);
            int flags = 22;
            OS.SetWindowPos(this.handle, 0L, 0, 0, rect.right - rect.left, rect.bottom - rect.top, flags);
            this.ignoreResize = false;
        }
    }

    void setTabItemList(ToolItem[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            ToolItem[] toolItemArray = tabList;
            int n = tabList.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                if (item == null) {
                    this.error(5);
                }
                if (item.isDisposed()) {
                    this.error(5);
                }
                if (item.parent != this) {
                    this.error(32);
                }
                ++n2;
            }
            ToolItem[] newList = new ToolItem[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabItemList = tabList;
    }

    @Override
    boolean setTabItemFocus() {
        int index = 0;
        while (index < this.items.length) {
            ToolItem item = this.items[index];
            if (item != null && (item.style & 2) == 0 && item.getEnabled()) break;
            ++index;
        }
        if (index == this.items.length) {
            return false;
        }
        return super.setTabItemFocus();
    }

    @Override
    boolean updateTextDirection(int textDirection) {
        if (super.updateTextDirection(textDirection)) {
            ToolItem[] items = this._getItems();
            int i = items.length;
            while (i-- > 0) {
                items[i].updateTextDirection(this.style & Integer.MIN_VALUE);
            }
            return true;
        }
        return false;
    }

    @Override
    String toolTipText(NMTTDISPINFO hdr) {
        if ((hdr.uFlags & 1) != 0) {
            return null;
        }
        if (!this.hasCursor()) {
            return "";
        }
        int index = (int)hdr.idFrom;
        long hwndToolTip = OS.SendMessage(this.handle, 1059, 0L, 0L);
        if (hwndToolTip == hdr.hwndFrom) {
            ToolItem item;
            int flags = -2080374784;
            hdr.uFlags = (this.style & flags) != 0 && (this.style & flags) != flags ? (hdr.uFlags |= 4) : (hdr.uFlags &= 0xFFFFFFFB);
            if (this.toolTipText != null) {
                return "";
            }
            if (index >= 0 && index < this.items.length && (item = this.items[index]) != null) {
                if (this.lastArrowId != -1) {
                    return "";
                }
                return item.toolTipText;
            }
        }
        return super.toolTipText(hdr);
    }

    @Override
    void updateOrientation() {
        super.updateOrientation();
        if (this.imageList != null) {
            Point size = this.imageList.getImageSize();
            ImageList newImageList = this.display.getImageListToolBar(this.style & 0x4000000, size.x, size.y);
            ImageList newHotImageList = this.display.getImageListToolBarHot(this.style & 0x4000000, size.x, size.y);
            ImageList newDisabledImageList = this.display.getImageListToolBarDisabled(this.style & 0x4000000, size.x, size.y);
            TBBUTTONINFO info = new TBBUTTONINFO();
            info.cbSize = TBBUTTONINFO.sizeof;
            info.dwMask = 1;
            int count = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
            int i = 0;
            while (i < count) {
                ToolItem item = this.items[i];
                if ((item.style & 2) == 0 && item.image != null) {
                    OS.SendMessage(this.handle, 1087, (long)item.id, info);
                    if (info.iImage != -2) {
                        Image image = this.imageList.get(info.iImage);
                        Image hot = this.hotImageList.get(info.iImage);
                        Image disabled = this.disabledImageList.get(info.iImage);
                        this.imageList.put(info.iImage, null);
                        this.hotImageList.put(info.iImage, null);
                        this.disabledImageList.put(info.iImage, null);
                        info.iImage = newImageList.add(image);
                        newHotImageList.add(hot);
                        newDisabledImageList.add(disabled);
                        OS.SendMessage(this.handle, 1088, (long)item.id, info);
                    }
                }
                ++i;
            }
            this.display.releaseToolImageList(this.imageList);
            this.display.releaseToolHotImageList(this.hotImageList);
            this.display.releaseToolDisabledImageList(this.disabledImageList);
            OS.SendMessage(this.handle, 1072, 0L, newImageList.getHandle());
            OS.SendMessage(this.handle, 1076, 0L, newHotImageList.getHandle());
            OS.SendMessage(this.handle, 1078, 0L, newDisabledImageList.getHandle());
            this.imageList = newImageList;
            this.hotImageList = newHotImageList;
            this.disabledImageList = newDisabledImageList;
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle() | 4 | 0x100 | 0x2000;
        if (OS.IsAppThemed()) {
            bits |= 0x8000;
        }
        if ((this.style & 8) == 0) {
            bits |= 0x40;
        }
        if ((this.style & 0x40) != 0) {
            bits |= 0x200;
        }
        if ((this.style & 0x800000) != 0) {
            bits |= 0x800;
        }
        if (!OS.IsAppThemed() && (this.style & 0x20000) != 0) {
            bits |= 0x1000;
        }
        return bits;
    }

    @Override
    TCHAR windowClass() {
        return ToolBarClass;
    }

    @Override
    long windowProc() {
        return ToolBarProc;
    }

    @Override
    LRESULT WM_CAPTURECHANGED(long wParam, long lParam) {
        LRESULT result = super.WM_CAPTURECHANGED(wParam, lParam);
        if (result != null) {
            return result;
        }
        ToolItem[] toolItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            int fsState;
            ToolItem item = toolItemArray[n2];
            if (item != null && ((fsState = (int)OS.SendMessage(this.handle, 1042, (long)item.id, 0L)) & 2) != 0) {
                OS.SendMessage(this.handle, 1041, (long)item.id, fsState &= 0xFFFFFFFD);
            }
            ++n2;
        }
        return result;
    }

    @Override
    LRESULT WM_CHAR(long wParam, long lParam) {
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch ((int)wParam) {
            case 32: {
                TBBUTTON lpButton;
                long code;
                int index = (int)OS.SendMessage(this.handle, 1095, 0L, 0L);
                if (index == -1 || (code = OS.SendMessage(this.handle, 1047, (long)index, lpButton = new TBBUTTON())) == 0L) break;
                this.items[lpButton.idCommand].click(false);
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    @Override
    LRESULT WM_COMMAND(long wParam, long lParam) {
        LRESULT result = super.WM_COMMAND(wParam, lParam);
        if (result != null) {
            return result;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_GETDLGCODE(long wParam, long lParam) {
        LRESULT result = super.WM_GETDLGCODE(wParam, lParam);
        if (result != null) {
            return result;
        }
        return new LRESULT(8193L);
    }

    @Override
    LRESULT WM_KEYDOWN(long wParam, long lParam) {
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch ((int)wParam) {
            case 32: {
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    @Override
    LRESULT WM_KILLFOCUS(long wParam, long lParam) {
        TBBUTTON lpButton;
        int index = (int)OS.SendMessage(this.handle, 1095, 0L, 0L);
        long code = OS.SendMessage(this.handle, 1047, (long)index, lpButton = new TBBUTTON());
        if (code != 0L) {
            this.lastFocusId = lpButton.idCommand;
        }
        return super.WM_KILLFOCUS(wParam, lParam);
    }

    @Override
    LRESULT WM_LBUTTONDOWN(long wParam, long lParam) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONDOWN(wParam, lParam);
    }

    @Override
    LRESULT WM_LBUTTONUP(long wParam, long lParam) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONUP(wParam, lParam);
    }

    @Override
    LRESULT WM_MOUSELEAVE(long wParam, long lParam) {
        LRESULT result = super.WM_MOUSELEAVE(wParam, lParam);
        if (result != null) {
            return result;
        }
        TOOLINFO lpti = new TOOLINFO();
        lpti.cbSize = TOOLINFO.sizeof;
        long hwndToolTip = OS.SendMessage(this.handle, 1059, 0L, 0L);
        if (OS.SendMessage(hwndToolTip, 1083, 0L, lpti) != 0L && (lpti.uFlags & 1) == 0) {
            OS.SendMessage(hwndToolTip, 1075, 0L, lpti);
            OS.SendMessage(hwndToolTip, 1074, 0L, lpti);
        }
        return result;
    }

    @Override
    LRESULT WM_MOUSEMOVE(long wParam, long lParam) {
        if (OS.GetMessagePos() != this.display.lastMouse) {
            this.lastArrowId = -1;
        }
        return super.WM_MOUSEMOVE(wParam, lParam);
    }

    @Override
    LRESULT WM_NOTIFY(long wParam, long lParam) {
        LRESULT result = super.WM_NOTIFY(wParam, lParam);
        if (result != null) {
            return result;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_SETFOCUS(long wParam, long lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if (this.lastFocusId != -1 && this.handle == OS.GetFocus()) {
            int index = (int)OS.SendMessage(this.handle, 1049, (long)this.lastFocusId, 0L);
            OS.SendMessage(this.handle, 1096, (long)index, 0L);
        }
        return result;
    }

    @Override
    LRESULT WM_SIZE(long wParam, long lParam) {
        if (this.ignoreResize) {
            long code = this.callWindowProc(this.handle, 5, wParam, lParam);
            if (code == 0L) {
                return LRESULT.ZERO;
            }
            return new LRESULT(code);
        }
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (this.isDisposed()) {
            return result;
        }
        if ((this.style & 0x800) != 0 && (this.style & 0x40) != 0) {
            RECT windowRect = new RECT();
            OS.GetWindowRect(this.handle, windowRect);
            int index = 0;
            int border = this.getBorderWidthInPixels() * 2;
            RECT rect = new RECT();
            int count = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
            while (index < count) {
                OS.SendMessage(this.handle, 1053, (long)index, rect);
                OS.MapWindowPoints(this.handle, 0L, rect, 2);
                if (rect.right > windowRect.right - border * 2) break;
                ++index;
            }
            int bits = (int)OS.SendMessage(this.handle, 1109, 0L, 0L);
            bits = index == count ? (bits |= 0x10) : (bits &= 0xFFFFFFEF);
            OS.SendMessage(this.handle, 1108, 0L, bits);
        }
        this.layoutItems();
        return result;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(long wParam, long lParam) {
        LRESULT result = super.WM_WINDOWPOSCHANGING(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.ignoreResize) {
            return result;
        }
        if (!this.getDrawing()) {
            return result;
        }
        if ((this.style & 0x40) == 0) {
            return result;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return result;
        }
        if (OS.SendMessage(this.handle, 1064, 0L, 0L) == 1L) {
            return result;
        }
        WINDOWPOS lpwp = new WINDOWPOS();
        OS.MoveMemory(lpwp, lParam, WINDOWPOS.sizeof);
        if ((lpwp.flags & 9) != 0) {
            return result;
        }
        RECT oldRect = new RECT();
        OS.GetClientRect(this.handle, oldRect);
        RECT newRect = new RECT();
        OS.SetRect(newRect, 0, 0, lpwp.cx, lpwp.cy);
        OS.SendMessage(this.handle, 131, 0L, newRect);
        int oldWidth = oldRect.right - oldRect.left;
        int newWidth = newRect.right - newRect.left;
        if (newWidth > oldWidth) {
            RECT rect = new RECT();
            int newHeight = newRect.bottom - newRect.top;
            OS.SetRect(rect, oldWidth - 2, 0, oldWidth, newHeight);
            OS.InvalidateRect(this.handle, rect, false);
        }
        return result;
    }

    @Override
    LRESULT wmCommandChild(long wParam, long lParam) {
        ToolItem child = this.items[OS.LOWORD(wParam)];
        if (child == null) {
            return null;
        }
        return child.wmCommandChild(wParam, lParam);
    }

    private boolean customDrawing() {
        return this.hasCustomBackground() || this.hasCustomForeground() && OS.IsWindowEnabled(this.handle);
    }

    @Override
    LRESULT wmNotifyChild(NMHDR hdr, long wParam, long lParam) {
        switch (hdr.code) {
            case -710: {
                NMTOOLBAR lpnmtb = new NMTOOLBAR();
                OS.MoveMemory(lpnmtb, lParam, NMTOOLBAR.sizeof);
                ToolItem child = this.items[lpnmtb.iItem];
                if (child == null) break;
                Event event = new Event();
                event.detail = 4;
                int index = (int)OS.SendMessage(this.handle, 1049, (long)lpnmtb.iItem, 0L);
                RECT rect = new RECT();
                OS.SendMessage(this.handle, 1053, (long)index, rect);
                event.setLocationInPixels(rect.left, rect.bottom);
                child.sendSelectionEvent(13, event, false);
                break;
            }
            case -12: {
                NMTBCUSTOMDRAW nmcd = new NMTBCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMTBCUSTOMDRAW.sizeof);
                switch (nmcd.dwDrawStage) {
                    case 3: {
                        int bits = OS.GetWindowLong(this.handle, -16);
                        if ((bits & 0x800) == 0) {
                            this.drawBackground(nmcd.hdc);
                        } else {
                            RECT rect = new RECT();
                            OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                            this.drawBackground(nmcd.hdc, rect);
                        }
                        return new LRESULT(4L);
                    }
                    case 1: {
                        return new LRESULT(this.customDrawing() ? 32 : 0);
                    }
                    case 65537: {
                        if (this.customDrawing()) {
                            nmcd.clrBtnFace = this.getBackgroundPixel();
                            nmcd.clrText = this.getForegroundPixel();
                            OS.MoveMemory(lParam, nmcd, NMTBCUSTOMDRAW.sizeof);
                            return new LRESULT(0x800000L);
                        }
                        return new LRESULT(0L);
                    }
                }
                break;
            }
            case -713: {
                NMTBHOTITEM lpnmhi = new NMTBHOTITEM();
                OS.MoveMemory(lpnmhi, lParam, NMTBHOTITEM.sizeof);
                switch (lpnmhi.dwFlags) {
                    case 1: {
                        if (this.lastArrowId == -1) break;
                        return LRESULT.ONE;
                    }
                    case 2: {
                        RECT client = new RECT();
                        OS.GetClientRect(this.handle, client);
                        int index = (int)OS.SendMessage(this.handle, 1049, (long)lpnmhi.idNew, 0L);
                        RECT rect = new RECT();
                        OS.SendMessage(this.handle, 1053, (long)index, rect);
                        if (rect.right > client.right || rect.bottom > client.bottom) {
                            return LRESULT.ONE;
                        }
                        this.lastArrowId = lpnmhi.idNew;
                        break;
                    }
                    default: {
                        this.lastArrowId = -1;
                    }
                }
                if ((lpnmhi.dwFlags & 0x20) != 0) break;
                this.lastHotId = lpnmhi.idNew;
            }
        }
        return super.wmNotifyChild(hdr, wParam, lParam);
    }
}

