/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.Disk;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputAnalysisModule;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.DiskUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.xy.AbstractTreeCommonXDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class DisksIODataProvider
extends AbstractTreeCommonXDataProvider<InputOutputAnalysisModule, TmfTreeDataModel> {
    protected static final String PROVIDER_TITLE = Objects.requireNonNull(Messages.DisksIODataProvider_title);
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.DisksIODataProvider";

    public static @Nullable DisksIODataProvider create(ITmfTrace trace) {
        InputOutputAnalysisModule module = (InputOutputAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, InputOutputAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.inputoutput");
        if (module != null) {
            module.schedule();
            return new DisksIODataProvider(trace, module);
        }
        return null;
    }

    private DisksIODataProvider(ITmfTrace trace, InputOutputAnalysisModule module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
    }

    public String getId() {
        return ID;
    }

    protected TmfTreeModel<TmfTreeDataModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) {
        ArrayList<TmfTreeDataModel> nodes = new ArrayList<TmfTreeDataModel>();
        long rootId = this.getId(-1);
        nodes.add(new TmfTreeDataModel(rootId, -1L, Collections.singletonList(this.getTrace().getName())));
        String readName = Objects.requireNonNull(Messages.DisksIODataProvider_read);
        String writeName = Objects.requireNonNull(Messages.DisksIODataProvider_write);
        for (Integer diskQuark : ss.getQuarks(new String[]{"Disks", "*"})) {
            int writeQuark;
            String diskName = DiskUtils.getDiskName(ss, diskQuark);
            long diskId = this.getId(diskQuark);
            nodes.add(new TmfTreeDataModel(diskId, rootId, Collections.singletonList(diskName)));
            int readQuark = ss.optQuarkRelative(diskQuark.intValue(), new String[]{"sectors_read"});
            if (readQuark != -2) {
                nodes.add(new TmfTreeDataModel(this.getId(readQuark), diskId, Collections.singletonList(readName)));
            }
            if ((writeQuark = ss.optQuarkRelative(diskQuark.intValue(), new String[]{"sectors_written"})) == -2) continue;
            nodes.add(new TmfTreeDataModel(this.getId(writeQuark), diskId, Collections.singletonList(writeName)));
        }
        return new TmfTreeModel(Collections.emptyList(), nodes);
    }

    protected @Nullable Map<String, IYModel> getYModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return null;
        }
        long[] xValues = filter.getTimesRequested();
        List<DiskBuilder> builders = this.initBuilders(ss, filter);
        if (builders.isEmpty()) {
            return Collections.emptyMap();
        }
        long currentEnd = ss.getCurrentEndTime();
        long prevTime = filter.getStart();
        if (prevTime >= ss.getStartTime() && prevTime <= currentEnd) {
            List states = ss.queryFullState(prevTime);
            for (DiskBuilder entry : builders) {
                entry.setPrevCount(Disk.extractCount(entry.fSectorQuark, ss, states, prevTime));
            }
        }
        int i = 1;
        while (i < xValues.length) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            long time = xValues[i];
            if (time > currentEnd) break;
            if (time >= ss.getStartTime()) {
                List states = ss.queryFullState(time);
                for (DiskBuilder entry : builders) {
                    double count = Disk.extractCount(entry.fSectorQuark, ss, states, time);
                    entry.updateValue(i, count, time - prevTime);
                }
            }
            prevTime = time;
            ++i;
        }
        return Maps.uniqueIndex((Iterable)Iterables.transform(builders, DiskBuilder::access$2), IYModel::getName);
    }

    private List<DiskBuilder> initBuilders(ITmfStateSystem ss, SelectionTimeQueryFilter filter) {
        int length = filter.getTimesRequested().length;
        ArrayList<DiskBuilder> builders = new ArrayList<DiskBuilder>();
        for (Map.Entry entry : this.getSelectedEntries(filter).entrySet()) {
            String name;
            long id = (Long)entry.getKey();
            int quark = (Integer)entry.getValue();
            if (ss.getAttributeName(quark).equals("sectors_read")) {
                name = String.valueOf(this.getTrace().getName()) + '/' + DiskUtils.getDiskName(ss, ss.getParentAttributeQuark(quark)) + "/read";
                builders.add(new DiskBuilder(id, quark, name, length));
                continue;
            }
            if (!ss.getAttributeName(quark).equals("sectors_written")) continue;
            name = String.valueOf(this.getTrace().getName()) + '/' + DiskUtils.getDiskName(ss, ss.getParentAttributeQuark(quark)) + "/write";
            builders.add(new DiskBuilder(id, quark, name, length));
        }
        return builders;
    }

    protected boolean isCacheable() {
        return true;
    }

    protected String getTitle() {
        return PROVIDER_TITLE;
    }

    private static final class DiskBuilder {
        private static final int BYTES_PER_SECTOR = 512;
        private static final double SECONDS_PER_NANOSECOND = 1.0E-9;
        private static final double RATIO = 5.1199999999999994E11;
        private final long fId;
        public final int fSectorQuark;
        private final String fName;
        private final double[] fValues;
        private double fPrevCount;

        private DiskBuilder(long id, int sectorQuark, String name, int length) {
            this.fId = id;
            this.fSectorQuark = sectorQuark;
            this.fName = name;
            this.fValues = new double[length];
        }

        private void setPrevCount(double prevCount) {
            this.fPrevCount = prevCount;
        }

        private void updateValue(int pos, double newCount, long deltaT) {
            this.fValues[pos] = (newCount - this.fPrevCount) * 5.1199999999999994E11 / (double)deltaT;
            this.fPrevCount = newCount;
        }

        private IYModel build() {
            return new YModel(this.fId, this.fName, this.fValues);
        }

        static /* synthetic */ IYModel access$2(DiskBuilder diskBuilder) {
            return diskBuilder.build();
        }
    }
}

