/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.segmentstore.core.arraylist.ArrayListStore;
import org.eclipse.tracecompass.internal.segmentstore.core.arraylist.LazyArrayListStore;
import org.eclipse.tracecompass.internal.segmentstore.core.segmentHistoryTree.HistoryTreeSegmentStore;
import org.eclipse.tracecompass.internal.segmentstore.core.treemap.TreeMapStore;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;

public final class SegmentStoreFactory<E> {
    private SegmentStoreFactory() {
    }

    public static <E extends ISegment> ISegmentStore<E> createSegmentStore(SegmentStoreType ... segmentTypes) {
        Set<@NonNull SegmentStoreType> segments = SegmentStoreFactory.getListOfFlags(segmentTypes);
        if (segments.contains((Object)SegmentStoreType.Distinct)) {
            return SegmentStoreFactory.createTreeMapStore();
        }
        if (segments.contains((Object)SegmentStoreType.Stable)) {
            return SegmentStoreFactory.createArrayListStore();
        }
        return SegmentStoreFactory.createLazyArrayListStore();
    }

    public static <E extends ISegment> ISegmentStore<E> createSegmentStore(Object[] array, SegmentStoreType ... segmentTypes) {
        Set<@NonNull SegmentStoreType> segments = SegmentStoreFactory.getListOfFlags(segmentTypes);
        if (segments.contains((Object)SegmentStoreType.Distinct)) {
            ISegmentStore<ISegment> store = SegmentStoreFactory.createTreeMapStore();
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object elem = objectArray[n2];
                if (elem instanceof ISegment) {
                    store.add((ISegment)elem);
                }
                ++n2;
            }
            return store;
        }
        if (segments.contains((Object)SegmentStoreType.Stable)) {
            return new ArrayListStore(array);
        }
        return new LazyArrayListStore(array);
    }

    @Deprecated
    public static <E extends ISegment> ISegmentStore<E> createOnDiskSegmentStore(Path segmentFile, IHTIntervalReader<E> segmentReader) throws IOException {
        return SegmentStoreFactory.createOnDiskSegmentStore(segmentFile, segmentReader, 1);
    }

    public static <E extends ISegment> ISegmentStore<E> createOnDiskSegmentStore(Path segmentFile, IHTIntervalReader<E> segmentReader, int version) throws IOException {
        return new HistoryTreeSegmentStore<E>(segmentFile, segmentReader, version);
    }

    private static Set<@NonNull SegmentStoreType> getListOfFlags(SegmentStoreType ... segmentTypes) {
        HashSet<@NonNull SegmentStoreType> segments = new HashSet<SegmentStoreType>();
        SegmentStoreType[] segmentStoreTypeArray = segmentTypes;
        int n = segmentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            @Nullable SegmentStoreType segmentType = segmentStoreTypeArray[n2];
            if (segmentType != null) {
                segments.add(segmentType);
            }
            ++n2;
        }
        return segments;
    }

    private static <E extends ISegment> ISegmentStore<E> createTreeMapStore() {
        return new TreeMapStore();
    }

    private static <E extends ISegment> ISegmentStore<E> createArrayListStore() {
        return new ArrayListStore();
    }

    private static <E extends ISegment> ISegmentStore<E> createLazyArrayListStore() {
        return new LazyArrayListStore();
    }

    public static enum SegmentStoreType {
        Fast,
        Stable,
        Distinct,
        OnDisk;

    }
}

