/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.BlockIO;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.DiskWriteModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.InputOutputStateProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Request;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class BlockFrontMergeHandler
extends KernelEventHandler {
    private final InputOutputStateProvider fStateProvider;

    public BlockFrontMergeHandler(IKernelAnalysisEventLayout layout, InputOutputStateProvider sp) {
        super(layout);
        this.fStateProvider = sp;
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        BlockIO bio;
        ITmfEventField content = event.getContent();
        long ts = event.getTimestamp().getValue();
        Long sector = (Long)NonNullUtils.checkNotNull((Object)((Long)content.getField(new String[]{this.getLayout().fieldBlockSector()}).getValue()));
        int nrSector = ((Long)content.getField(new String[]{this.getLayout().fieldBlockNrSector()}).getValue()).intValue();
        Long rqSector = sector + (long)nrSector;
        int dev = ((Long)content.getField(new String[]{this.getLayout().fieldBlockDeviceId()}).getValue()).intValue();
        int rwbs = ((Long)content.getField(new String[]{this.getLayout().fieldBlockRwbs()}).getValue()).intValue();
        DiskWriteModel disk = this.fStateProvider.getDisk(dev);
        Request request = disk.getWaitingRequest(rqSector);
        if (request == null) {
            bio = new BlockIO(rqSector, 1, disk, rwbs);
            request = new Request(bio);
        }
        bio = new BlockIO(sector, nrSector, disk, rwbs);
        request.insertBio(bio);
        disk.updateWaitingRequest(ts, request);
    }
}

