/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;

public class DimacsArrayReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final ISolver solver;

    public DimacsArrayReader(ISolver solver) {
        this.solver = solver;
    }

    protected boolean handleConstr(int gateType, int output, int[] inputs) throws ContradictionException {
        VecInt literals = new VecInt(inputs);
        this.solver.addClause(literals);
        return true;
    }

    public ISolver parseInstance(int[] gateType, int[] outputs, int[][] inputs, int maxVar) throws ContradictionException {
        this.solver.reset();
        this.solver.newVar(maxVar);
        this.solver.setExpectedNumberOfClauses(outputs.length);
        int i = 0;
        while (i < outputs.length) {
            this.handleConstr(gateType[i], outputs[i], inputs[i]);
            ++i;
        }
        return this.solver;
    }

    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer(4 * model.length);
        int[] nArray = model;
        int n = model.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            stb.append(element);
            stb.append(" ");
            ++n2;
        }
        stb.append("0");
        return stb.toString();
    }

    protected ISolver getSolver() {
        return this.solver;
    }
}

