/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.inputoutput;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.LinuxTestCase;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;

public class IoTestCase
extends LinuxTestCase {
    public IoTestCase(String filename) {
        super(filename);
    }

    public Multimap<Integer, SectorCountInfo> getSectorCount() {
        return HashMultimap.create();
    }

    public Map<Integer, DiskInfo> getDiskInfo() {
        return Collections.EMPTY_MAP;
    }

    public Collection<DiskActivity> getDiskActivity() {
        return Collections.emptyList();
    }

    private static List<Long> getTimeRequested(TimeQueryFilter filter) {
        ArrayList<Long> times = new ArrayList<Long>();
        long[] lArray = filter.getTimesRequested();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long time = lArray[n2];
            times.add(time);
            ++n2;
        }
        return times;
    }

    public static class DiskActivity {
        private static final String READ_NAME = "read";
        private static final String WRITE_NAME = "write";
        private final long fStartTime;
        private final long fEndTime;
        private final int fResolution;
        private final double[] fActivity;
        private final IoOperationType fType;
        private final String fDiskName;

        public DiskActivity(long startTime, long endTime, int res, double[] activity, IoOperationType type, String diskName) {
            this.fStartTime = startTime;
            this.fEndTime = endTime;
            this.fResolution = res;
            this.fActivity = activity;
            this.fType = type;
            this.fDiskName = diskName;
        }

        public Map<String, Object> getTimeQuery() {
            TimeQueryFilter filter = new TimeQueryFilter(this.fStartTime, this.fEndTime, this.fResolution);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("requested_times", IoTestCase.getTimeRequested(filter));
            return parameters;
        }

        public Map<String, Object> getTimeQueryForModel(TmfTreeModel<TmfTreeDataModel> model) {
            long diskId = this.getDiskId(model);
            long selectionId = -1L;
            for (TmfTreeDataModel oneModel : model.getEntries()) {
                if (oneModel.getParentId() == diskId) {
                    switch (this.fType) {
                        case READ: {
                            if (!oneModel.getName().equals(READ_NAME)) break;
                            selectionId = oneModel.getId();
                            break;
                        }
                        case WRITE: {
                            if (!oneModel.getName().equals(WRITE_NAME)) break;
                            selectionId = oneModel.getId();
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown type");
                        }
                    }
                }
                oneModel.getName();
            }
            if (selectionId == -1L) {
                throw new NoSuchElementException("Requested entry not found for " + this.fDiskName + ' ' + this.fType);
            }
            Map<String, Object> parameters = this.getTimeQuery();
            parameters.put("requested_items", Collections.singletonList(selectionId));
            return parameters;
        }

        private long getDiskId(TmfTreeModel<TmfTreeDataModel> model) {
            for (TmfTreeDataModel oneModel : model.getEntries()) {
                if (!this.fDiskName.equals(oneModel.getName())) continue;
                return oneModel.getId();
            }
            throw new NoSuchElementException("Disk not found " + this.fDiskName);
        }

        public double[] getActivity() {
            return this.fActivity;
        }

        public String toString() {
            return String.valueOf(this.fDiskName) + ' ' + this.fType + " time range: " + this.fStartTime + ',' + this.fEndTime;
        }
    }

    public static class DiskInfo {
        private final String fDeviceString;
        private final String fDiskName;
        private final boolean fActive;

        public DiskInfo(String deviceString, String diskname, boolean active) {
            this.fDeviceString = deviceString;
            this.fDiskName = diskname;
            this.fActive = active;
        }

        public String getDeviceString() {
            return this.fDeviceString;
        }

        public String getDeviceName() {
            return this.fDiskName;
        }

        public boolean hasActivity() {
            return this.fActive;
        }
    }

    public static class SectorCountInfo {
        private final long fTs;
        private final IoOperationType fType;
        private final long fSectors;

        public SectorCountInfo(long ts, IoOperationType type, long nbSectors) {
            this.fTs = ts;
            this.fType = type;
            this.fSectors = nbSectors;
        }

        public long getTimestamp() {
            return this.fTs;
        }

        public IoOperationType getType() {
            return this.fType;
        }

        public double getNbSectors() {
            return this.fSectors;
        }
    }
}

