/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.rtsj.framework;

public class ArgsBuffer {
    private byte[] elems;
    private int size;
    private int h;
    private int t;
    private int used;

    public ArgsBuffer(int size) {
        this.size = size;
        this.used = 0;
        this.elems = new byte[size];
        this.t = 0;
        this.h = 0;
    }

    public boolean check(int n) {
        return this.used + n <= this.size;
    }

    public void dequeue(int n) {
        this.used -= n;
        if (this.size != 0) {
            this.h = (this.h + n) % this.size;
        }
    }

    public void writeBoolean(boolean b) {
        this.writeByte(b ? (byte)1 : 0);
    }

    public void writeByte(byte b) {
        if (this.used == this.size) {
            return;
        }
        ++this.used;
        this.elems[this.t] = b;
        this.t = (this.t + 1) % this.size;
    }

    public void writeCharacter(int v) {
        this.writeByte((byte)(0xFF & v >> 8));
        this.writeByte((byte)(0xFF & v));
    }

    public void writeShort(int v) {
        this.writeByte((byte)(0xFF & v >> 8));
        this.writeByte((byte)(0xFF & v));
    }

    public void writeInteger(int v) {
        this.writeByte((byte)(0xFF & v >> 24));
        this.writeByte((byte)(0xFF & v >> 16));
        this.writeByte((byte)(0xFF & v >> 8));
        this.writeByte((byte)(0xFF & v));
    }

    public void writeLong(long v) {
        this.writeByte((byte)(0xFFL & v >> 56));
        this.writeByte((byte)(0xFFL & v >> 48));
        this.writeByte((byte)(0xFFL & v >> 40));
        this.writeByte((byte)(0xFFL & v >> 32));
        this.writeByte((byte)(0xFFL & v >> 24));
        this.writeByte((byte)(0xFFL & v >> 16));
        this.writeByte((byte)(0xFFL & v >> 8));
        this.writeByte((byte)(0xFFL & v));
    }

    public void writeFloat(float f) {
        this.writeInteger(Float.floatToRawIntBits(f));
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToRawLongBits(d));
    }

    public void writeString(String s) {
        this.writeShort(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c <= '\u0080') {
                this.writeByte((byte)c);
            } else if (c <= '\u07ff') {
                this.writeByte((byte)(0xC0 | 0x1F & c >> 6));
                this.writeByte((byte)(0x80 | 0x3F & c));
            } else {
                this.writeByte((byte)(0xE0 | 0xF & c >> 12));
                this.writeByte((byte)(0x80 | 0x3F & c >> 6));
                this.writeByte((byte)(0x80 | 0x3F & c));
            }
            ++i;
        }
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public byte readByte() {
        if (this.used == 0) {
            return 0;
        }
        --this.used;
        byte b = this.elems[this.h];
        this.h = (this.h + 1) % this.size;
        return b;
    }

    public byte readByteAt(int i) {
        if (this.used == 0) {
            return 0;
        }
        byte b = this.elems[(this.h + i) % this.size];
        return b;
    }

    public char readCharacter() {
        byte a = this.readByte();
        byte b = this.readByte();
        return (char)(a << 8 | b & 0xFF);
    }

    public short readShort() {
        byte a = this.readByte();
        byte b = this.readByte();
        return (short)(a << 8 | b & 0xFF);
    }

    public int readInteger() {
        byte a = this.readByte();
        byte b = this.readByte();
        byte c = this.readByte();
        byte d = this.readByte();
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
    }

    public long readLong() {
        byte a = this.readByte();
        byte b = this.readByte();
        byte c = this.readByte();
        byte d = this.readByte();
        byte e = this.readByte();
        byte f = this.readByte();
        byte g = this.readByte();
        byte h = this.readByte();
        return (long)(a & 0xFF) << 56 | (long)(b & 0xFF) << 48 | (long)(c & 0xFF) << 40 | (long)(d & 0xFF) << 32 | (long)(e & 0xFF) << 24 | (long)(f & 0xFF) << 16 | (long)(g & 0xFF) << 8 | (long)(h & 0xFF);
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInteger());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public void readString(StringBuffer sb) {
        int n = this.readShort();
        sb.setLength(n);
        int i = 0;
        while (i < n) {
            byte b;
            char u;
            byte a = this.readByte();
            if ((a & 0x80) == 0) {
                u = (char)a;
            } else if ((a & 0xE0) == 192) {
                b = this.readByte();
                u = (char)((a & 0x1F) << 6 | b & 0x3F);
            } else {
                b = this.readByte();
                byte c = this.readByte();
                u = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
            }
            sb.setCharAt(i, u);
            ++i;
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getUsed() {
        return this.used;
    }

    public void copy(ArgsBuffer arg) {
        int argSize = arg.getUsed();
        int i = 0;
        while (i < argSize) {
            this.writeByte(arg.readByteAt(i));
            ++i;
        }
    }

    public void copy(ArgsBuffer arg, int offset) {
        int argSize = arg.getUsed();
        if (this.used + argSize > this.size) {
            return;
        }
        if (argSize > 0) {
            int max = this.t;
            int min = (this.h + offset) % this.size;
            int i = max;
            while (i >= min) {
                if (i < 0) {
                    i = this.size - 1;
                }
                int desti = (i + argSize) % this.size;
                this.elems[desti] = this.elems[i];
                --i;
            }
            this.t = (this.t + argSize) % this.size;
            this.used += argSize;
            i = 0;
            while (i < argSize) {
                this.elems[(this.h + offset + i) % this.size] = arg.readByteAt(i);
                ++i;
            }
        }
    }
}

